/*
 * Decompiled with CFR 0.152.
 */
package javax.print;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.DocAttributeSet;
import sun.reflect.misc.ReflectUtil;

public final class SimpleDoc
implements Doc {
    private DocFlavor flavor;
    private DocAttributeSet attributes;
    private Object printData;
    private Reader reader;
    private InputStream inStream;

    public SimpleDoc(Object printData, DocFlavor flavor, DocAttributeSet attributes) {
        if (flavor == null || printData == null) {
            throw new IllegalArgumentException("null argument(s)");
        }
        Class<?> repClass = null;
        try {
            String className = flavor.getRepresentationClassName();
            ReflectUtil.checkPackageAccess(className);
            repClass = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("unknown representation class");
        }
        if (!repClass.isInstance(printData)) {
            throw new IllegalArgumentException("data is not of declared type");
        }
        this.flavor = flavor;
        if (attributes != null) {
            this.attributes = AttributeSetUtilities.unmodifiableView(attributes);
        }
        this.printData = printData;
    }

    @Override
    public DocFlavor getDocFlavor() {
        return this.flavor;
    }

    @Override
    public DocAttributeSet getAttributes() {
        return this.attributes;
    }

    @Override
    public Object getPrintData() throws IOException {
        return this.printData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getReaderForText() throws IOException {
        if (this.printData instanceof Reader) {
            return (Reader)this.printData;
        }
        SimpleDoc simpleDoc = this;
        synchronized (simpleDoc) {
            if (this.reader != null) {
                return this.reader;
            }
            if (this.printData instanceof char[]) {
                this.reader = new CharArrayReader((char[])this.printData);
            } else if (this.printData instanceof String) {
                this.reader = new StringReader((String)this.printData);
            }
        }
        return this.reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getStreamForBytes() throws IOException {
        if (this.printData instanceof InputStream) {
            return (InputStream)this.printData;
        }
        SimpleDoc simpleDoc = this;
        synchronized (simpleDoc) {
            if (this.inStream != null) {
                return this.inStream;
            }
            if (this.printData instanceof byte[]) {
                this.inStream = new ByteArrayInputStream((byte[])this.printData);
            }
        }
        return this.inStream;
    }
}

