/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.jules;

import java.util.ArrayList;
import java.util.LinkedList;
import sun.java2d.jules.IdleTileCache;
import sun.java2d.jules.JulesAATileGenerator;
import sun.java2d.jules.JulesTile;
import sun.java2d.jules.TileTrapContainer;

public class TileWorker
implements Runnable {
    static final int RASTERIZED_TILE_SYNC_GRANULARITY = 8;
    final ArrayList<JulesTile> rasterizedTileConsumerCache = new ArrayList();
    final LinkedList<JulesTile> rasterizedBuffers = new LinkedList();
    IdleTileCache tileCache;
    JulesAATileGenerator tileGenerator;
    int workerStartIndex;
    volatile int consumerPos = 0;
    int mainThreadCnt = 0;
    int workerCnt = 0;
    int doubled = 0;

    public TileWorker(JulesAATileGenerator tileGenerator, int workerStartIndex, IdleTileCache tileCache) {
        this.tileGenerator = tileGenerator;
        this.workerStartIndex = workerStartIndex;
        this.tileCache = tileCache;
    }

    @Override
    public void run() {
        ArrayList<JulesTile> tiles = new ArrayList<JulesTile>(16);
        for (int i = this.workerStartIndex; i < this.tileGenerator.getTileCount(); ++i) {
            TileTrapContainer tile = this.tileGenerator.getTrapContainer(i);
            if (tile != null && tile.getTileAlpha() == 127) {
                JulesTile rasterizedTile = this.tileGenerator.rasterizeTile(i, this.tileCache.getIdleTileWorker(this.tileGenerator.getTileCount() - i - 1));
                tiles.add(rasterizedTile);
                if (tiles.size() > 8) {
                    this.addRasterizedTiles(tiles);
                    tiles.clear();
                }
            }
            i = Math.max(i, this.consumerPos + 4);
        }
        this.addRasterizedTiles(tiles);
        this.tileCache.disposeRasterizerResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JulesTile getPreRasterizedTile(int tilePos) {
        JulesTile t;
        JulesTile tile = null;
        if (this.rasterizedTileConsumerCache.size() == 0 && tilePos >= this.workerStartIndex) {
            LinkedList<JulesTile> linkedList = this.rasterizedBuffers;
            synchronized (linkedList) {
                this.rasterizedTileConsumerCache.addAll(this.rasterizedBuffers);
                this.rasterizedBuffers.clear();
            }
        }
        while (tile == null && this.rasterizedTileConsumerCache.size() > 0 && (t = this.rasterizedTileConsumerCache.get(0)).getTilePos() <= tilePos) {
            if (t.getTilePos() < tilePos) {
                this.tileCache.releaseTile(t);
                ++this.doubled;
            }
            if (t.getTilePos() <= tilePos) {
                this.rasterizedTileConsumerCache.remove(0);
            }
            if (t.getTilePos() != tilePos) continue;
            tile = t;
        }
        if (tile == null) {
            ++this.mainThreadCnt;
            this.consumerPos = tilePos;
        } else {
            ++this.workerCnt;
        }
        return tile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRasterizedTiles(ArrayList<JulesTile> tiles) {
        LinkedList<JulesTile> linkedList = this.rasterizedBuffers;
        synchronized (linkedList) {
            this.rasterizedBuffers.addAll(tiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeConsumerResources() {
        LinkedList<JulesTile> linkedList = this.rasterizedBuffers;
        synchronized (linkedList) {
            this.tileCache.releaseTiles(this.rasterizedBuffers);
        }
        this.tileCache.releaseTiles(this.rasterizedTileConsumerCache);
    }
}

