/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.security.AccessControlContext;
import java.security.ProtectionDomain;
import sun.misc.Unsafe;

public final class InnocuousThread
extends Thread {
    private static final Unsafe UNSAFE;
    private static final ThreadGroup THREADGROUP;
    private static final AccessControlContext ACC;
    private static final long THREADLOCALS;
    private static final long INHERITABLETHREADLOCALS;
    private static final long INHERITEDACCESSCONTROLCONTEXT;
    private volatile boolean hasRun;

    public InnocuousThread(Runnable target) {
        super(THREADGROUP, target, "anInnocuousThread");
        UNSAFE.putOrderedObject(this, INHERITEDACCESSCONTROLCONTEXT, ACC);
        this.eraseThreadLocals();
    }

    @Override
    public ClassLoader getContextClassLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    @Override
    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler x) {
    }

    @Override
    public void setContextClassLoader(ClassLoader cl) {
        throw new SecurityException("setContextClassLoader");
    }

    @Override
    public void run() {
        if (Thread.currentThread() == this && !this.hasRun) {
            this.hasRun = true;
            super.run();
        }
    }

    public void eraseThreadLocals() {
        UNSAFE.putObject((Object)this, THREADLOCALS, null);
        UNSAFE.putObject((Object)this, INHERITABLETHREADLOCALS, null);
    }

    static {
        try {
            ThreadGroup parent;
            ACC = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, null)});
            UNSAFE = Unsafe.getUnsafe();
            Class<Thread> tk = Thread.class;
            Class<ThreadGroup> gk = ThreadGroup.class;
            THREADLOCALS = UNSAFE.objectFieldOffset(tk.getDeclaredField("threadLocals"));
            INHERITABLETHREADLOCALS = UNSAFE.objectFieldOffset(tk.getDeclaredField("inheritableThreadLocals"));
            INHERITEDACCESSCONTROLCONTEXT = UNSAFE.objectFieldOffset(tk.getDeclaredField("inheritedAccessControlContext"));
            long tg = UNSAFE.objectFieldOffset(tk.getDeclaredField("group"));
            long gp = UNSAFE.objectFieldOffset(gk.getDeclaredField("parent"));
            ThreadGroup group = (ThreadGroup)UNSAFE.getObject((Object)Thread.currentThread(), tg);
            while (group != null && (parent = (ThreadGroup)UNSAFE.getObject((Object)group, gp)) != null) {
                group = parent;
            }
            THREADGROUP = new ThreadGroup(group, "InnocuousThreadGroup");
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

