/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import sun.rmi.runtime.Log;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Connection;
import sun.rmi.transport.proxy.RMISocketInfo;
import sun.rmi.transport.tcp.TCPChannel;
import sun.rmi.transport.tcp.TCPTransport;

public class TCPConnection
implements Connection {
    private Socket socket;
    private Channel channel;
    private InputStream in = null;
    private OutputStream out = null;
    private long expiration = Long.MAX_VALUE;
    private long lastuse = Long.MIN_VALUE;
    private long roundtrip = 5L;

    TCPConnection(TCPChannel ch, Socket s, InputStream in, OutputStream out) {
        this.socket = s;
        this.channel = ch;
        this.in = in;
        this.out = out;
    }

    TCPConnection(TCPChannel ch, InputStream in, OutputStream out) {
        this(ch, null, in, out);
    }

    TCPConnection(TCPChannel ch, Socket s) {
        this(ch, s, null, null);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            this.out = new BufferedOutputStream(this.socket.getOutputStream());
        }
        return this.out;
    }

    @Override
    public void releaseOutputStream() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.in == null) {
            this.in = new BufferedInputStream(this.socket.getInputStream());
        }
        return this.in;
    }

    @Override
    public void releaseInputStream() {
    }

    @Override
    public boolean isReusable() {
        if (this.socket != null && this.socket instanceof RMISocketInfo) {
            return ((RMISocketInfo)((Object)this.socket)).isReusable();
        }
        return true;
    }

    void setExpiration(long time) {
        this.expiration = time;
    }

    void setLastUseTime(long time) {
        this.lastuse = time;
    }

    boolean expired(long time) {
        return this.expiration <= time;
    }

    public boolean isDead() {
        OutputStream o;
        InputStream i;
        long start = System.currentTimeMillis();
        if (this.roundtrip > 0L && start < this.lastuse + this.roundtrip) {
            return false;
        }
        try {
            i = this.getInputStream();
            o = this.getOutputStream();
        }
        catch (IOException e) {
            return true;
        }
        int response = 0;
        try {
            o.write(82);
            o.flush();
            response = i.read();
        }
        catch (IOException ex) {
            TCPTransport.tcpLog.log(Log.VERBOSE, "exception: ", ex);
            TCPTransport.tcpLog.log(Log.BRIEF, "server ping failed");
            return true;
        }
        if (response == 83) {
            this.roundtrip = (System.currentTimeMillis() - start) * 2L;
            return false;
        }
        if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
            TCPTransport.tcpLog.log(Log.BRIEF, response == -1 ? "server has been deactivated" : "server protocol error: ping response = " + response);
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        TCPTransport.tcpLog.log(Log.BRIEF, "close connection");
        if (this.socket != null) {
            this.socket.close();
        } else {
            this.in.close();
            this.out.close();
        }
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }
}

