/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors.cliparams;

import amazon.fws.clicommando.config.ParamConfig;
import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.messages.ErrorMessages;
import amazon.fws.clicommando.processors.cliparams.MultipleCliParamProcessor;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.cli.CommandLine;

public class EscapingMapCliParamProcessor
extends MultipleCliParamProcessor {
    public EscapingMapCliParamProcessor(ParamConfig paramConfig, String[] commandLineArguments) {
        super(paramConfig, commandLineArguments);
    }

    public void loadValuesFromCommandLine(CommandLine line) throws CliCommandoException {
        String usedOption = this.getUsedOptionName(line, this.paramConfig.getFirstOption());
        if (usedOption == null) {
            return;
        }
        String[] optionValues = line.getOptionValues(usedOption);
        if (optionValues != null) {
            StringBuilder superOption = new StringBuilder();
            Iterator<String> optionIter = Arrays.asList(optionValues).iterator();
            while (optionIter.hasNext()) {
                String optionValue = optionIter.next();
                superOption.append(optionValue);
                if (!optionIter.hasNext()) continue;
                superOption.append(" ");
            }
            char keyValueSeparator = this.getOrDefault(this.paramConfig.getFirstOption().getKeyValueSeparator(), "=").charAt(0);
            char mapEntrySeparator = this.getOrDefault(this.paramConfig.getFirstOption().getMapEntrySeparator(), ",").charAt(0);
            char[] quoteCharacters = this.getOrDefault(this.paramConfig.getFirstOption().getValueQuoteChar(), "\"'").toCharArray();
            Parser parser = new Parser(Character.valueOf(keyValueSeparator), Character.valueOf(mapEntrySeparator), quoteCharacters);
            Map<String, String> parsedResults = parser.parse(superOption.toString());
            if (parsedResults != null && !parsedResults.isEmpty()) {
                this.paramConfig.getValuesMap().add(parsedResults);
            }
        }
    }

    private String getOrDefault(String value, String defaultValue) {
        return value == null ? defaultValue : value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Parser {
        private static final State START_KEY = new State("StartKey");
        private static final State START_VALUE = new State("StartValue");
        private static final State ESCAPE_NEXT = new State("EscapeNext");
        private static final State QUOTE_END = new State("QuoteEnd");
        private final Map<String, String> result = new LinkedHashMap<String, String>();
        private final Character keyValueSeparator;
        private final Character pairSeparator;
        private final Map<Character, QuoteState> quoteStates;
        private Deque<State> parserStack;
        private StringBuilder inflightValue = new StringBuilder();
        private String key = null;
        private String value = null;
        private String inputString;
        private LinkedList<Character> characters;

        private Parser(Character keyValueSeparator, Character pairSeparator, char[] quoteCharacters) {
            this.keyValueSeparator = keyValueSeparator;
            this.pairSeparator = pairSeparator;
            this.quoteStates = new HashMap<Character, QuoteState>();
            for (char quoteChar : quoteCharacters) {
                this.quoteStates.put(Character.valueOf(quoteChar), new QuoteState("Quote=" + quoteChar, quoteChar));
            }
            this.parserStack = new LinkedList<State>();
            this.parserStack.push(START_KEY);
        }

        private void addKeyValue(String key, String value) {
            if (key.length() == 0 || value.length() == 0) {
                this.badInput("Bad key or value. Key: \"" + key + "\" -- Value: \"" + value + "\".");
            }
            this.result.put(key, value);
        }

        private void changeState(State newState) {
            if (!newState.equals(this.parserStack.peek())) {
                this.parserStack.push(newState);
            }
        }

        private State currentState() {
            return this.parserStack.peek();
        }

        private boolean stateContains(State state) {
            return this.parserStack.contains(state);
        }

        private void popToState(State destState) {
            State current;
            while ((current = this.parserStack.pop()) != destState && current != null) {
            }
        }

        private String stateString() {
            StringBuilder result = new StringBuilder();
            Iterator<State> stateIter = this.parserStack.iterator();
            while (stateIter.hasNext()) {
                result.append(stateIter.next().toString());
                if (!stateIter.hasNext()) continue;
                result.append(" => ");
            }
            return result.toString();
        }

        public Map<String, String> parse(String input) {
            this.parseInput(input);
            if (this.stateContains(START_VALUE)) {
                for (QuoteState quoteState : this.quoteStates.values()) {
                    if (!this.stateContains(quoteState) || this.stateContains(QUOTE_END)) continue;
                    this.badInput("Unterminated quoted string.");
                }
                this.value = this.inflightValue.toString();
                this.addKeyValue(this.key, this.value);
            } else if (!this.currentState().equals(START_KEY)) {
                this.badInput("Not all states transitioned on last key value pair. States: (" + this.stateString() + ").");
            }
            return this.result;
        }

        private void parseInput(String input) {
            Character current;
            this.inputString = input;
            this.characters = new LinkedList();
            for (char c : input.toCharArray()) {
                this.characters.add(Character.valueOf(c));
            }
            while ((current = this.characters.poll()) != null) {
                if (this.handleEscape(current) || this.handleQuoting(current)) continue;
                if (current == this.keyValueSeparator) {
                    this.handleKey();
                    continue;
                }
                if (current == this.pairSeparator || current.charValue() == ' ' || current.charValue() == '\t') {
                    Character next = this.characters.peek();
                    while (next != null && this.isWhitespace(next.charValue())) {
                        this.characters.poll();
                        next = this.characters.peek();
                    }
                    this.handleValue(current.charValue());
                    continue;
                }
                this.inflightValue.append(current);
            }
        }

        private boolean handleQuoting(Character current) {
            QuoteState quoteState = this.quoteStates.get(current);
            if (quoteState != null && (this.currentState().equals(quoteState) || !(this.currentState() instanceof QuoteState))) {
                this.handleQuote(quoteState);
                return true;
            }
            if (this.currentState() instanceof QuoteState) {
                this.inflightValue.append(current);
                return true;
            }
            return false;
        }

        private boolean handleEscape(Character current) {
            if (current.charValue() == '\\' && !this.currentState().equals(ESCAPE_NEXT)) {
                this.changeState(ESCAPE_NEXT);
                return true;
            }
            if (this.currentState().equals(ESCAPE_NEXT)) {
                this.inflightValue.append(current);
                this.parserStack.pop();
                return true;
            }
            return false;
        }

        private boolean isWhitespace(char c) {
            return c == ' ' || c == '\t' || c == '\n' || c == '\r';
        }

        private String highlightedPosition(int position, String toHighlight) {
            if (position > toHighlight.length()) {
                return toHighlight;
            }
            if (position == toHighlight.length()) {
                return toHighlight + "[]";
            }
            String left = toHighlight.substring(0, position);
            String center = toHighlight.substring(position, position + 1);
            String right = toHighlight.substring(position + 1, toHighlight.length());
            return left + "[" + center + "]" + right;
        }

        private void badInput(String message) {
            int position = this.inputString.length() - this.characters.size() - 1;
            if (position < 0) {
                position = 0;
            }
            String highlighted = this.highlightedPosition(position, this.inputString);
            throw new BadInputException(ErrorMessages.ErrorCode.BAD_REQUEST, message + " Error at position " + position + ": " + highlighted);
        }

        private void handleQuote(QuoteState quoteState) {
            if (this.stateContains(QUOTE_END)) {
                this.badInput("Found unexpected quote character.");
            }
            if (this.currentState().equals(quoteState)) {
                this.changeState(QUOTE_END);
            } else if (!(this.currentState() instanceof QuoteState)) {
                this.changeState(quoteState);
            }
        }

        private void handleKey() {
            if (!this.stateContains(START_KEY)) {
                this.badInput("Found an unquoted '=' while reading the value.");
            }
            this.popToState(START_KEY);
            this.key = this.inflightValue.toString();
            this.parserStack.push(START_VALUE);
            this.clearInflight();
        }

        private void handleValue(char current) {
            if (!this.stateContains(START_VALUE)) {
                this.badInput("Found an unquoted key pair terminator: '" + current + "' while reading the key.");
            }
            String value = this.inflightValue.toString();
            this.addKeyValue(this.key, value);
            this.popToState(START_VALUE);
            this.parserStack.push(START_KEY);
            this.clearInflight();
        }

        private void clearInflight() {
            this.inflightValue = new StringBuilder();
        }

        private static class QuoteState
        extends State {
            private final char quote;

            public QuoteState(String name, char quote) {
                super(name);
                this.quote = quote;
            }

            public int hashCode() {
                int prime = 31;
                int result = super.hashCode();
                result = 31 * result + this.quote;
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!super.equals(obj)) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                QuoteState other = (QuoteState)obj;
                return this.quote == other.quote;
            }

            public String toString() {
                return "QuoteState [quote=" + this.quote + ", State=" + super.toString() + "]";
            }
        }

        private static class State {
            protected final String name;

            public State(String name) {
                this.name = name;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                State other = (State)obj;
                return !(this.name == null ? other.name != null : !this.name.equals(other.name));
            }

            public String toString() {
                return "State [name=" + this.name + "]";
            }
        }
    }
}

