/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.signature;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.xml.security.Init;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xml.utils.URI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProcessingInstructionTest
extends TestCase {
    private static String dir;
    static /* synthetic */ Class class$org$apache$xml$security$test$signature$ProcessingInstructionTest;

    public static Test suite() {
        return new TestSuite(class$org$apache$xml$security$test$signature$ProcessingInstructionTest == null ? (class$org$apache$xml$security$test$signature$ProcessingInstructionTest = ProcessingInstructionTest.class$("org.apache.xml.security.test.signature.ProcessingInstructionTest")) : class$org$apache$xml$security$test$signature$ProcessingInstructionTest);
    }

    public ProcessingInstructionTest(String string) {
        super(string);
        String string2 = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
        String string3 = System.getProperty("file.separator");
        dir = string2 + string3 + "data" + string3 + "org" + string3 + "apache" + string3 + "xml" + string3 + "security" + string3 + "testcases" + string3;
    }

    public void testProcessingInstruction() throws Exception {
        String string = dir + "upp_sign.xml";
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        File file = new File(string);
        Document document = documentBuilder.parse(new FileInputStream(file));
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        xPath.setNamespaceContext(new NamespaceContext(){

            public String getNamespaceURI(String string) {
                if (!string.equals("ds")) {
                    throw new RuntimeException();
                }
                return "http://www.w3.org/2000/09/xmldsig#";
            }

            public String getPrefix(String string) {
                return "ds";
            }

            public Iterator getPrefixes(String string) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("ds");
                return arrayList.iterator();
            }
        });
        String string2 = "//ds:Signature[1]";
        Element element = (Element)xPath.evaluate(string2, document, XPathConstants.NODE);
        String string3 = new File(".").toURL().toString();
        XMLSignature xMLSignature = new XMLSignature(element, string3);
        xMLSignature.addResourceResolver(FileResolver.getInstance());
        X509Certificate x509Certificate = xMLSignature.getKeyInfo().getX509Certificate();
        if (!xMLSignature.checkSignatureValue(x509Certificate)) {
            throw new Exception("Signature is invalid!");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Init.init();
    }

    private static class FileResolver
    extends ResourceResolverSpi {
        private static FileResolver resolver = null;

        public static synchronized ResourceResolverSpi getInstance() {
            if (resolver == null) {
                resolver = new FileResolver();
            }
            return resolver;
        }

        private FileResolver() {
        }

        public XMLSignatureInput engineResolve(Attr attr, String string) throws ResourceResolverException {
            try {
                URI uRI = new URI(attr.getNodeValue(), string);
                FileInputStream fileInputStream = new FileInputStream(dir + "out.xml");
                XMLSignatureInput xMLSignatureInput = new XMLSignatureInput((InputStream)fileInputStream);
                xMLSignatureInput.setSourceURI(uRI.toString());
                return xMLSignatureInput;
            }
            catch (Exception exception) {
                throw new ResourceResolverException("generic.EmptyMessage", exception, attr, string);
            }
        }

        public boolean engineCanResolve(Attr attr, String string) {
            return attr != null && "out.xml".equals(attr.getNodeValue());
        }
    }
}

