/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;

public final class LdapName
implements Name {
    private transient String unparsed;
    private transient Vector<Rdn> rdns;
    private transient boolean valuesCaseSensitive = false;
    static final long serialVersionUID = -1595520034788997356L;

    public LdapName(String name) throws InvalidNameException {
        this.unparsed = name;
        this.parse();
    }

    private LdapName(String name, Vector<Rdn> rdns) {
        this.unparsed = name;
        this.rdns = (Vector)rdns.clone();
    }

    private LdapName(String name, Vector<Rdn> rdns, int beg, int end) {
        this.unparsed = name;
        this.rdns = new Vector();
        for (int i = beg; i < end; ++i) {
            this.rdns.addElement(rdns.elementAt(i));
        }
    }

    @Override
    public Object clone() {
        return new LdapName(this.unparsed, this.rdns);
    }

    public String toString() {
        if (this.unparsed != null) {
            return this.unparsed;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = this.rdns.size() - 1; i >= 0; --i) {
            if (i < this.rdns.size() - 1) {
                buf.append(',');
            }
            Rdn rdn = this.rdns.elementAt(i);
            buf.append(rdn);
        }
        this.unparsed = new String(buf);
        return this.unparsed;
    }

    public boolean equals(Object obj) {
        return obj instanceof LdapName && this.compareTo(obj) == 0;
    }

    @Override
    public int compareTo(Object obj) {
        LdapName that = (LdapName)obj;
        if (obj == this || this.unparsed != null && this.unparsed.equals(that.unparsed)) {
            return 0;
        }
        int minSize = Math.min(this.rdns.size(), that.rdns.size());
        for (int i = 0; i < minSize; ++i) {
            Rdn rdn2;
            Rdn rdn1 = this.rdns.elementAt(i);
            int diff = rdn1.compareTo(rdn2 = that.rdns.elementAt(i));
            if (diff == 0) continue;
            return diff;
        }
        return this.rdns.size() - that.rdns.size();
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.rdns.size(); ++i) {
            Rdn rdn = this.rdns.elementAt(i);
            hash += rdn.hashCode();
        }
        return hash;
    }

    @Override
    public int size() {
        return this.rdns.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rdns.isEmpty();
    }

    @Override
    public Enumeration<String> getAll() {
        final Enumeration<Rdn> enum_ = this.rdns.elements();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return enum_.hasMoreElements();
            }

            @Override
            public String nextElement() {
                return ((Rdn)enum_.nextElement()).toString();
            }
        };
    }

    @Override
    public String get(int pos) {
        return this.rdns.elementAt(pos).toString();
    }

    @Override
    public Name getPrefix(int pos) {
        return new LdapName(null, this.rdns, 0, pos);
    }

    @Override
    public Name getSuffix(int pos) {
        return new LdapName(null, this.rdns, pos, this.rdns.size());
    }

    @Override
    public boolean startsWith(Name n) {
        int len2;
        int len1 = this.rdns.size();
        return len1 >= (len2 = n.size()) && this.matches(0, len2, n);
    }

    @Override
    public boolean endsWith(Name n) {
        int len2;
        int len1 = this.rdns.size();
        return len1 >= (len2 = n.size()) && this.matches(len1 - len2, len1, n);
    }

    public void setValuesCaseSensitive(boolean caseSensitive) {
        this.toString();
        this.rdns = null;
        try {
            this.parse();
        }
        catch (InvalidNameException e) {
            throw new IllegalStateException("Cannot parse name: " + this.unparsed);
        }
        this.valuesCaseSensitive = caseSensitive;
    }

    private boolean matches(int beg, int end, Name n) {
        for (int i = beg; i < end; ++i) {
            Rdn rdn;
            if (n instanceof LdapName) {
                LdapName ln = (LdapName)n;
                rdn = ln.rdns.elementAt(i - beg);
            } else {
                String rdnString = n.get(i - beg);
                try {
                    rdn = new DnParser(rdnString, this.valuesCaseSensitive).getRdn();
                }
                catch (InvalidNameException e) {
                    return false;
                }
            }
            if (rdn.equals(this.rdns.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Name addAll(Name suffix) throws InvalidNameException {
        return this.addAll(this.size(), suffix);
    }

    @Override
    public Name addAll(int pos, Name suffix) throws InvalidNameException {
        if (suffix instanceof LdapName) {
            LdapName s = (LdapName)suffix;
            for (int i = 0; i < s.rdns.size(); ++i) {
                this.rdns.insertElementAt(s.rdns.elementAt(i), pos++);
            }
        } else {
            Enumeration<String> comps = suffix.getAll();
            while (comps.hasMoreElements()) {
                DnParser p = new DnParser(comps.nextElement(), this.valuesCaseSensitive);
                this.rdns.insertElementAt(p.getRdn(), pos++);
            }
        }
        this.unparsed = null;
        return this;
    }

    @Override
    public Name add(String comp) throws InvalidNameException {
        return this.add(this.size(), comp);
    }

    @Override
    public Name add(int pos, String comp) throws InvalidNameException {
        Rdn rdn = new DnParser(comp, this.valuesCaseSensitive).getRdn();
        this.rdns.insertElementAt(rdn, pos);
        this.unparsed = null;
        return this;
    }

    @Override
    public Object remove(int pos) throws InvalidNameException {
        String comp = this.get(pos);
        this.rdns.removeElementAt(pos);
        this.unparsed = null;
        return comp;
    }

    private void parse() throws InvalidNameException {
        this.rdns = new DnParser(this.unparsed, this.valuesCaseSensitive).getDn();
    }

    private static boolean isWhitespace(char c) {
        return c == ' ' || c == '\r';
    }

    public static String escapeAttributeValue(Object val) {
        return TypeAndValue.escapeValue(val);
    }

    public static Object unescapeAttributeValue(String val) {
        return TypeAndValue.unescapeValue(val);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.toString());
        s.writeBoolean(this.valuesCaseSensitive);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.unparsed = (String)s.readObject();
        this.valuesCaseSensitive = s.readBoolean();
        try {
            this.parse();
        }
        catch (InvalidNameException e) {
            throw new StreamCorruptedException("Invalid name: " + this.unparsed);
        }
    }

    static class TypeAndValue {
        private final String type;
        private final String value;
        private final boolean binary;
        private final boolean valueCaseSensitive;
        private String comparable = null;

        TypeAndValue(String type, String value, boolean valueCaseSensitive) {
            this.type = type;
            this.value = value;
            this.binary = value.startsWith("#");
            this.valueCaseSensitive = valueCaseSensitive;
        }

        public String toString() {
            return this.type + "=" + this.value;
        }

        public int compareTo(Object obj) {
            TypeAndValue that = (TypeAndValue)obj;
            int diff = this.type.compareToIgnoreCase(that.type);
            if (diff != 0) {
                return diff;
            }
            if (this.value.equals(that.value)) {
                return 0;
            }
            return this.getValueComparable().compareTo(that.getValueComparable());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TypeAndValue)) {
                return false;
            }
            TypeAndValue that = (TypeAndValue)obj;
            return this.type.equalsIgnoreCase(that.type) && (this.value.equals(that.value) || this.getValueComparable().equals(that.getValueComparable()));
        }

        public int hashCode() {
            return this.type.toUpperCase(Locale.ENGLISH).hashCode() + this.getValueComparable().hashCode();
        }

        String getType() {
            return this.type;
        }

        Object getUnescapedValue() {
            return TypeAndValue.unescapeValue(this.value);
        }

        private String getValueComparable() {
            if (this.comparable != null) {
                return this.comparable;
            }
            if (this.binary) {
                this.comparable = this.value.toUpperCase(Locale.ENGLISH);
            } else {
                this.comparable = (String)TypeAndValue.unescapeValue(this.value);
                if (!this.valueCaseSensitive) {
                    this.comparable = this.comparable.toUpperCase(Locale.ENGLISH);
                }
            }
            return this.comparable;
        }

        static String escapeValue(Object val) {
            return val instanceof byte[] ? TypeAndValue.escapeBinaryValue((byte[])val) : TypeAndValue.escapeStringValue((String)val);
        }

        private static String escapeStringValue(String val) {
            int trail;
            int lead;
            String escapees = ",=+<>#;\"\\";
            char[] chars = val.toCharArray();
            StringBuffer buf = new StringBuffer(2 * val.length());
            for (lead = 0; lead < chars.length && LdapName.isWhitespace(chars[lead]); ++lead) {
            }
            for (trail = chars.length - 1; trail >= 0 && LdapName.isWhitespace(chars[trail]); --trail) {
            }
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (i < lead || i > trail || ",=+<>#;\"\\".indexOf(c) >= 0) {
                    buf.append('\\');
                }
                buf.append(c);
            }
            return new String(buf);
        }

        private static String escapeBinaryValue(byte[] val) {
            StringBuffer buf = new StringBuffer(1 + 2 * val.length);
            buf.append("#");
            for (int i = 0; i < val.length; ++i) {
                byte b = val[i];
                buf.append(Character.forDigit(0xF & b >>> 4, 16));
                buf.append(Character.forDigit(0xF & b, 16));
            }
            return new String(buf).toUpperCase(Locale.ENGLISH);
        }

        static Object unescapeValue(String val) {
            int beg;
            char[] chars = val.toCharArray();
            int end = chars.length;
            for (beg = 0; beg < end && LdapName.isWhitespace(chars[beg]); ++beg) {
            }
            while (beg < end && LdapName.isWhitespace(chars[end - 1])) {
                --end;
            }
            if (end != chars.length && beg < end && chars[end - 1] == '\\') {
                ++end;
            }
            if (beg >= end) {
                return "";
            }
            if (chars[beg] == '#') {
                return TypeAndValue.decodeHexPairs(chars, ++beg, end);
            }
            if (chars[beg] == '\"' && chars[end - 1] == '\"') {
                ++beg;
                --end;
            }
            StringBuffer buf = new StringBuffer(end - beg);
            int esc = -1;
            for (int i = beg; i < end; ++i) {
                if (chars[i] == '\\' && i + 1 < end) {
                    if (!Character.isLetterOrDigit(chars[i + 1])) {
                        buf.append(chars[++i]);
                        esc = i;
                        continue;
                    }
                    byte[] utf8 = TypeAndValue.getUtf8Octets(chars, i, end);
                    if (utf8.length > 0) {
                        try {
                            buf.append(new String(utf8, "UTF8"));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                        i += utf8.length * 3 - 1;
                        continue;
                    }
                    throw new IllegalArgumentException("Not a valid attribute string value:" + val + ", improper usage of backslash");
                }
                buf.append(chars[i]);
            }
            int len = buf.length();
            if (LdapName.isWhitespace(buf.charAt(len - 1)) && esc != end - 1) {
                buf.setLength(len - 1);
            }
            return new String(buf);
        }

        private static byte[] decodeHexPairs(char[] chars, int beg, int end) {
            byte[] bytes = new byte[(end - beg) / 2];
            int i = 0;
            while (beg + 1 < end) {
                int hi = Character.digit(chars[beg], 16);
                int lo = Character.digit(chars[beg + 1], 16);
                if (hi < 0 || lo < 0) break;
                bytes[i] = (byte)((hi << 4) + lo);
                beg += 2;
                ++i;
            }
            if (beg != end) {
                throw new IllegalArgumentException("Illegal attribute value: #" + new String(chars));
            }
            return bytes;
        }

        private static byte[] getUtf8Octets(char[] chars, int beg, int end) {
            byte[] utf8 = new byte[(end - beg) / 3];
            int len = 0;
            while (beg + 2 < end && chars[beg++] == '\\') {
                int hi = Character.digit(chars[beg++], 16);
                int lo = Character.digit(chars[beg++], 16);
                if (hi < 0 || lo < 0) break;
                utf8[len++] = (byte)((hi << 4) + lo);
            }
            if (len == utf8.length) {
                return utf8;
            }
            byte[] res = new byte[len];
            System.arraycopy(utf8, 0, res, 0, len);
            return res;
        }
    }

    static class Rdn {
        private final Vector<TypeAndValue> tvs = new Vector();

        Rdn() {
        }

        void add(TypeAndValue tv) {
            int i;
            for (i = 0; i < this.tvs.size(); ++i) {
                int diff = tv.compareTo(this.tvs.elementAt(i));
                if (diff == 0) {
                    return;
                }
                if (diff < 0) break;
            }
            this.tvs.insertElementAt(tv, i);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.tvs.size(); ++i) {
                if (i > 0) {
                    buf.append('+');
                }
                buf.append(this.tvs.elementAt(i));
            }
            return new String(buf);
        }

        public boolean equals(Object obj) {
            return obj instanceof Rdn && this.compareTo(obj) == 0;
        }

        public int compareTo(Object obj) {
            Rdn that = (Rdn)obj;
            int minSize = Math.min(this.tvs.size(), that.tvs.size());
            for (int i = 0; i < minSize; ++i) {
                TypeAndValue tv = this.tvs.elementAt(i);
                int diff = tv.compareTo(that.tvs.elementAt(i));
                if (diff == 0) continue;
                return diff;
            }
            return this.tvs.size() - that.tvs.size();
        }

        public int hashCode() {
            int hash = 0;
            for (int i = 0; i < this.tvs.size(); ++i) {
                hash += this.tvs.elementAt(i).hashCode();
            }
            return hash;
        }

        Attributes toAttributes() {
            BasicAttributes attrs = new BasicAttributes(true);
            for (int i = 0; i < this.tvs.size(); ++i) {
                TypeAndValue tv = this.tvs.elementAt(i);
                Attribute attr = attrs.get(tv.getType());
                if (attr == null) {
                    attrs.put(tv.getType(), tv.getUnescapedValue());
                    continue;
                }
                attr.add(tv.getUnescapedValue());
            }
            return attrs;
        }
    }

    static class DnParser {
        private final String name;
        private final char[] chars;
        private final int len;
        private int cur = 0;
        private boolean valuesCaseSensitive;

        DnParser(String name, boolean valuesCaseSensitive) throws InvalidNameException {
            this.name = name;
            this.len = name.length();
            this.chars = name.toCharArray();
            this.valuesCaseSensitive = valuesCaseSensitive;
        }

        Vector<Rdn> getDn() throws InvalidNameException {
            this.cur = 0;
            Vector<Rdn> rdns = new Vector<Rdn>(this.len / 3 + 10);
            if (this.len == 0) {
                return rdns;
            }
            rdns.addElement(this.parseRdn());
            while (this.cur < this.len) {
                if (this.chars[this.cur] == ',' || this.chars[this.cur] == ';') {
                    ++this.cur;
                    rdns.insertElementAt(this.parseRdn(), 0);
                    continue;
                }
                throw new InvalidNameException("Invalid name: " + this.name);
            }
            return rdns;
        }

        Rdn getRdn() throws InvalidNameException {
            Rdn rdn = this.parseRdn();
            if (this.cur < this.len) {
                throw new InvalidNameException("Invalid RDN: " + this.name);
            }
            return rdn;
        }

        private Rdn parseRdn() throws InvalidNameException {
            Rdn rdn = new Rdn();
            while (this.cur < this.len) {
                this.consumeWhitespace();
                String attrType = this.parseAttrType();
                this.consumeWhitespace();
                if (this.cur >= this.len || this.chars[this.cur] != '=') {
                    throw new InvalidNameException("Invalid name: " + this.name);
                }
                ++this.cur;
                this.consumeWhitespace();
                String value = this.parseAttrValue();
                this.consumeWhitespace();
                rdn.add(new TypeAndValue(attrType, value, this.valuesCaseSensitive));
                if (this.cur >= this.len || this.chars[this.cur] != '+') break;
                ++this.cur;
            }
            return rdn;
        }

        private String parseAttrType() throws InvalidNameException {
            char c;
            int beg = this.cur;
            while (this.cur < this.len && (Character.isLetterOrDigit(c = this.chars[this.cur]) || c == '.' || c == '-' || c == ' ')) {
                ++this.cur;
            }
            while (this.cur > beg && this.chars[this.cur - 1] == ' ') {
                --this.cur;
            }
            if (beg == this.cur) {
                throw new InvalidNameException("Invalid name: " + this.name);
            }
            return new String(this.chars, beg, this.cur - beg);
        }

        private String parseAttrValue() throws InvalidNameException {
            if (this.cur < this.len && this.chars[this.cur] == '#') {
                return this.parseBinaryAttrValue();
            }
            if (this.cur < this.len && this.chars[this.cur] == '\"') {
                return this.parseQuotedAttrValue();
            }
            return this.parseStringAttrValue();
        }

        private String parseBinaryAttrValue() throws InvalidNameException {
            int beg = this.cur++;
            while (this.cur < this.len && Character.isLetterOrDigit(this.chars[this.cur])) {
                ++this.cur;
            }
            return new String(this.chars, beg, this.cur - beg);
        }

        private String parseQuotedAttrValue() throws InvalidNameException {
            int beg = this.cur++;
            while (this.cur < this.len && this.chars[this.cur] != '\"') {
                if (this.chars[this.cur] == '\\') {
                    ++this.cur;
                }
                ++this.cur;
            }
            if (this.cur >= this.len) {
                throw new InvalidNameException("Invalid name: " + this.name);
            }
            ++this.cur;
            return new String(this.chars, beg, this.cur - beg);
        }

        private String parseStringAttrValue() throws InvalidNameException {
            int end;
            int beg = this.cur;
            int esc = -1;
            while (this.cur < this.len && !this.atTerminator()) {
                if (this.chars[this.cur] == '\\') {
                    esc = ++this.cur;
                }
                ++this.cur;
            }
            if (this.cur > this.len) {
                throw new InvalidNameException("Invalid name: " + this.name);
            }
            for (end = this.cur; end > beg && LdapName.isWhitespace(this.chars[end - 1]) && esc != end - 1; --end) {
            }
            return new String(this.chars, beg, end - beg);
        }

        private void consumeWhitespace() {
            while (this.cur < this.len && LdapName.isWhitespace(this.chars[this.cur])) {
                ++this.cur;
            }
        }

        private boolean atTerminator() {
            return this.cur < this.len && (this.chars[this.cur] == ',' || this.chars[this.cur] == ';' || this.chars[this.cur] == '+');
        }
    }
}

