/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import java.beans.ConstructorProperties;

public class LockInfo {
    private String className;
    private int identityHashCode;

    @ConstructorProperties(value={"className", "identityHashCode"})
    public LockInfo(String className, int identityHashCode) {
        if (className == null) {
            throw new NullPointerException("Parameter className cannot be null");
        }
        this.className = className;
        this.identityHashCode = identityHashCode;
    }

    LockInfo(Object lock) {
        this.className = lock.getClass().getName();
        this.identityHashCode = System.identityHashCode(lock);
    }

    public String getClassName() {
        return this.className;
    }

    public int getIdentityHashCode() {
        return this.identityHashCode;
    }

    public String toString() {
        return this.className + '@' + Integer.toHexString(this.identityHashCode);
    }
}

