/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import sun.management.GcInfoBuilder;
import sun.management.GcInfoCompositeData;
import sun.management.LazyCompositeData;
import sun.management.Util;

public class GarbageCollectionNotifInfoCompositeData
extends LazyCompositeData {
    private final GarbageCollectionNotificationInfo gcNotifInfo;
    private static final String GC_NAME = "gcName";
    private static final String GC_ACTION = "gcAction";
    private static final String GC_CAUSE = "gcCause";
    private static final String GC_INFO = "gcInfo";
    private static final String[] gcNotifInfoItemNames = new String[]{"gcName", "gcAction", "gcCause", "gcInfo"};
    private static HashMap<GcInfoBuilder, CompositeType> compositeTypeByBuilder = new HashMap();
    private static CompositeType baseGcNotifInfoCompositeType = null;
    private static final long serialVersionUID = -1805123446483771292L;

    public GarbageCollectionNotifInfoCompositeData(GarbageCollectionNotificationInfo info) {
        this.gcNotifInfo = info;
    }

    public GarbageCollectionNotificationInfo getGarbageCollectionNotifInfo() {
        return this.gcNotifInfo;
    }

    public static CompositeData toCompositeData(GarbageCollectionNotificationInfo info) {
        GarbageCollectionNotifInfoCompositeData gcnicd = new GarbageCollectionNotifInfoCompositeData(info);
        return gcnicd.getCompositeData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompositeType getCompositeTypeByBuilder() {
        GcInfoBuilder builder = AccessController.doPrivileged(new PrivilegedAction<GcInfoBuilder>(){

            @Override
            public GcInfoBuilder run() {
                try {
                    Class<?> cl = Class.forName("com.sun.management.GcInfo");
                    Field f = cl.getDeclaredField("builder");
                    f.setAccessible(true);
                    return (GcInfoBuilder)f.get(GarbageCollectionNotifInfoCompositeData.this.gcNotifInfo.getGcInfo());
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
                catch (NoSuchFieldException e) {
                    return null;
                }
                catch (IllegalAccessException e) {
                    return null;
                }
            }
        });
        CompositeType gict = null;
        HashMap<GcInfoBuilder, CompositeType> hashMap = compositeTypeByBuilder;
        synchronized (hashMap) {
            gict = compositeTypeByBuilder.get(builder);
            if (gict == null) {
                OpenType[] gcNotifInfoItemTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, builder.getGcInfoCompositeType()};
                try {
                    String typeName = "sun.management.GarbageCollectionNotifInfoCompositeType";
                    gict = new CompositeType("sun.management.GarbageCollectionNotifInfoCompositeType", "CompositeType for GC notification info", gcNotifInfoItemNames, gcNotifInfoItemNames, gcNotifInfoItemTypes);
                    compositeTypeByBuilder.put(builder, gict);
                }
                catch (OpenDataException e) {
                    throw Util.newException(e);
                }
            }
        }
        return gict;
    }

    @Override
    protected CompositeData getCompositeData() {
        Object[] gcNotifInfoItemValues = new Object[]{this.gcNotifInfo.getGcName(), this.gcNotifInfo.getGcAction(), this.gcNotifInfo.getGcCause(), GcInfoCompositeData.toCompositeData(this.gcNotifInfo.getGcInfo())};
        CompositeType gict = this.getCompositeTypeByBuilder();
        try {
            return new CompositeDataSupport(gict, gcNotifInfoItemNames, gcNotifInfoItemValues);
        }
        catch (OpenDataException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String getGcName(CompositeData cd) {
        String gcname = GarbageCollectionNotifInfoCompositeData.getString(cd, GC_NAME);
        if (gcname == null) {
            throw new IllegalArgumentException("Invalid composite data: Attribute gcName has null value");
        }
        return gcname;
    }

    public static String getGcAction(CompositeData cd) {
        String gcaction = GarbageCollectionNotifInfoCompositeData.getString(cd, GC_ACTION);
        if (gcaction == null) {
            throw new IllegalArgumentException("Invalid composite data: Attribute gcAction has null value");
        }
        return gcaction;
    }

    public static String getGcCause(CompositeData cd) {
        String gccause = GarbageCollectionNotifInfoCompositeData.getString(cd, GC_CAUSE);
        if (gccause == null) {
            throw new IllegalArgumentException("Invalid composite data: Attribute gcCause has null value");
        }
        return gccause;
    }

    public static GcInfo getGcInfo(CompositeData cd) {
        CompositeData gcInfoData = (CompositeData)cd.get(GC_INFO);
        return GcInfo.from(gcInfoData);
    }

    public static void validateCompositeData(CompositeData cd) {
        if (cd == null) {
            throw new NullPointerException("Null CompositeData");
        }
        if (!GarbageCollectionNotifInfoCompositeData.isTypeMatched(GarbageCollectionNotifInfoCompositeData.getBaseGcNotifInfoCompositeType(), cd.getCompositeType())) {
            throw new IllegalArgumentException("Unexpected composite type for GarbageCollectionNotificationInfo");
        }
    }

    private static synchronized CompositeType getBaseGcNotifInfoCompositeType() {
        if (baseGcNotifInfoCompositeType == null) {
            try {
                OpenType[] baseGcNotifInfoItemTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, GcInfoCompositeData.getBaseGcInfoCompositeType()};
                baseGcNotifInfoCompositeType = new CompositeType("sun.management.BaseGarbageCollectionNotifInfoCompositeType", "CompositeType for Base GarbageCollectionNotificationInfo", gcNotifInfoItemNames, gcNotifInfoItemNames, baseGcNotifInfoItemTypes);
            }
            catch (OpenDataException e) {
                throw Util.newException(e);
            }
        }
        return baseGcNotifInfoCompositeType;
    }
}

