/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nio.sctp;

import com.sun.nio.sctp.Association;
import java.net.SocketAddress;
import sun.nio.ch.SctpMessageInfoImpl;

public abstract class MessageInfo {
    protected MessageInfo() {
    }

    public static MessageInfo createOutgoing(SocketAddress address, int streamNumber) {
        if (streamNumber < 0 || streamNumber > 65536) {
            throw new IllegalArgumentException("Invalid stream number");
        }
        return new SctpMessageInfoImpl(null, address, streamNumber);
    }

    public static MessageInfo createOutgoing(Association association, SocketAddress address, int streamNumber) {
        if (association == null) {
            throw new IllegalArgumentException("association cannot be null");
        }
        if (streamNumber < 0 || streamNumber > 65536) {
            throw new IllegalArgumentException("Invalid stream number");
        }
        return new SctpMessageInfoImpl(association, address, streamNumber);
    }

    public abstract SocketAddress address();

    public abstract Association association();

    public abstract int bytes();

    public abstract boolean isComplete();

    public abstract MessageInfo complete(boolean var1);

    public abstract boolean isUnordered();

    public abstract MessageInfo unordered(boolean var1);

    public abstract int payloadProtocolID();

    public abstract MessageInfo payloadProtocolID(int var1);

    public abstract int streamNumber();

    public abstract MessageInfo streamNumber(int var1);

    public abstract long timeToLive();

    public abstract MessageInfo timeToLive(long var1);
}

