/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.Logging;
import java.util.logging.LoggingMXBean;
import java.util.logging.LoggingPermission;
import sun.misc.JavaAWTAccess;
import sun.misc.SharedSecrets;
import sun.util.logging.PlatformLogger;

public class LogManager {
    private static LogManager manager;
    private volatile Properties props = new Properties();
    private PropertyChangeSupport changes = new PropertyChangeSupport(LogManager.class);
    private static final Level defaultLevel;
    private final LoggerContext systemContext = new SystemLoggerContext();
    private final LoggerContext userContext = new LoggerContext();
    private Logger rootLogger;
    private volatile boolean readPrimordialConfiguration;
    private boolean initializedGlobalHandlers = true;
    private boolean deathImminent;
    private static WeakHashMap<Object, LoggerContext> contextsMap;
    private final ReferenceQueue<Logger> loggerRefQueue = new ReferenceQueue();
    private static final int MAX_ITERATIONS = 400;
    private final Permission controlPermission = new LoggingPermission("control", null);
    private static LoggingMXBean loggingMXBean;
    public static final String LOGGING_MXBEAN_NAME = "java.util.logging:type=Logging";

    protected LogManager() {
        this(LogManager.checkSubclassPermissions());
    }

    private LogManager(Void checked) {
        try {
            Runtime.getRuntime().addShutdownHook(new Cleaner());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static Void checkSubclassPermissions() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("shutdownHooks"));
            sm.checkPermission(new RuntimePermission("setContextClassLoader"));
        }
        return null;
    }

    public static LogManager getLogManager() {
        if (manager != null) {
            manager.readPrimordialConfiguration();
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPrimordialConfiguration() {
        if (!this.readPrimordialConfiguration) {
            LogManager logManager = this;
            synchronized (logManager) {
                if (!this.readPrimordialConfiguration) {
                    if (System.out == null) {
                        return;
                    }
                    this.readPrimordialConfiguration = true;
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                            @Override
                            public Void run() throws Exception {
                                LogManager.this.readConfiguration();
                                PlatformLogger.redirectPlatformLoggers();
                                return null;
                            }
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) throws SecurityException {
        if (l == null) {
            throw new NullPointerException();
        }
        this.checkPermission();
        this.changes.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) throws SecurityException {
        this.checkPermission();
        this.changes.removePropertyChangeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoggerContext getUserContext() {
        Object ecx;
        LoggerContext context = null;
        SecurityManager sm = System.getSecurityManager();
        JavaAWTAccess javaAwtAccess = SharedSecrets.getJavaAWTAccess();
        if (sm != null && javaAwtAccess != null && (ecx = javaAwtAccess.getAppletContext()) != null) {
            JavaAWTAccess javaAWTAccess = javaAwtAccess;
            synchronized (javaAWTAccess) {
                if (contextsMap == null) {
                    contextsMap = new WeakHashMap();
                }
                if ((context = contextsMap.get(ecx)) == null) {
                    context = new LoggerContext(true);
                    contextsMap.put(ecx, context);
                }
            }
        }
        return context != null ? context : this.userContext;
    }

    private List<LoggerContext> contexts() {
        ArrayList<LoggerContext> cxs = new ArrayList<LoggerContext>();
        cxs.add(this.systemContext);
        cxs.add(this.getUserContext());
        return cxs;
    }

    Logger demandLogger(String name, String resourceBundleName, Class<?> caller) {
        Logger result = this.getLogger(name);
        if (result == null) {
            Logger newLogger = new Logger(name, resourceBundleName, caller, false);
            do {
                if (!this.addLogger(newLogger)) continue;
                return newLogger;
            } while ((result = this.getLogger(name)) == null);
        }
        return result;
    }

    Logger demandSystemLogger(String name, String resourceBundleName) {
        Logger logger;
        final Logger sysLogger = this.systemContext.demandLogger(name, resourceBundleName);
        while ((logger = this.addLogger(sysLogger) ? sysLogger : this.getLogger(name)) == null) {
        }
        if (logger != sysLogger && sysLogger.accessCheckedHandlers().length == 0) {
            final Logger l = logger;
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    for (Handler hdl : l.accessCheckedHandlers()) {
                        sysLogger.addHandler(hdl);
                    }
                    return null;
                }
            });
        }
        return sysLogger;
    }

    private void loadLoggerHandlers(final Logger logger, String name, final String handlersPropertyName) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                String[] names = LogManager.this.parseClassNames(handlersPropertyName);
                for (int i = 0; i < names.length; ++i) {
                    String word = names[i];
                    try {
                        Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(word);
                        Handler hdl = (Handler)clz.newInstance();
                        String levs = LogManager.this.getProperty(word + ".level");
                        if (levs != null) {
                            Level l = Level.findLevel(levs);
                            if (l != null) {
                                hdl.setLevel(l);
                            } else {
                                System.err.println("Can't set level for " + word);
                            }
                        }
                        logger.addHandler(hdl);
                        continue;
                    }
                    catch (Exception ex) {
                        System.err.println("Can't load log handler \"" + word + "\"");
                        System.err.println("" + ex);
                        ex.printStackTrace();
                    }
                }
                return null;
            }
        });
    }

    final void drainLoggerRefQueueBounded() {
        LoggerWeakRef ref;
        for (int i = 0; i < 400 && this.loggerRefQueue != null && (ref = (LoggerWeakRef)this.loggerRefQueue.poll()) != null; ++i) {
            ref.dispose();
        }
    }

    public boolean addLogger(Logger logger) {
        String name = logger.getName();
        if (name == null) {
            throw new NullPointerException();
        }
        this.drainLoggerRefQueueBounded();
        LoggerContext cx = this.getUserContext();
        if (cx.addLocalLogger(logger)) {
            this.loadLoggerHandlers(logger, name, name + ".handlers");
            return true;
        }
        return false;
    }

    private static void doSetLevel(final Logger logger, final Level level) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            logger.setLevel(level);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                logger.setLevel(level);
                return null;
            }
        });
    }

    private static void doSetParent(final Logger logger, final Logger parent) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            logger.setParent(parent);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                logger.setParent(parent);
                return null;
            }
        });
    }

    public Logger getLogger(String name) {
        return this.getUserContext().findLogger(name);
    }

    public Enumeration<String> getLoggerNames() {
        return this.getUserContext().getLoggerNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfiguration() throws IOException, SecurityException {
        String fname;
        this.checkPermission();
        String cname = System.getProperty("java.util.logging.config.class");
        if (cname != null) {
            try {
                try {
                    Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(cname);
                    clz.newInstance();
                    return;
                }
                catch (ClassNotFoundException ex) {
                    Class<?> clz = Thread.currentThread().getContextClassLoader().loadClass(cname);
                    clz.newInstance();
                    return;
                }
            }
            catch (Exception ex) {
                System.err.println("Logging configuration class \"" + cname + "\" failed");
                System.err.println("" + ex);
            }
        }
        if ((fname = System.getProperty("java.util.logging.config.file")) == null) {
            fname = System.getProperty("java.home");
            if (fname == null) {
                throw new Error("Can't find java.home ??");
            }
            File f = new File(fname, "lib");
            f = new File(f, "logging.properties");
            fname = f.getCanonicalPath();
        }
        FileInputStream in = new FileInputStream(fname);
        BufferedInputStream bin = new BufferedInputStream(in);
        try {
            this.readConfiguration(bin);
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws SecurityException {
        this.checkPermission();
        LogManager logManager = this;
        synchronized (logManager) {
            this.props = new Properties();
            this.initializedGlobalHandlers = true;
        }
        for (LoggerContext cx : this.contexts()) {
            Enumeration<String> enum_ = cx.getLoggerNames();
            while (enum_.hasMoreElements()) {
                String name = enum_.nextElement();
                Logger logger = cx.findLogger(name);
                if (logger == null) continue;
                this.resetLogger(logger);
            }
        }
    }

    private void resetLogger(Logger logger) {
        Handler[] targets = logger.getHandlers();
        for (int i = 0; i < targets.length; ++i) {
            Handler h = targets[i];
            logger.removeHandler(h);
            try {
                h.close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String name = logger.getName();
        if (name != null && name.equals("")) {
            logger.setLevel(defaultLevel);
        } else {
            logger.setLevel(null);
        }
    }

    private String[] parseClassNames(String propertyName) {
        String hands = this.getProperty(propertyName);
        if (hands == null) {
            return new String[0];
        }
        hands = hands.trim();
        int ix = 0;
        Vector<String> result = new Vector<String>();
        while (ix < hands.length()) {
            int end;
            for (end = ix; end < hands.length() && !Character.isWhitespace(hands.charAt(end)) && hands.charAt(end) != ','; ++end) {
            }
            String word = hands.substring(ix, end);
            ix = end + 1;
            if ((word = word.trim()).length() == 0) continue;
            result.add(word);
        }
        return result.toArray(new String[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfiguration(InputStream ins) throws IOException, SecurityException {
        this.checkPermission();
        this.reset();
        this.props.load(ins);
        String[] names = this.parseClassNames("config");
        for (int i = 0; i < names.length; ++i) {
            String word = names[i];
            try {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(word);
                clz.newInstance();
                continue;
            }
            catch (Exception ex) {
                System.err.println("Can't load config class \"" + word + "\"");
                System.err.println("" + ex);
            }
        }
        this.setLevelsOnExistingLoggers();
        this.changes.firePropertyChange(null, null, null);
        LogManager logManager = this;
        synchronized (logManager) {
            this.initializedGlobalHandlers = false;
        }
    }

    public String getProperty(String name) {
        return this.props.getProperty(name);
    }

    String getStringProperty(String name, String defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        return val.trim();
    }

    int getIntProperty(String name, int defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val.trim());
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    boolean getBooleanProperty(String name, boolean defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        if ((val = val.toLowerCase()).equals("true") || val.equals("1")) {
            return true;
        }
        if (val.equals("false") || val.equals("0")) {
            return false;
        }
        return defaultValue;
    }

    Level getLevelProperty(String name, Level defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        Level l = Level.findLevel(val.trim());
        return l != null ? l : defaultValue;
    }

    Filter getFilterProperty(String name, Filter defaultValue) {
        String val = this.getProperty(name);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Filter)clz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    Formatter getFormatterProperty(String name, Formatter defaultValue) {
        String val = this.getProperty(name);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Formatter)clz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    private synchronized void initializeGlobalHandlers() {
        if (this.initializedGlobalHandlers) {
            return;
        }
        this.initializedGlobalHandlers = true;
        if (this.deathImminent) {
            return;
        }
        this.loadLoggerHandlers(this.rootLogger, null, "handlers");
    }

    void checkPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(this.controlPermission);
        }
    }

    public void checkAccess() throws SecurityException {
        this.checkPermission();
    }

    private synchronized void setLevelsOnExistingLoggers() {
        Enumeration<?> enum_ = this.props.propertyNames();
        while (enum_.hasMoreElements()) {
            String key = (String)enum_.nextElement();
            if (!key.endsWith(".level")) continue;
            int ix = key.length() - 6;
            String name = key.substring(0, ix);
            Level level = this.getLevelProperty(key, null);
            if (level == null) {
                System.err.println("Bad level value for property: " + key);
                continue;
            }
            for (LoggerContext cx : this.contexts()) {
                Logger l = cx.findLogger(name);
                if (l == null) continue;
                l.setLevel(level);
            }
        }
    }

    public static synchronized LoggingMXBean getLoggingMXBean() {
        if (loggingMXBean == null) {
            loggingMXBean = new Logging();
        }
        return loggingMXBean;
    }

    static {
        defaultLevel = Level.INFO;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                String cname = null;
                try {
                    cname = System.getProperty("java.util.logging.manager");
                    if (cname != null) {
                        try {
                            Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(cname);
                            manager = (LogManager)clz.newInstance();
                        }
                        catch (ClassNotFoundException ex) {
                            Class<?> clz = Thread.currentThread().getContextClassLoader().loadClass(cname);
                            manager = (LogManager)clz.newInstance();
                        }
                    }
                }
                catch (Exception ex) {
                    System.err.println("Could not load Logmanager \"" + cname + "\"");
                    ex.printStackTrace();
                }
                if (manager == null) {
                    manager = new LogManager();
                }
                LogManager logManager = manager;
                LogManager logManager2 = manager;
                logManager2.getClass();
                logManager.rootLogger = logManager2.new RootLogger();
                manager.addLogger(manager.rootLogger);
                manager.systemContext.addLocalLogger(manager.rootLogger, false);
                manager.userContext.addLocalLogger(manager.rootLogger, false);
                Logger.global.setLogManager(manager);
                manager.addLogger(Logger.global);
                manager.systemContext.addLocalLogger(Logger.global, false);
                manager.userContext.addLocalLogger(Logger.global, false);
                return null;
            }
        });
        contextsMap = null;
        loggingMXBean = null;
    }

    private final class RootLogger
    extends Logger {
        private RootLogger() {
            super("", null, null, true);
            this.setLevel(defaultLevel);
        }

        @Override
        public void log(LogRecord record) {
            LogManager.this.initializeGlobalHandlers();
            super.log(record);
        }

        @Override
        public void addHandler(Handler h) {
            LogManager.this.initializeGlobalHandlers();
            super.addHandler(h);
        }

        @Override
        public void removeHandler(Handler h) {
            LogManager.this.initializeGlobalHandlers();
            super.removeHandler(h);
        }

        @Override
        Handler[] accessCheckedHandlers() {
            LogManager.this.initializeGlobalHandlers();
            return super.accessCheckedHandlers();
        }
    }

    private static class LogNode {
        HashMap<String, LogNode> children;
        LoggerWeakRef loggerRef;
        LogNode parent;
        final LoggerContext context;

        LogNode(LogNode parent, LoggerContext context) {
            this.parent = parent;
            this.context = context;
        }

        void walkAndSetParent(Logger parent) {
            if (this.children == null) {
                return;
            }
            for (LogNode node : this.children.values()) {
                Logger logger;
                LoggerWeakRef ref = node.loggerRef;
                Logger logger2 = logger = ref == null ? null : (Logger)ref.get();
                if (logger == null) {
                    node.walkAndSetParent(parent);
                    continue;
                }
                LogManager.doSetParent(logger, parent);
            }
        }
    }

    final class LoggerWeakRef
    extends WeakReference<Logger> {
        private String name;
        private LogNode node;
        private WeakReference<Logger> parentRef;
        private boolean disposed;

        LoggerWeakRef(Logger logger) {
            super(logger, LogManager.this.loggerRefQueue);
            this.disposed = false;
            this.name = logger.getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispose() {
            LoggerWeakRef loggerWeakRef = this;
            synchronized (loggerWeakRef) {
                if (this.disposed) {
                    return;
                }
                this.disposed = true;
            }
            LogNode n = this.node;
            if (n != null) {
                LoggerContext loggerContext = n.context;
                synchronized (loggerContext) {
                    n.context.removeLoggerRef(this.name, this);
                    this.name = null;
                    if (n.loggerRef == this) {
                        n.loggerRef = null;
                    }
                    this.node = null;
                }
            }
            if (this.parentRef != null) {
                Logger parent = (Logger)this.parentRef.get();
                if (parent != null) {
                    parent.removeChildLogger(this);
                }
                this.parentRef = null;
            }
        }

        void setNode(LogNode node) {
            this.node = node;
        }

        void setParentRef(WeakReference<Logger> parentRef) {
            this.parentRef = parentRef;
        }
    }

    static class SystemLoggerContext
    extends LoggerContext {
        SystemLoggerContext() {
        }

        @Override
        Logger demandLogger(String name, String resourceBundleName) {
            Logger result = this.findLogger(name);
            if (result == null) {
                Logger newLogger = new Logger(name, resourceBundleName, null, true);
                while ((result = this.addLocalLogger(newLogger) ? newLogger : this.findLogger(name)) == null) {
                }
            }
            return result;
        }
    }

    static class LoggerContext {
        private final Hashtable<String, LoggerWeakRef> namedLoggers = new Hashtable();
        private final LogNode root = new LogNode(null, this);
        private final boolean requiresDefaultLoggers;

        private LoggerContext() {
            this(false);
        }

        private LoggerContext(boolean requiresDefaultLoggers) {
            this.requiresDefaultLoggers = requiresDefaultLoggers;
        }

        Logger demandLogger(String name, String resourceBundleName) {
            return manager.demandLogger(name, resourceBundleName, null);
        }

        private void ensureInitialized() {
            if (this.requiresDefaultLoggers) {
                this.ensureDefaultLogger(manager.rootLogger);
                this.ensureDefaultLogger(Logger.global);
            }
        }

        synchronized Logger findLogger(String name) {
            this.ensureInitialized();
            LoggerWeakRef ref = this.namedLoggers.get(name);
            if (ref == null) {
                return null;
            }
            Logger logger = (Logger)ref.get();
            if (logger == null) {
                ref.dispose();
            }
            return logger;
        }

        private void ensureAllDefaultLoggers(Logger logger) {
            if (this.requiresDefaultLoggers) {
                String name = logger.getName();
                if (!name.isEmpty()) {
                    this.ensureDefaultLogger(manager.rootLogger);
                }
                if (!"global".equals(name)) {
                    this.ensureDefaultLogger(Logger.global);
                }
            }
        }

        private void ensureDefaultLogger(Logger logger) {
            if (!this.requiresDefaultLoggers || logger == null || logger != Logger.global && logger != manager.rootLogger) {
                assert (logger == null);
                return;
            }
            if (!this.namedLoggers.containsKey(logger.getName())) {
                this.addLocalLogger(logger, false);
            }
        }

        boolean addLocalLogger(Logger logger) {
            return this.addLocalLogger(logger, this.requiresDefaultLoggers);
        }

        synchronized boolean addLocalLogger(Logger logger, boolean addDefaultLoggersIfNeeded) {
            LoggerWeakRef nodeRef;
            String name;
            if (addDefaultLoggersIfNeeded) {
                this.ensureAllDefaultLoggers(logger);
            }
            if ((name = logger.getName()) == null) {
                throw new NullPointerException();
            }
            LoggerWeakRef ref = this.namedLoggers.get(name);
            if (ref != null) {
                if (ref.get() == null) {
                    ref.dispose();
                } else {
                    return false;
                }
            }
            LogManager logManager = manager;
            logManager.getClass();
            ref = logManager.new LoggerWeakRef(logger);
            this.namedLoggers.put(name, ref);
            Level level = manager.getLevelProperty(name + ".level", null);
            if (level != null) {
                LogManager.doSetLevel(logger, level);
            }
            this.processParentHandlers(logger, name);
            LogNode node = this.getNode(name);
            node.loggerRef = ref;
            Logger parent = null;
            LogNode nodep = node.parent;
            while (nodep != null && ((nodeRef = nodep.loggerRef) == null || (parent = (Logger)nodeRef.get()) == null)) {
                nodep = nodep.parent;
            }
            if (parent != null) {
                LogManager.doSetParent(logger, parent);
            }
            node.walkAndSetParent(logger);
            ref.setNode(node);
            return true;
        }

        synchronized void removeLoggerRef(String name, LoggerWeakRef ref) {
            if (this.namedLoggers.get(name) == ref) {
                this.namedLoggers.remove(name);
            }
        }

        synchronized Enumeration<String> getLoggerNames() {
            this.ensureInitialized();
            return this.namedLoggers.keys();
        }

        private void processParentHandlers(final Logger logger, final String name) {
            int ix2;
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    boolean useParent;
                    if (logger != manager.rootLogger && !(useParent = manager.getBooleanProperty(name + ".useParentHandlers", true))) {
                        logger.setUseParentHandlers(false);
                    }
                    return null;
                }
            });
            int ix = 1;
            while ((ix2 = name.indexOf(".", ix)) >= 0) {
                String pname = name.substring(0, ix2);
                if (manager.getProperty(pname + ".level") != null || manager.getProperty(pname + ".handlers") != null) {
                    this.demandLogger(pname, null);
                }
                ix = ix2 + 1;
            }
        }

        LogNode getNode(String name) {
            if (name == null || name.equals("")) {
                return this.root;
            }
            LogNode node = this.root;
            while (name.length() > 0) {
                LogNode child;
                String head;
                int ix = name.indexOf(".");
                if (ix > 0) {
                    head = name.substring(0, ix);
                    name = name.substring(ix + 1);
                } else {
                    head = name;
                    name = "";
                }
                if (node.children == null) {
                    node.children = new HashMap();
                }
                if ((child = node.children.get(head)) == null) {
                    child = new LogNode(node, this);
                    node.children.put(head, child);
                }
                node = child;
            }
            return node;
        }
    }

    private class Cleaner
    extends Thread {
        private Cleaner() {
            this.setContextClassLoader(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LogManager mgr = manager;
            LogManager logManager = LogManager.this;
            synchronized (logManager) {
                LogManager.this.deathImminent = true;
                LogManager.this.initializedGlobalHandlers = true;
            }
            LogManager.this.reset();
        }
    }
}

