/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.Platform;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.spi.MidiDeviceProvider;

public abstract class AbstractMidiDeviceProvider
extends MidiDeviceProvider {
    private static final boolean enabled;

    final synchronized void readDeviceInfos() {
        int newNumDevices;
        Info[] infos = this.getInfoCache();
        MidiDevice[] devices = this.getDeviceCache();
        if (!enabled) {
            if (infos == null || infos.length != 0) {
                this.setInfoCache(new Info[0]);
            }
            if (devices == null || devices.length != 0) {
                this.setDeviceCache(new MidiDevice[0]);
            }
            return;
        }
        int oldNumDevices = infos == null ? -1 : infos.length;
        if (oldNumDevices != (newNumDevices = this.getNumDevices())) {
            int i;
            Info[] newInfos = new Info[newNumDevices];
            MidiDevice[] newDevices = new MidiDevice[newNumDevices];
            for (i = 0; i < newNumDevices; ++i) {
                Info newInfo = this.createInfo(i);
                if (infos != null) {
                    for (int ii = 0; ii < infos.length; ++ii) {
                        Info info = infos[ii];
                        if (info == null || !info.equalStrings(newInfo)) continue;
                        newInfos[i] = info;
                        info.setIndex(i);
                        infos[ii] = null;
                        newDevices[i] = devices[ii];
                        devices[ii] = null;
                        break;
                    }
                }
                if (newInfos[i] != null) continue;
                newInfos[i] = newInfo;
            }
            if (infos != null) {
                for (i = 0; i < infos.length; ++i) {
                    if (infos[i] == null) continue;
                    infos[i].setIndex(-1);
                }
            }
            this.setInfoCache(newInfos);
            this.setDeviceCache(newDevices);
        }
    }

    @Override
    public final MidiDevice.Info[] getDeviceInfo() {
        this.readDeviceInfos();
        Info[] infos = this.getInfoCache();
        MidiDevice.Info[] localArray = new MidiDevice.Info[infos.length];
        System.arraycopy(infos, 0, localArray, 0, infos.length);
        return localArray;
    }

    @Override
    public final MidiDevice getDevice(MidiDevice.Info info) {
        if (info instanceof Info) {
            this.readDeviceInfos();
            MidiDevice[] devices = this.getDeviceCache();
            Info[] infos = this.getInfoCache();
            Info thisInfo = (Info)info;
            int index = thisInfo.getIndex();
            if (index >= 0 && index < devices.length && infos[index] == info) {
                if (devices[index] == null) {
                    devices[index] = this.createDevice(thisInfo);
                }
                if (devices[index] != null) {
                    return devices[index];
                }
            }
        }
        throw new IllegalArgumentException("MidiDevice " + info.toString() + " not supported by this provider.");
    }

    abstract int getNumDevices();

    abstract MidiDevice[] getDeviceCache();

    abstract void setDeviceCache(MidiDevice[] var1);

    abstract Info[] getInfoCache();

    abstract void setInfoCache(Info[] var1);

    abstract Info createInfo(int var1);

    abstract MidiDevice createDevice(Info var1);

    static {
        Platform.initialize();
        enabled = Platform.isMidiIOEnabled();
    }

    static class Info
    extends MidiDevice.Info {
        private int index;

        Info(String name, String vendor, String description, String version, int index) {
            super(name, vendor, description, version);
            this.index = index;
        }

        final boolean equalStrings(Info info) {
            return info != null && this.getName().equals(info.getName()) && this.getVendor().equals(info.getVendor()) && this.getDescription().equals(info.getDescription()) && this.getVersion().equals(info.getVersion());
        }

        final int getIndex() {
            return this.index;
        }

        final void setIndex(int index) {
            this.index = index;
        }
    }
}

