/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import javax.swing.SpringLayout;

public abstract class Spring {
    public static final int UNSET = Integer.MIN_VALUE;

    protected Spring() {
    }

    public abstract int getMinimumValue();

    public abstract int getPreferredValue();

    public abstract int getMaximumValue();

    public abstract int getValue();

    public abstract void setValue(int var1);

    private double range(boolean contract) {
        return contract ? (double)(this.getPreferredValue() - this.getMinimumValue()) : (double)(this.getMaximumValue() - this.getPreferredValue());
    }

    double getStrain() {
        double delta = this.getValue() - this.getPreferredValue();
        return delta / this.range(this.getValue() < this.getPreferredValue());
    }

    void setStrain(double strain) {
        this.setValue(this.getPreferredValue() + (int)(strain * this.range(strain < 0.0)));
    }

    boolean isCyclic(SpringLayout l) {
        return false;
    }

    public static Spring constant(int pref) {
        return Spring.constant(pref, pref, pref);
    }

    public static Spring constant(int min, int pref, int max) {
        return new StaticSpring(min, pref, max);
    }

    public static Spring minus(Spring s) {
        return new NegativeSpring(s);
    }

    public static Spring sum(Spring s1, Spring s2) {
        return new SumSpring(s1, s2);
    }

    public static Spring max(Spring s1, Spring s2) {
        return new MaxSpring(s1, s2);
    }

    static Spring difference(Spring s1, Spring s2) {
        return Spring.sum(s1, Spring.minus(s2));
    }

    public static Spring scale(Spring s, float factor) {
        Spring.checkArg(s);
        return new ScaleSpring(s, factor);
    }

    public static Spring width(Component c) {
        Spring.checkArg(c);
        return new WidthSpring(c);
    }

    public static Spring height(Component c) {
        Spring.checkArg(c);
        return new HeightSpring(c);
    }

    private static void checkArg(Object s) {
        if (s == null) {
            throw new NullPointerException("Argument must not be null");
        }
    }

    private static class MaxSpring
    extends CompoundSpring {
        public MaxSpring(Spring s1, Spring s2) {
            super(s1, s2);
        }

        @Override
        protected int op(int x, int y) {
            return Math.max(x, y);
        }

        @Override
        protected void setNonClearValue(int size) {
            super.setNonClearValue(size);
            this.s1.setValue(size);
            this.s2.setValue(size);
        }
    }

    private static class SumSpring
    extends CompoundSpring {
        public SumSpring(Spring s1, Spring s2) {
            super(s1, s2);
        }

        @Override
        protected int op(int x, int y) {
            return x + y;
        }

        @Override
        protected void setNonClearValue(int size) {
            super.setNonClearValue(size);
            this.s1.setStrain(this.getStrain());
            this.s2.setValue(size - this.s1.getValue());
        }
    }

    static abstract class CompoundSpring
    extends StaticSpring {
        protected Spring s1;
        protected Spring s2;

        public CompoundSpring(Spring s1, Spring s2) {
            super(Integer.MIN_VALUE);
            this.s1 = s1;
            this.s2 = s2;
        }

        @Override
        public String toString() {
            return "CompoundSpring of " + this.s1 + " and " + this.s2;
        }

        @Override
        protected void clear() {
            super.clear();
            this.max = Integer.MIN_VALUE;
            this.pref = Integer.MIN_VALUE;
            this.min = Integer.MIN_VALUE;
            this.s1.setValue(Integer.MIN_VALUE);
            this.s2.setValue(Integer.MIN_VALUE);
        }

        protected abstract int op(int var1, int var2);

        @Override
        public int getMinimumValue() {
            if (this.min == Integer.MIN_VALUE) {
                this.min = this.op(this.s1.getMinimumValue(), this.s2.getMinimumValue());
            }
            return this.min;
        }

        @Override
        public int getPreferredValue() {
            if (this.pref == Integer.MIN_VALUE) {
                this.pref = this.op(this.s1.getPreferredValue(), this.s2.getPreferredValue());
            }
            return this.pref;
        }

        @Override
        public int getMaximumValue() {
            if (this.max == Integer.MIN_VALUE) {
                this.max = this.op(this.s1.getMaximumValue(), this.s2.getMaximumValue());
            }
            return this.max;
        }

        @Override
        public int getValue() {
            if (this.size == Integer.MIN_VALUE) {
                this.size = this.op(this.s1.getValue(), this.s2.getValue());
            }
            return this.size;
        }

        @Override
        boolean isCyclic(SpringLayout l) {
            return l.isCyclic(this.s1) || l.isCyclic(this.s2);
        }
    }

    static abstract class SpringMap
    extends Spring {
        private Spring s;

        public SpringMap(Spring s) {
            this.s = s;
        }

        protected abstract int map(int var1);

        protected abstract int inv(int var1);

        @Override
        public int getMinimumValue() {
            return this.map(this.s.getMinimumValue());
        }

        @Override
        public int getPreferredValue() {
            return this.map(this.s.getPreferredValue());
        }

        @Override
        public int getMaximumValue() {
            return Math.min(Short.MAX_VALUE, this.map(this.s.getMaximumValue()));
        }

        @Override
        public int getValue() {
            return this.map(this.s.getValue());
        }

        @Override
        public void setValue(int value) {
            if (value == Integer.MIN_VALUE) {
                this.s.setValue(Integer.MIN_VALUE);
            } else {
                this.s.setValue(this.inv(value));
            }
        }

        @Override
        boolean isCyclic(SpringLayout l) {
            return this.s.isCyclic(l);
        }
    }

    static class HeightSpring
    extends AbstractSpring {
        Component c;

        public HeightSpring(Component c) {
            this.c = c;
        }

        @Override
        public int getMinimumValue() {
            return this.c.getMinimumSize().height;
        }

        @Override
        public int getPreferredValue() {
            return this.c.getPreferredSize().height;
        }

        @Override
        public int getMaximumValue() {
            return Math.min(Short.MAX_VALUE, this.c.getMaximumSize().height);
        }
    }

    static class WidthSpring
    extends AbstractSpring {
        Component c;

        public WidthSpring(Component c) {
            this.c = c;
        }

        @Override
        public int getMinimumValue() {
            return this.c.getMinimumSize().width;
        }

        @Override
        public int getPreferredValue() {
            return this.c.getPreferredSize().width;
        }

        @Override
        public int getMaximumValue() {
            return Math.min(Short.MAX_VALUE, this.c.getMaximumSize().width);
        }
    }

    private static class ScaleSpring
    extends Spring {
        private Spring s;
        private float factor;

        private ScaleSpring(Spring s, float factor) {
            this.s = s;
            this.factor = factor;
        }

        @Override
        public int getMinimumValue() {
            return Math.round((float)(this.factor < 0.0f ? this.s.getMaximumValue() : this.s.getMinimumValue()) * this.factor);
        }

        @Override
        public int getPreferredValue() {
            return Math.round((float)this.s.getPreferredValue() * this.factor);
        }

        @Override
        public int getMaximumValue() {
            return Math.round((float)(this.factor < 0.0f ? this.s.getMinimumValue() : this.s.getMaximumValue()) * this.factor);
        }

        @Override
        public int getValue() {
            return Math.round((float)this.s.getValue() * this.factor);
        }

        @Override
        public void setValue(int value) {
            if (value == Integer.MIN_VALUE) {
                this.s.setValue(Integer.MIN_VALUE);
            } else {
                this.s.setValue(Math.round((float)value / this.factor));
            }
        }

        @Override
        boolean isCyclic(SpringLayout l) {
            return this.s.isCyclic(l);
        }
    }

    private static class NegativeSpring
    extends Spring {
        private Spring s;

        public NegativeSpring(Spring s) {
            this.s = s;
        }

        @Override
        public int getMinimumValue() {
            return -this.s.getMaximumValue();
        }

        @Override
        public int getPreferredValue() {
            return -this.s.getPreferredValue();
        }

        @Override
        public int getMaximumValue() {
            return -this.s.getMinimumValue();
        }

        @Override
        public int getValue() {
            return -this.s.getValue();
        }

        @Override
        public void setValue(int size) {
            this.s.setValue(-size);
        }

        @Override
        boolean isCyclic(SpringLayout l) {
            return this.s.isCyclic(l);
        }
    }

    private static class StaticSpring
    extends AbstractSpring {
        protected int min;
        protected int pref;
        protected int max;

        public StaticSpring(int pref) {
            this(pref, pref, pref);
        }

        public StaticSpring(int min, int pref, int max) {
            this.min = min;
            this.pref = pref;
            this.max = max;
        }

        public String toString() {
            return "StaticSpring [" + this.min + ", " + this.pref + ", " + this.max + "]";
        }

        @Override
        public int getMinimumValue() {
            return this.min;
        }

        @Override
        public int getPreferredValue() {
            return this.pref;
        }

        @Override
        public int getMaximumValue() {
            return this.max;
        }
    }

    static abstract class AbstractSpring
    extends Spring {
        protected int size = Integer.MIN_VALUE;

        AbstractSpring() {
        }

        @Override
        public int getValue() {
            return this.size != Integer.MIN_VALUE ? this.size : this.getPreferredValue();
        }

        @Override
        public final void setValue(int size) {
            if (this.size == size) {
                return;
            }
            if (size == Integer.MIN_VALUE) {
                this.clear();
            } else {
                this.setNonClearValue(size);
            }
        }

        protected void clear() {
            this.size = Integer.MIN_VALUE;
        }

        protected void setNonClearValue(int size) {
            this.size = size;
        }
    }
}

