/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.WindowsButtonUI;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import sun.swing.SwingUtilities2;

public class WindowsGraphicsUtils {
    public static void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text, int textShiftOffset) {
        XPStyle xp;
        FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)b, g);
        int mnemIndex = b.getDisplayedMnemonicIndex();
        if (WindowsLookAndFeel.isMnemonicHidden()) {
            mnemIndex = -1;
        }
        if ((xp = XPStyle.getXP()) != null && !(b instanceof JMenuItem)) {
            WindowsGraphicsUtils.paintXPText(b, g, textRect.x + textShiftOffset, textRect.y + fm.getAscent() + textShiftOffset, text, mnemIndex);
        } else {
            WindowsGraphicsUtils.paintClassicText(b, g, textRect.x + textShiftOffset, textRect.y + fm.getAscent() + textShiftOffset, text, mnemIndex);
        }
    }

    static void paintClassicText(AbstractButton b, Graphics g, int x, int y, String text, int mnemIndex) {
        ButtonModel model = b.getModel();
        Color color = b.getForeground();
        if (model.isEnabled()) {
            if (!(b instanceof JMenuItem && model.isArmed() || b instanceof JMenu && (model.isSelected() || model.isRollover()))) {
                g.setColor(b.getForeground());
            }
            SwingUtilities2.drawStringUnderlineCharAt(b, g, text, mnemIndex, x, y);
        } else {
            color = UIManager.getColor("Button.shadow");
            Color shadow = UIManager.getColor("Button.disabledShadow");
            if (model.isArmed()) {
                color = UIManager.getColor("Button.disabledForeground");
            } else {
                if (shadow == null) {
                    shadow = b.getBackground().darker();
                }
                g.setColor(shadow);
                SwingUtilities2.drawStringUnderlineCharAt(b, g, text, mnemIndex, x + 1, y + 1);
            }
            if (color == null) {
                color = b.getBackground().brighter();
            }
            g.setColor(color);
            SwingUtilities2.drawStringUnderlineCharAt(b, g, text, mnemIndex, x, y);
        }
    }

    static void paintXPText(AbstractButton b, Graphics g, int x, int y, String text, int mnemIndex) {
        TMSchema.Part part = WindowsButtonUI.getXPButtonType(b);
        TMSchema.State state = WindowsButtonUI.getXPButtonState(b);
        WindowsGraphicsUtils.paintXPText(b, part, state, g, x, y, text, mnemIndex);
    }

    static void paintXPText(AbstractButton b, TMSchema.Part part, TMSchema.State state, Graphics g, int x, int y, String text, int mnemIndex) {
        XPStyle xp = XPStyle.getXP();
        if (xp == null) {
            return;
        }
        Color textColor = b.getForeground();
        if (textColor instanceof UIResource) {
            TMSchema.TypeEnum shadowType;
            Color enabledColor;
            textColor = xp.getColor(b, part, state, TMSchema.Prop.TEXTCOLOR, b.getForeground());
            if (part == TMSchema.Part.TP_BUTTON && state == TMSchema.State.DISABLED && textColor.equals(enabledColor = xp.getColor(b, part, TMSchema.State.NORMAL, TMSchema.Prop.TEXTCOLOR, b.getForeground()))) {
                textColor = xp.getColor(b, TMSchema.Part.BP_PUSHBUTTON, state, TMSchema.Prop.TEXTCOLOR, textColor);
            }
            if ((shadowType = xp.getTypeEnum(b, part, state, TMSchema.Prop.TEXTSHADOWTYPE)) == TMSchema.TypeEnum.TST_SINGLE || shadowType == TMSchema.TypeEnum.TST_CONTINUOUS) {
                Color shadowColor = xp.getColor(b, part, state, TMSchema.Prop.TEXTSHADOWCOLOR, Color.black);
                Point offset = xp.getPoint(b, part, state, TMSchema.Prop.TEXTSHADOWOFFSET);
                if (offset != null) {
                    g.setColor(shadowColor);
                    SwingUtilities2.drawStringUnderlineCharAt(b, g, text, mnemIndex, x + offset.x, y + offset.y);
                }
            }
        }
        g.setColor(textColor);
        SwingUtilities2.drawStringUnderlineCharAt(b, g, text, mnemIndex, x, y);
    }

    static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    static void repaintMnemonicsInWindow(Window w) {
        if (w == null || !w.isShowing()) {
            return;
        }
        Window[] ownedWindows = w.getOwnedWindows();
        for (int i = 0; i < ownedWindows.length; ++i) {
            WindowsGraphicsUtils.repaintMnemonicsInWindow(ownedWindows[i]);
        }
        WindowsGraphicsUtils.repaintMnemonicsInContainer(w);
    }

    static void repaintMnemonicsInContainer(Container cont) {
        for (int i = 0; i < cont.getComponentCount(); ++i) {
            Component c = cont.getComponent(i);
            if (c == null || !c.isVisible()) continue;
            if (c instanceof AbstractButton && ((AbstractButton)c).getMnemonic() != 0) {
                c.repaint();
                continue;
            }
            if (c instanceof JLabel && ((JLabel)c).getDisplayedMnemonic() != 0) {
                c.repaint();
                continue;
            }
            if (!(c instanceof Container)) continue;
            WindowsGraphicsUtils.repaintMnemonicsInContainer((Container)c);
        }
    }
}

