/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.nimbus;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;

class ImageScalingHelper {
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    static final int PAINT_TOP_LEFT = 1;
    static final int PAINT_TOP = 2;
    static final int PAINT_TOP_RIGHT = 4;
    static final int PAINT_LEFT = 8;
    static final int PAINT_CENTER = 16;
    static final int PAINT_RIGHT = 32;
    static final int PAINT_BOTTOM_RIGHT = 64;
    static final int PAINT_BOTTOM = 128;
    static final int PAINT_BOTTOM_LEFT = 256;
    static final int PAINT_ALL = 512;

    ImageScalingHelper() {
    }

    public static void paint(Graphics g, int x, int y, int w, int h, Image image, Insets sInsets, Insets dInsets, PaintType paintType, int mask) {
        if (image == null || image.getWidth(null) <= 0 || image.getHeight(null) <= 0) {
            return;
        }
        if (sInsets == null) {
            sInsets = EMPTY_INSETS;
        }
        if (dInsets == null) {
            dInsets = EMPTY_INSETS;
        }
        int iw = image.getWidth(null);
        int ih = image.getHeight(null);
        if (paintType == PaintType.CENTER) {
            g.drawImage(image, x + (w - iw) / 2, y + (h - ih) / 2, null);
        } else if (paintType == PaintType.TILE) {
            int lastIY = 0;
            int maxY = y + h;
            for (int yCounter = y; yCounter < maxY; yCounter += ih - lastIY) {
                int lastIX = 0;
                int maxX = x + w;
                for (int xCounter = x; xCounter < maxX; xCounter += iw - lastIX) {
                    int dx2 = Math.min(maxX, xCounter + iw - lastIX);
                    int dy2 = Math.min(maxY, yCounter + ih - lastIY);
                    g.drawImage(image, xCounter, yCounter, dx2, dy2, lastIX, lastIY, lastIX + dx2 - xCounter, lastIY + dy2 - yCounter, null);
                    lastIX = 0;
                }
                lastIY = 0;
            }
        } else {
            boolean stretch;
            int st = sInsets.top;
            int sl = sInsets.left;
            int sb = sInsets.bottom;
            int sr = sInsets.right;
            int dt = dInsets.top;
            int dl = dInsets.left;
            int db = dInsets.bottom;
            int dr = dInsets.right;
            if (st + sb > ih) {
                sb = st = Math.max(0, ih / 2);
                dt = st;
                db = st;
            }
            if (sl + sr > iw) {
                sl = sr = Math.max(0, iw / 2);
                dr = sr;
                dl = sr;
            }
            if (dt + db > h) {
                dt = db = Math.max(0, h / 2 - 1);
            }
            if (dl + dr > w) {
                dl = dr = Math.max(0, w / 2 - 1);
            }
            boolean bl = stretch = paintType == PaintType.PAINT9_STRETCH;
            if ((mask & 0x200) != 0) {
                mask = 0x1FF & ~mask;
            }
            if ((mask & 8) != 0) {
                ImageScalingHelper.drawChunk(image, g, stretch, x, y + dt, x + dl, y + h - db, 0, st, sl, ih - sb, false);
            }
            if ((mask & 1) != 0) {
                ImageScalingHelper.drawImage(image, g, x, y, x + dl, y + dt, 0, 0, sl, st);
            }
            if ((mask & 2) != 0) {
                ImageScalingHelper.drawChunk(image, g, stretch, x + dl, y, x + w - dr, y + dt, sl, 0, iw - sr, st, true);
            }
            if ((mask & 4) != 0) {
                ImageScalingHelper.drawImage(image, g, x + w - dr, y, x + w, y + dt, iw - sr, 0, iw, st);
            }
            if ((mask & 0x20) != 0) {
                ImageScalingHelper.drawChunk(image, g, stretch, x + w - dr, y + dt, x + w, y + h - db, iw - sr, st, iw, ih - sb, false);
            }
            if ((mask & 0x40) != 0) {
                ImageScalingHelper.drawImage(image, g, x + w - dr, y + h - db, x + w, y + h, iw - sr, ih - sb, iw, ih);
            }
            if ((mask & 0x80) != 0) {
                ImageScalingHelper.drawChunk(image, g, stretch, x + dl, y + h - db, x + w - dr, y + h, sl, ih - sb, iw - sr, ih, true);
            }
            if ((mask & 0x100) != 0) {
                ImageScalingHelper.drawImage(image, g, x, y + h - db, x + dl, y + h, 0, ih - sb, sl, ih);
            }
            if ((mask & 0x10) != 0) {
                ImageScalingHelper.drawImage(image, g, x + dl, y + dt, x + w - dr, y + h - db, sl, st, iw - sr, ih - sb);
            }
        }
    }

    private static void drawChunk(Image image, Graphics g, boolean stretch, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, boolean xDirection) {
        if (dx2 - dx1 <= 0 || dy2 - dy1 <= 0 || sx2 - sx1 <= 0 || sy2 - sy1 <= 0) {
            return;
        }
        if (stretch) {
            g.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
        } else {
            int deltaY;
            int deltaX;
            int xSize = sx2 - sx1;
            int ySize = sy2 - sy1;
            if (xDirection) {
                deltaX = xSize;
                deltaY = 0;
            } else {
                deltaX = 0;
                deltaY = ySize;
            }
            while (dx1 < dx2 && dy1 < dy2) {
                int newDX2 = Math.min(dx2, dx1 + xSize);
                int newDY2 = Math.min(dy2, dy1 + ySize);
                g.drawImage(image, dx1, dy1, newDX2, newDY2, sx1, sy1, sx1 + newDX2 - dx1, sy1 + newDY2 - dy1, null);
                dx1 += deltaX;
                dy1 += deltaY;
            }
        }
    }

    private static void drawImage(Image image, Graphics g, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        if (dx2 - dx1 <= 0 || dy2 - dy1 <= 0 || sx2 - sx1 <= 0 || sy2 - sy1 <= 0) {
            return;
        }
        g.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
    }

    static enum PaintType {
        CENTER,
        TILE,
        PAINT9_STRETCH,
        PAINT9_TILE;

    }
}

