/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.text.html.BlockView;

class NoFramesView
extends BlockView {
    boolean visible = false;

    public NoFramesView(Element elem, int axis) {
        super(elem, axis);
    }

    @Override
    public void paint(Graphics g, Shape allocation) {
        Container host = this.getContainer();
        if (host != null && this.visible != ((JTextComponent)host).isEditable()) {
            this.visible = ((JTextComponent)host).isEditable();
        }
        if (!this.isVisible()) {
            return;
        }
        super.paint(g, allocation);
    }

    @Override
    public void setParent(View p) {
        Container host;
        if (p != null && (host = p.getContainer()) != null) {
            this.visible = ((JTextComponent)host).isEditable();
        }
        super.setParent(p);
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    protected void layout(int width, int height) {
        if (!this.isVisible()) {
            return;
        }
        super.layout(width, height);
    }

    @Override
    public float getPreferredSpan(int axis) {
        if (!this.visible) {
            return 0.0f;
        }
        return super.getPreferredSpan(axis);
    }

    @Override
    public float getMinimumSpan(int axis) {
        if (!this.visible) {
            return 0.0f;
        }
        return super.getMinimumSpan(axis);
    }

    @Override
    public float getMaximumSpan(int axis) {
        if (!this.visible) {
            return 0.0f;
        }
        return super.getMaximumSpan(axis);
    }
}

