/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import sun.nio.fs.UnixException;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;

class UnixFileStoreAttributes {
    private long f_frsize;
    private long f_blocks;
    private long f_bfree;
    private long f_bavail;

    private UnixFileStoreAttributes() {
    }

    static UnixFileStoreAttributes get(UnixPath path) throws UnixException {
        UnixFileStoreAttributes attrs = new UnixFileStoreAttributes();
        UnixNativeDispatcher.statvfs(path, attrs);
        return attrs;
    }

    long blockSize() {
        return this.f_frsize;
    }

    long totalBlocks() {
        return this.f_blocks;
    }

    long freeBlocks() {
        return this.f_bfree;
    }

    long availableBlocks() {
        return this.f_bavail;
    }
}

