/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import com.sun.management.VMOption;
import java.util.ArrayList;
import java.util.List;

class Flag {
    private String name;
    private Object value;
    private VMOption.Origin origin;
    private boolean writeable;
    private boolean external;

    Flag(String name, Object value, boolean writeable, boolean external, VMOption.Origin origin) {
        this.name = name;
        this.value = value == null ? "" : value;
        this.origin = origin;
        this.writeable = writeable;
        this.external = external;
    }

    Object getValue() {
        return this.value;
    }

    boolean isWriteable() {
        return this.writeable;
    }

    boolean isExternal() {
        return this.external;
    }

    VMOption getVMOption() {
        return new VMOption(this.name, this.value.toString(), this.writeable, this.origin);
    }

    static Flag getFlag(String name) {
        String[] names = new String[]{name};
        List<Flag> flags = Flag.getFlags(names, 1);
        if (flags.isEmpty()) {
            return null;
        }
        return flags.get(0);
    }

    static List<Flag> getAllFlags() {
        int numFlags = Flag.getInternalFlagCount();
        return Flag.getFlags(null, numFlags);
    }

    private static List<Flag> getFlags(String[] names, int numFlags) {
        Flag[] flags = new Flag[numFlags];
        int count = Flag.getFlags(names, flags, numFlags);
        ArrayList<Flag> result = new ArrayList<Flag>();
        for (Flag f : flags) {
            if (f == null) continue;
            result.add(f);
        }
        return result;
    }

    private static native String[] getAllFlagNames();

    private static native int getFlags(String[] var0, Flag[] var1, int var2);

    private static native int getInternalFlagCount();

    static synchronized native void setLongValue(String var0, long var1);

    static synchronized native void setBooleanValue(String var0, boolean var1);

    static synchronized native void setStringValue(String var0, String var1);

    private static native void initialize();

    static {
        Flag.initialize();
    }
}

