/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.login;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.util.Objects;
import javax.security.auth.AuthPermission;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.ConfigurationSpi;
import sun.security.jca.GetInstance;

public abstract class Configuration {
    private static Configuration configuration;
    private final AccessControlContext acc = AccessController.getContext();

    private static void checkPermission(String type) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("createLoginConfiguration." + type));
        }
    }

    protected Configuration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration getConfiguration() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("getLoginConfiguration"));
        }
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            if (configuration == null) {
                String config_class = null;
                config_class = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return Security.getProperty("login.configuration.provider");
                    }
                });
                if (config_class == null) {
                    config_class = "com.sun.security.auth.login.ConfigFile";
                }
                try {
                    final String finalClass = config_class;
                    final Configuration untrustedImpl = AccessController.doPrivileged(new PrivilegedExceptionAction<Configuration>(){

                        @Override
                        public Configuration run() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
                            Class<Configuration> implClass = Class.forName(finalClass, false, Thread.currentThread().getContextClassLoader()).asSubclass(Configuration.class);
                            return implClass.newInstance();
                        }
                    });
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() {
                            Configuration.setConfiguration(untrustedImpl);
                            return null;
                        }
                    }, Objects.requireNonNull(untrustedImpl.acc));
                }
                catch (PrivilegedActionException e) {
                    Exception ee = e.getException();
                    if (ee instanceof InstantiationException) {
                        throw (SecurityException)new SecurityException("Configuration error:" + ee.getCause().getMessage() + "\n").initCause(ee.getCause());
                    }
                    throw (SecurityException)new SecurityException("Configuration error: " + ee.toString() + "\n").initCause(ee);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return configuration;
        }
    }

    public static void setConfiguration(Configuration configuration) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("setLoginConfiguration"));
        }
        Configuration.configuration = configuration;
    }

    public static Configuration getInstance(String type, Parameters params) throws NoSuchAlgorithmException {
        Configuration.checkPermission(type);
        try {
            GetInstance.Instance instance = GetInstance.getInstance("Configuration", ConfigurationSpi.class, type, params);
            return new ConfigDelegate((ConfigurationSpi)instance.impl, instance.provider, type, params);
        }
        catch (NoSuchAlgorithmException nsae) {
            return Configuration.handleException(nsae);
        }
    }

    public static Configuration getInstance(String type, Parameters params, String provider) throws NoSuchProviderException, NoSuchAlgorithmException {
        if (provider == null || provider.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        Configuration.checkPermission(type);
        try {
            GetInstance.Instance instance = GetInstance.getInstance("Configuration", ConfigurationSpi.class, type, (Object)params, provider);
            return new ConfigDelegate((ConfigurationSpi)instance.impl, instance.provider, type, params);
        }
        catch (NoSuchAlgorithmException nsae) {
            return Configuration.handleException(nsae);
        }
    }

    public static Configuration getInstance(String type, Parameters params, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("missing provider");
        }
        Configuration.checkPermission(type);
        try {
            GetInstance.Instance instance = GetInstance.getInstance("Configuration", ConfigurationSpi.class, type, (Object)params, provider);
            return new ConfigDelegate((ConfigurationSpi)instance.impl, instance.provider, type, params);
        }
        catch (NoSuchAlgorithmException nsae) {
            return Configuration.handleException(nsae);
        }
    }

    private static Configuration handleException(NoSuchAlgorithmException nsae) throws NoSuchAlgorithmException {
        Throwable cause = nsae.getCause();
        if (cause instanceof IllegalArgumentException) {
            throw (IllegalArgumentException)cause;
        }
        throw nsae;
    }

    public Provider getProvider() {
        return null;
    }

    public String getType() {
        return null;
    }

    public Parameters getParameters() {
        return null;
    }

    public abstract AppConfigurationEntry[] getAppConfigurationEntry(String var1);

    public void refresh() {
    }

    public static interface Parameters {
    }

    private static class ConfigDelegate
    extends Configuration {
        private ConfigurationSpi spi;
        private Provider p;
        private String type;
        private Parameters params;

        private ConfigDelegate(ConfigurationSpi spi, Provider p, String type, Parameters params) {
            this.spi = spi;
            this.p = p;
            this.type = type;
            this.params = params;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public Parameters getParameters() {
            return this.params;
        }

        @Override
        public Provider getProvider() {
            return this.p;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            return this.spi.engineGetAppConfigurationEntry(name);
        }

        @Override
        public void refresh() {
            this.spi.engineRefresh();
        }
    }
}

