/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.handler;

import java.util.Iterator;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.AbstractHandler;
import org.codehaus.xfire.service.Binding;
import org.codehaus.xfire.service.Endpoint;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.soap.handler.ReadHeadersHandler;
import org.codehaus.xfire.transport.Channel;

public class LocateBindingHandler
extends AbstractHandler {
    public LocateBindingHandler() {
        this.setPhase("dispatch");
        this.after(ReadHeadersHandler.class.getName());
    }

    public void invoke(MessageContext context) throws Exception {
        if (context.getBinding() != null) {
            return;
        }
        Channel c = context.getInMessage().getChannel();
        Service service = context.getService();
        if (service == null) {
            throw new XFireFault("Could not find a service to invoke.", XFireFault.SENDER);
        }
        Binding binding = c.getTransport().findBinding(context, service);
        if (binding == null) {
            throw new XFireFault("Could not find an appropriate Transport Binding to invoke.", XFireFault.SENDER);
        }
        if (!binding.isUndefinedEndpointAllowed()) {
            boolean defined = false;
            Iterator itr = service.getEndpoints().iterator();
            while (itr.hasNext()) {
                if (!((Endpoint)itr.next()).getUrl().equals(c.getUri())) continue;
                defined = true;
                break;
            }
            if (!defined) {
                throw new XFireFault("Invalid endpoint for service.", XFireFault.SENDER);
            }
        }
        context.setBinding(binding);
    }
}

