/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.EventQueue;
import com.sun.jndi.ldap.LdapCtx;
import com.sun.jndi.ldap.NamingEventNotifier;
import com.sun.jndi.ldap.NotifierArgs;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import javax.naming.ldap.UnsolicitedNotification;
import javax.naming.ldap.UnsolicitedNotificationEvent;
import javax.naming.ldap.UnsolicitedNotificationListener;

final class EventSupport {
    private static final boolean debug = false;
    private LdapCtx ctx;
    private Hashtable<NotifierArgs, NamingEventNotifier> notifiers = new Hashtable(11);
    private Vector<UnsolicitedNotificationListener> unsolicited = null;
    private EventQueue eventQueue;

    EventSupport(LdapCtx ctx) {
        this.ctx = ctx;
    }

    synchronized void addNamingListener(String nm, int scope, NamingListener l) throws NamingException {
        if (l instanceof ObjectChangeListener || l instanceof NamespaceChangeListener) {
            NotifierArgs args = new NotifierArgs(nm, scope, l);
            NamingEventNotifier notifier = this.notifiers.get(args);
            if (notifier == null) {
                notifier = new NamingEventNotifier(this, this.ctx, args, l);
                this.notifiers.put(args, notifier);
            } else {
                notifier.addNamingListener(l);
            }
        }
        if (l instanceof UnsolicitedNotificationListener) {
            if (this.unsolicited == null) {
                this.unsolicited = new Vector(3);
            }
            this.unsolicited.addElement((UnsolicitedNotificationListener)l);
        }
    }

    synchronized void addNamingListener(String nm, String filter, SearchControls ctls, NamingListener l) throws NamingException {
        if (l instanceof ObjectChangeListener || l instanceof NamespaceChangeListener) {
            NotifierArgs args = new NotifierArgs(nm, filter, ctls, l);
            NamingEventNotifier notifier = this.notifiers.get(args);
            if (notifier == null) {
                notifier = new NamingEventNotifier(this, this.ctx, args, l);
                this.notifiers.put(args, notifier);
            } else {
                notifier.addNamingListener(l);
            }
        }
        if (l instanceof UnsolicitedNotificationListener) {
            if (this.unsolicited == null) {
                this.unsolicited = new Vector(3);
            }
            this.unsolicited.addElement((UnsolicitedNotificationListener)l);
        }
    }

    synchronized void removeNamingListener(NamingListener l) {
        for (NamingEventNotifier notifier : this.notifiers.values()) {
            if (notifier == null) continue;
            notifier.removeNamingListener(l);
            if (notifier.hasNamingListeners()) continue;
            notifier.stop();
            this.notifiers.remove(notifier.info);
        }
        if (this.unsolicited != null) {
            this.unsolicited.removeElement(l);
        }
    }

    synchronized boolean hasUnsolicited() {
        return this.unsolicited != null && this.unsolicited.size() > 0;
    }

    synchronized void removeDeadNotifier(NotifierArgs info) {
        this.notifiers.remove(info);
    }

    synchronized void fireUnsolicited(Object obj) {
        if (this.unsolicited == null || this.unsolicited.size() == 0) {
            return;
        }
        if (obj instanceof UnsolicitedNotification) {
            UnsolicitedNotificationEvent evt = new UnsolicitedNotificationEvent(this.ctx, (UnsolicitedNotification)obj);
            this.queueEvent(evt, this.unsolicited);
        } else if (obj instanceof NamingException) {
            NamingExceptionEvent evt = new NamingExceptionEvent(this.ctx, (NamingException)obj);
            this.queueEvent(evt, this.unsolicited);
            this.unsolicited = null;
        }
    }

    synchronized void cleanup() {
        if (this.notifiers != null) {
            for (NamingEventNotifier notifier : this.notifiers.values()) {
                notifier.stop();
            }
            this.notifiers = null;
        }
        if (this.eventQueue != null) {
            this.eventQueue.stop();
            this.eventQueue = null;
        }
    }

    synchronized void queueEvent(EventObject event, Vector<? extends NamingListener> vector) {
        if (this.eventQueue == null) {
            this.eventQueue = new EventQueue();
        }
        Vector v = (Vector)vector.clone();
        this.eventQueue.enqueue(event, v);
    }
}

