/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote;

import com.sun.jmx.remote.util.ClassLogger;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerProvider;
import javax.management.remote.JMXProviderException;
import javax.management.remote.JMXServiceURL;

public class JMXConnectorServerFactory {
    public static final String DEFAULT_CLASS_LOADER = "jmx.remote.default.class.loader";
    public static final String DEFAULT_CLASS_LOADER_NAME = "jmx.remote.default.class.loader.name";
    public static final String PROTOCOL_PROVIDER_PACKAGES = "jmx.remote.protocol.provider.pkgs";
    public static final String PROTOCOL_PROVIDER_CLASS_LOADER = "jmx.remote.protocol.provider.class.loader";
    private static final String PROTOCOL_PROVIDER_DEFAULT_PACKAGE = "com.sun.jmx.remote.protocol";
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "JMXConnectorServerFactory");

    private JMXConnectorServerFactory() {
    }

    private static JMXConnectorServer getConnectorServerAsService(ClassLoader loader, JMXServiceURL url, Map<String, ?> map, MBeanServer mbs) throws IOException {
        Iterator<JMXConnectorServerProvider> providers = JMXConnectorFactory.getProviderIterator(JMXConnectorServerProvider.class, loader);
        IOException exception = null;
        while (providers.hasNext()) {
            try {
                return providers.next().newJMXConnectorServer(url, map, mbs);
            }
            catch (JMXProviderException e) {
                throw e;
            }
            catch (Exception e) {
                if (logger.traceOn()) {
                    logger.trace("getConnectorAsService", "URL[" + url + "] Service provider exception: " + e);
                }
                if (e instanceof MalformedURLException || exception != null) continue;
                if (e instanceof IOException) {
                    exception = (IOException)e;
                    continue;
                }
                exception = EnvHelp.initCause(new IOException(e.getMessage()), e);
            }
        }
        if (exception == null) {
            return null;
        }
        throw exception;
    }

    public static JMXConnectorServer newJMXConnectorServer(JMXServiceURL serviceURL, Map<String, ?> environment, MBeanServer mbeanServer) throws IOException {
        Map<Object, Object> envcopy;
        if (environment == null) {
            envcopy = new HashMap();
        } else {
            EnvHelp.checkAttributes(environment);
            envcopy = new HashMap(environment);
        }
        Class<JMXConnectorServerProvider> targetInterface = JMXConnectorServerProvider.class;
        ClassLoader loader = JMXConnectorFactory.resolveClassLoader(envcopy);
        String protocol = serviceURL.getProtocol();
        String providerClassName = "ServerProvider";
        JMXConnectorServerProvider provider = JMXConnectorFactory.getProvider(serviceURL, envcopy, "ServerProvider", targetInterface, loader);
        IOException exception = null;
        if (provider == null) {
            if (loader != null) {
                try {
                    JMXConnectorServer connection = JMXConnectorServerFactory.getConnectorServerAsService(loader, serviceURL, envcopy, mbeanServer);
                    if (connection != null) {
                        return connection;
                    }
                }
                catch (JMXProviderException e) {
                    throw e;
                }
                catch (IOException e) {
                    exception = e;
                }
            }
            provider = JMXConnectorFactory.getProvider(protocol, PROTOCOL_PROVIDER_DEFAULT_PACKAGE, JMXConnectorFactory.class.getClassLoader(), "ServerProvider", targetInterface);
        }
        if (provider == null) {
            MalformedURLException e = new MalformedURLException("Unsupported protocol: " + protocol);
            if (exception == null) {
                throw e;
            }
            throw EnvHelp.initCause(e, exception);
        }
        envcopy = Collections.unmodifiableMap(envcopy);
        return provider.newJMXConnectorServer(serviceURL, envcopy, mbeanServer);
    }
}

