/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import sun.awt.image.GifImageDecoder;

class GifFrame {
    private static final boolean verbose = false;
    private static IndexColorModel trans_model;
    static final int DISPOSAL_NONE = 0;
    static final int DISPOSAL_SAVE = 1;
    static final int DISPOSAL_BGCOLOR = 2;
    static final int DISPOSAL_PREVIOUS = 3;
    GifImageDecoder decoder;
    int disposal_method;
    int delay;
    IndexColorModel model;
    int x;
    int y;
    int width;
    int height;
    boolean initialframe;

    public GifFrame(GifImageDecoder id, int dm, int dl, boolean init, IndexColorModel cm, int x, int y, int w, int h) {
        this.decoder = id;
        this.disposal_method = dm;
        this.delay = dl;
        this.model = cm;
        this.initialframe = init;
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
    }

    private void setPixels(int x, int y, int w, int h, ColorModel cm, byte[] pix, int off, int scan) {
        this.decoder.setPixels(x, y, w, h, cm, pix, off, scan);
    }

    public boolean dispose() {
        if (this.decoder.imageComplete(2, false) == 0) {
            return false;
        }
        if (this.delay > 0) {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {
                return false;
            }
        } else {
            Thread.yield();
        }
        int global_width = this.decoder.global_width;
        int global_height = this.decoder.global_height;
        if (this.x < 0) {
            this.width += this.x;
            this.x = 0;
        }
        if (this.x + this.width > global_width) {
            this.width = global_width - this.x;
        }
        if (this.width <= 0) {
            this.disposal_method = 0;
        } else {
            if (this.y < 0) {
                this.height += this.y;
                this.y = 0;
            }
            if (this.y + this.height > global_height) {
                this.height = global_height - this.y;
            }
            if (this.height <= 0) {
                this.disposal_method = 0;
            }
        }
        switch (this.disposal_method) {
            case 3: {
                byte[] saved_image = this.decoder.saved_image;
                IndexColorModel saved_model = this.decoder.saved_model;
                if (saved_image == null) break;
                this.setPixels(this.x, this.y, this.width, this.height, saved_model, saved_image, this.y * global_width + this.x, global_width);
                break;
            }
            case 2: {
                int i;
                byte tpix;
                if (this.model.getTransparentPixel() < 0) {
                    this.model = trans_model;
                    if (this.model == null) {
                        trans_model = this.model = new IndexColorModel(8, 1, new byte[4], 0, true);
                    }
                    tpix = 0;
                } else {
                    tpix = (byte)this.model.getTransparentPixel();
                }
                byte[] rasline = new byte[this.width];
                if (tpix != 0) {
                    for (i = 0; i < this.width; ++i) {
                        rasline[i] = tpix;
                    }
                }
                if (this.decoder.saved_image != null) {
                    for (i = 0; i < global_width * global_height; ++i) {
                        this.decoder.saved_image[i] = tpix;
                    }
                }
                this.setPixels(this.x, this.y, this.width, this.height, this.model, rasline, 0, 0);
                break;
            }
            case 1: {
                this.decoder.saved_model = this.model;
            }
        }
        return true;
    }
}

