/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nio.sctp;

import com.sun.nio.sctp.SctpSocketOption;
import java.net.SocketAddress;
import sun.nio.ch.SctpStdSocketOption;

public class SctpStandardSocketOptions {
    public static final SctpSocketOption<Boolean> SCTP_DISABLE_FRAGMENTS = new SctpStdSocketOption<Boolean>("SCTP_DISABLE_FRAGMENTS", Boolean.class, 1);
    public static final SctpSocketOption<Boolean> SCTP_EXPLICIT_COMPLETE = new SctpStdSocketOption<Boolean>("SCTP_EXPLICIT_COMPLETE", Boolean.class, 2);
    public static final SctpSocketOption<Integer> SCTP_FRAGMENT_INTERLEAVE = new SctpStdSocketOption<Integer>("SCTP_FRAGMENT_INTERLEAVE", Integer.class, 3);
    public static final SctpSocketOption<InitMaxStreams> SCTP_INIT_MAXSTREAMS = new SctpStdSocketOption<InitMaxStreams>("SCTP_INIT_MAXSTREAMS", InitMaxStreams.class);
    public static final SctpSocketOption<Boolean> SCTP_NODELAY = new SctpStdSocketOption<Boolean>("SCTP_NODELAY", Boolean.class, 4);
    public static final SctpSocketOption<SocketAddress> SCTP_PRIMARY_ADDR = new SctpStdSocketOption<SocketAddress>("SCTP_PRIMARY_ADDR", SocketAddress.class);
    public static final SctpSocketOption<SocketAddress> SCTP_SET_PEER_PRIMARY_ADDR = new SctpStdSocketOption<SocketAddress>("SCTP_SET_PEER_PRIMARY_ADDR", SocketAddress.class);
    public static final SctpSocketOption<Integer> SO_SNDBUF = new SctpStdSocketOption<Integer>("SO_SNDBUF", Integer.class, 5);
    public static final SctpSocketOption<Integer> SO_RCVBUF = new SctpStdSocketOption<Integer>("SO_RCVBUF", Integer.class, 6);
    public static final SctpSocketOption<Integer> SO_LINGER = new SctpStdSocketOption<Integer>("SO_LINGER", Integer.class, 7);

    private SctpStandardSocketOptions() {
    }

    public static class InitMaxStreams {
        private int maxInStreams;
        private int maxOutStreams;

        private InitMaxStreams(int maxInStreams, int maxOutStreams) {
            this.maxInStreams = maxInStreams;
            this.maxOutStreams = maxOutStreams;
        }

        public static InitMaxStreams create(int maxInStreams, int maxOutStreams) {
            if (maxOutStreams < 0 || maxOutStreams > 65535) {
                throw new IllegalArgumentException("Invalid maxOutStreams value");
            }
            if (maxInStreams < 0 || maxInStreams > 65535) {
                throw new IllegalArgumentException("Invalid maxInStreams value");
            }
            return new InitMaxStreams(maxInStreams, maxOutStreams);
        }

        public int maxInStreams() {
            return this.maxInStreams;
        }

        public int maxOutStreams() {
            return this.maxOutStreams;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString()).append(" [");
            sb.append("maxInStreams:").append(this.maxInStreams);
            sb.append("maxOutStreams:").append(this.maxOutStreams).append("]");
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof InitMaxStreams) {
                InitMaxStreams that = (InitMaxStreams)obj;
                if (this.maxInStreams == that.maxInStreams && this.maxOutStreams == that.maxOutStreams) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            int hash = 7 ^ this.maxInStreams ^ this.maxOutStreams;
            return hash;
        }
    }
}

