/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.UserIdGroupPair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class IpPermission
implements Serializable {
    private String ipProtocol;
    private Integer fromPort;
    private Integer toPort;
    private ListWithAutoConstructFlag<UserIdGroupPair> userIdGroupPairs;
    private ListWithAutoConstructFlag<String> ipRanges;

    public String getIpProtocol() {
        return this.ipProtocol;
    }

    public void setIpProtocol(String ipProtocol) {
        this.ipProtocol = ipProtocol;
    }

    public IpPermission withIpProtocol(String ipProtocol) {
        this.ipProtocol = ipProtocol;
        return this;
    }

    public Integer getFromPort() {
        return this.fromPort;
    }

    public void setFromPort(Integer fromPort) {
        this.fromPort = fromPort;
    }

    public IpPermission withFromPort(Integer fromPort) {
        this.fromPort = fromPort;
        return this;
    }

    public Integer getToPort() {
        return this.toPort;
    }

    public void setToPort(Integer toPort) {
        this.toPort = toPort;
    }

    public IpPermission withToPort(Integer toPort) {
        this.toPort = toPort;
        return this;
    }

    public List<UserIdGroupPair> getUserIdGroupPairs() {
        if (this.userIdGroupPairs == null) {
            this.userIdGroupPairs = new ListWithAutoConstructFlag();
            this.userIdGroupPairs.setAutoConstruct(true);
        }
        return this.userIdGroupPairs;
    }

    public void setUserIdGroupPairs(Collection<UserIdGroupPair> userIdGroupPairs) {
        if (userIdGroupPairs == null) {
            this.userIdGroupPairs = null;
            return;
        }
        ListWithAutoConstructFlag userIdGroupPairsCopy = new ListWithAutoConstructFlag(userIdGroupPairs.size());
        userIdGroupPairsCopy.addAll(userIdGroupPairs);
        this.userIdGroupPairs = userIdGroupPairsCopy;
    }

    public IpPermission withUserIdGroupPairs(UserIdGroupPair ... userIdGroupPairs) {
        if (this.getUserIdGroupPairs() == null) {
            this.setUserIdGroupPairs(new ArrayList<UserIdGroupPair>(userIdGroupPairs.length));
        }
        for (UserIdGroupPair value : userIdGroupPairs) {
            this.getUserIdGroupPairs().add(value);
        }
        return this;
    }

    public IpPermission withUserIdGroupPairs(Collection<UserIdGroupPair> userIdGroupPairs) {
        if (userIdGroupPairs == null) {
            this.userIdGroupPairs = null;
        } else {
            ListWithAutoConstructFlag userIdGroupPairsCopy = new ListWithAutoConstructFlag(userIdGroupPairs.size());
            userIdGroupPairsCopy.addAll(userIdGroupPairs);
            this.userIdGroupPairs = userIdGroupPairsCopy;
        }
        return this;
    }

    public List<String> getIpRanges() {
        if (this.ipRanges == null) {
            this.ipRanges = new ListWithAutoConstructFlag();
            this.ipRanges.setAutoConstruct(true);
        }
        return this.ipRanges;
    }

    public void setIpRanges(Collection<String> ipRanges) {
        if (ipRanges == null) {
            this.ipRanges = null;
            return;
        }
        ListWithAutoConstructFlag ipRangesCopy = new ListWithAutoConstructFlag(ipRanges.size());
        ipRangesCopy.addAll(ipRanges);
        this.ipRanges = ipRangesCopy;
    }

    public IpPermission withIpRanges(String ... ipRanges) {
        if (this.getIpRanges() == null) {
            this.setIpRanges(new ArrayList<String>(ipRanges.length));
        }
        for (String value : ipRanges) {
            this.getIpRanges().add(value);
        }
        return this;
    }

    public IpPermission withIpRanges(Collection<String> ipRanges) {
        if (ipRanges == null) {
            this.ipRanges = null;
        } else {
            ListWithAutoConstructFlag ipRangesCopy = new ListWithAutoConstructFlag(ipRanges.size());
            ipRangesCopy.addAll(ipRanges);
            this.ipRanges = ipRangesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIpProtocol() != null) {
            sb.append("IpProtocol: " + this.getIpProtocol() + ",");
        }
        if (this.getFromPort() != null) {
            sb.append("FromPort: " + this.getFromPort() + ",");
        }
        if (this.getToPort() != null) {
            sb.append("ToPort: " + this.getToPort() + ",");
        }
        if (this.getUserIdGroupPairs() != null) {
            sb.append("UserIdGroupPairs: " + this.getUserIdGroupPairs() + ",");
        }
        if (this.getIpRanges() != null) {
            sb.append("IpRanges: " + this.getIpRanges());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIpProtocol() == null ? 0 : this.getIpProtocol().hashCode());
        hashCode = 31 * hashCode + (this.getFromPort() == null ? 0 : this.getFromPort().hashCode());
        hashCode = 31 * hashCode + (this.getToPort() == null ? 0 : this.getToPort().hashCode());
        hashCode = 31 * hashCode + (this.getUserIdGroupPairs() == null ? 0 : ((Object)this.getUserIdGroupPairs()).hashCode());
        hashCode = 31 * hashCode + (this.getIpRanges() == null ? 0 : ((Object)this.getIpRanges()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpPermission)) {
            return false;
        }
        IpPermission other = (IpPermission)obj;
        if (other.getIpProtocol() == null ^ this.getIpProtocol() == null) {
            return false;
        }
        if (other.getIpProtocol() != null && !other.getIpProtocol().equals(this.getIpProtocol())) {
            return false;
        }
        if (other.getFromPort() == null ^ this.getFromPort() == null) {
            return false;
        }
        if (other.getFromPort() != null && !other.getFromPort().equals(this.getFromPort())) {
            return false;
        }
        if (other.getToPort() == null ^ this.getToPort() == null) {
            return false;
        }
        if (other.getToPort() != null && !other.getToPort().equals(this.getToPort())) {
            return false;
        }
        if (other.getUserIdGroupPairs() == null ^ this.getUserIdGroupPairs() == null) {
            return false;
        }
        if (other.getUserIdGroupPairs() != null && !((Object)other.getUserIdGroupPairs()).equals(this.getUserIdGroupPairs())) {
            return false;
        }
        if (other.getIpRanges() == null ^ this.getIpRanges() == null) {
            return false;
        }
        return other.getIpRanges() == null || ((Object)other.getIpRanges()).equals(this.getIpRanges());
    }
}

