/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.plaf.metal.BumpBuffer;
import sun.awt.AppContext;

class MetalBumps
implements Icon {
    static final Color ALPHA = new Color(0, 0, 0, 0);
    protected int xBumps;
    protected int yBumps;
    protected Color topColor;
    protected Color shadowColor;
    protected Color backColor;
    private static final Object METAL_BUMPS = new Object();
    protected BumpBuffer buffer;

    public MetalBumps(int width, int height, Color newTopColor, Color newShadowColor, Color newBackColor) {
        this.setBumpArea(width, height);
        this.setBumpColors(newTopColor, newShadowColor, newBackColor);
    }

    private static BumpBuffer createBuffer(GraphicsConfiguration gc, Color topColor, Color shadowColor, Color backColor) {
        AppContext context = AppContext.getAppContext();
        ArrayList<BumpBuffer> buffers = (ArrayList<BumpBuffer>)context.get(METAL_BUMPS);
        if (buffers == null) {
            buffers = new ArrayList<BumpBuffer>();
            context.put(METAL_BUMPS, buffers);
        }
        for (BumpBuffer buffer : buffers) {
            if (!buffer.hasSameConfiguration(gc, topColor, shadowColor, backColor)) continue;
            return buffer;
        }
        BumpBuffer buffer = new BumpBuffer(gc, topColor, shadowColor, backColor);
        buffers.add(buffer);
        return buffer;
    }

    public void setBumpArea(Dimension bumpArea) {
        this.setBumpArea(bumpArea.width, bumpArea.height);
    }

    public void setBumpArea(int width, int height) {
        this.xBumps = width / 2;
        this.yBumps = height / 2;
    }

    public void setBumpColors(Color newTopColor, Color newShadowColor, Color newBackColor) {
        this.topColor = newTopColor;
        this.shadowColor = newShadowColor;
        this.backColor = newBackColor == null ? ALPHA : newBackColor;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        GraphicsConfiguration gc;
        GraphicsConfiguration graphicsConfiguration = gc = g instanceof Graphics2D ? ((Graphics2D)g).getDeviceConfiguration() : null;
        if (this.buffer == null || !this.buffer.hasSameConfiguration(gc, this.topColor, this.shadowColor, this.backColor)) {
            this.buffer = MetalBumps.createBuffer(gc, this.topColor, this.shadowColor, this.backColor);
        }
        int bufferWidth = 64;
        int bufferHeight = 64;
        int iconWidth = this.getIconWidth();
        int iconHeight = this.getIconHeight();
        int x2 = x + iconWidth;
        int y2 = y + iconHeight;
        int savex = x;
        while (y < y2) {
            int h = Math.min(y2 - y, bufferHeight);
            for (x = savex; x < x2; x += bufferWidth) {
                int w = Math.min(x2 - x, bufferWidth);
                g.drawImage(this.buffer.getImage(), x, y, x + w, y + h, 0, 0, w, h, null);
            }
            y += bufferHeight;
        }
    }

    @Override
    public int getIconWidth() {
        return this.xBumps * 2;
    }

    @Override
    public int getIconHeight() {
        return this.yBumps * 2;
    }
}

