/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Bits;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.SerialCallbackContext;
import java.io.Serializable;
import java.io.UTFDataFormatException;
import java.lang.ref.ReferenceQueue;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import sun.reflect.misc.ReflectUtil;
import sun.security.action.GetBooleanAction;

public class ObjectOutputStream
extends OutputStream
implements ObjectOutput,
ObjectStreamConstants {
    private final BlockDataOutputStream bout;
    private final HandleTable handles;
    private final ReplaceTable subs;
    private int protocol = 2;
    private int depth;
    private byte[] primVals;
    private final boolean enableOverride;
    private boolean enableReplace;
    private SerialCallbackContext curContext;
    private PutFieldImpl curPut;
    private final DebugTraceInfoStack debugInfoStack;
    private static final boolean extendedDebugInfo = AccessController.doPrivileged(new GetBooleanAction("sun.io.serialization.extendedDebugInfo"));

    public ObjectOutputStream(OutputStream out) throws IOException {
        this.verifySubclass();
        this.bout = new BlockDataOutputStream(out);
        this.handles = new HandleTable(10, 3.0f);
        this.subs = new ReplaceTable(10, 3.0f);
        this.enableOverride = false;
        this.writeStreamHeader();
        this.bout.setBlockDataMode(true);
        this.debugInfoStack = extendedDebugInfo ? new DebugTraceInfoStack() : null;
    }

    protected ObjectOutputStream() throws IOException, SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.bout = null;
        this.handles = null;
        this.subs = null;
        this.enableOverride = true;
        this.debugInfoStack = null;
    }

    public void useProtocolVersion(int version) throws IOException {
        if (this.handles.size() != 0) {
            throw new IllegalStateException("stream non-empty");
        }
        switch (version) {
            case 1: 
            case 2: {
                this.protocol = version;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown version: " + version);
            }
        }
    }

    @Override
    public final void writeObject(Object obj) throws IOException {
        if (this.enableOverride) {
            this.writeObjectOverride(obj);
            return;
        }
        try {
            this.writeObject0(obj, false);
        }
        catch (IOException ex) {
            if (this.depth == 0) {
                this.writeFatalException(ex);
            }
            throw ex;
        }
    }

    protected void writeObjectOverride(Object obj) throws IOException {
    }

    public void writeUnshared(Object obj) throws IOException {
        try {
            this.writeObject0(obj, true);
        }
        catch (IOException ex) {
            if (this.depth == 0) {
                this.writeFatalException(ex);
            }
            throw ex;
        }
    }

    public void defaultWriteObject() throws IOException {
        SerialCallbackContext ctx = this.curContext;
        if (ctx == null) {
            throw new NotActiveException("not in call to writeObject");
        }
        Object curObj = ctx.getObj();
        ObjectStreamClass curDesc = ctx.getDesc();
        this.bout.setBlockDataMode(false);
        this.defaultWriteFields(curObj, curDesc);
        this.bout.setBlockDataMode(true);
    }

    public PutField putFields() throws IOException {
        if (this.curPut == null) {
            SerialCallbackContext ctx = this.curContext;
            if (ctx == null) {
                throw new NotActiveException("not in call to writeObject");
            }
            Object curObj = ctx.getObj();
            ObjectStreamClass curDesc = ctx.getDesc();
            this.curPut = new PutFieldImpl(curDesc);
        }
        return this.curPut;
    }

    public void writeFields() throws IOException {
        if (this.curPut == null) {
            throw new NotActiveException("no current PutField object");
        }
        this.bout.setBlockDataMode(false);
        this.curPut.writeFields();
        this.bout.setBlockDataMode(true);
    }

    public void reset() throws IOException {
        if (this.depth != 0) {
            throw new IOException("stream active");
        }
        this.bout.setBlockDataMode(false);
        this.bout.writeByte(121);
        this.clear();
        this.bout.setBlockDataMode(true);
    }

    protected void annotateClass(Class<?> cl) throws IOException {
    }

    protected void annotateProxyClass(Class<?> cl) throws IOException {
    }

    protected Object replaceObject(Object obj) throws IOException {
        return obj;
    }

    protected boolean enableReplaceObject(boolean enable) throws SecurityException {
        SecurityManager sm;
        if (enable == this.enableReplace) {
            return enable;
        }
        if (enable && (sm = System.getSecurityManager()) != null) {
            sm.checkPermission(SUBSTITUTION_PERMISSION);
        }
        this.enableReplace = enable;
        return !this.enableReplace;
    }

    protected void writeStreamHeader() throws IOException {
        this.bout.writeShort(-21267);
        this.bout.writeShort(5);
    }

    protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
        desc.writeNonProxy(this);
    }

    @Override
    public void write(int val) throws IOException {
        this.bout.write(val);
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.bout.write(buf, 0, buf.length, false);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        int endoff = off + len;
        if (off < 0 || len < 0 || endoff > buf.length || endoff < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.bout.write(buf, off, len, false);
    }

    @Override
    public void flush() throws IOException {
        this.bout.flush();
    }

    protected void drain() throws IOException {
        this.bout.drain();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.clear();
        this.bout.close();
    }

    @Override
    public void writeBoolean(boolean val) throws IOException {
        this.bout.writeBoolean(val);
    }

    @Override
    public void writeByte(int val) throws IOException {
        this.bout.writeByte(val);
    }

    @Override
    public void writeShort(int val) throws IOException {
        this.bout.writeShort(val);
    }

    @Override
    public void writeChar(int val) throws IOException {
        this.bout.writeChar(val);
    }

    @Override
    public void writeInt(int val) throws IOException {
        this.bout.writeInt(val);
    }

    @Override
    public void writeLong(long val) throws IOException {
        this.bout.writeLong(val);
    }

    @Override
    public void writeFloat(float val) throws IOException {
        this.bout.writeFloat(val);
    }

    @Override
    public void writeDouble(double val) throws IOException {
        this.bout.writeDouble(val);
    }

    @Override
    public void writeBytes(String str) throws IOException {
        this.bout.writeBytes(str);
    }

    @Override
    public void writeChars(String str) throws IOException {
        this.bout.writeChars(str);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        this.bout.writeUTF(str);
    }

    int getProtocolVersion() {
        return this.protocol;
    }

    void writeTypeString(String str) throws IOException {
        if (str == null) {
            this.writeNull();
        } else {
            int handle = this.handles.lookup(str);
            if (handle != -1) {
                this.writeHandle(handle);
            } else {
                this.writeString(str, false);
            }
        }
    }

    private void verifySubclass() {
        Class<?> cl = this.getClass();
        if (cl == ObjectOutputStream.class) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return;
        }
        ObjectStreamClass.processQueue(Caches.subclassAuditsQueue, Caches.subclassAudits);
        ObjectStreamClass.WeakClassKey key = new ObjectStreamClass.WeakClassKey(cl, Caches.subclassAuditsQueue);
        Boolean result = (Boolean)Caches.subclassAudits.get(key);
        if (result == null) {
            result = ObjectOutputStream.auditSubclass(cl);
            Caches.subclassAudits.putIfAbsent(key, result);
        }
        if (result.booleanValue()) {
            return;
        }
        sm.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
    }

    private static boolean auditSubclass(final Class subcl) {
        Boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                for (Class cl = subcl; cl != ObjectOutputStream.class; cl = cl.getSuperclass()) {
                    try {
                        cl.getDeclaredMethod("writeUnshared", Object.class);
                        return Boolean.FALSE;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        try {
                            cl.getDeclaredMethod("putFields", null);
                            return Boolean.FALSE;
                        }
                        catch (NoSuchMethodException noSuchMethodException2) {
                            continue;
                        }
                    }
                }
                return Boolean.TRUE;
            }
        });
        return result;
    }

    private void clear() {
        this.subs.clear();
        this.handles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject0(Object obj, boolean unshared) throws IOException {
        block28: {
            boolean oldMode = this.bout.setBlockDataMode(false);
            ++this.depth;
            try {
                Class<?> repCl;
                ObjectStreamClass desc;
                int h;
                obj = this.subs.lookup(obj);
                if (obj == null) {
                    this.writeNull();
                    return;
                }
                if (!unshared && (h = this.handles.lookup(obj)) != -1) {
                    this.writeHandle(h);
                    return;
                }
                if (obj instanceof Class) {
                    this.writeClass((Class)obj, unshared);
                    return;
                }
                if (obj instanceof ObjectStreamClass) {
                    this.writeClassDesc((ObjectStreamClass)obj, unshared);
                    return;
                }
                Object orig = obj;
                Class<?> cl = obj.getClass();
                while ((desc = ObjectStreamClass.lookup(cl, true)).hasWriteReplaceMethod() && (obj = desc.invokeWriteReplace(obj)) != null && (repCl = obj.getClass()) != cl) {
                    cl = repCl;
                }
                if (this.enableReplace) {
                    Object rep = this.replaceObject(obj);
                    if (rep != obj && rep != null) {
                        cl = rep.getClass();
                        desc = ObjectStreamClass.lookup(cl, true);
                    }
                    obj = rep;
                }
                if (obj != orig) {
                    this.subs.assign(orig, obj);
                    if (obj == null) {
                        this.writeNull();
                        return;
                    }
                    if (!unshared && (h = this.handles.lookup(obj)) != -1) {
                        this.writeHandle(h);
                        return;
                    }
                    if (obj instanceof Class) {
                        this.writeClass((Class)obj, unshared);
                        return;
                    }
                    if (obj instanceof ObjectStreamClass) {
                        this.writeClassDesc((ObjectStreamClass)obj, unshared);
                        return;
                    }
                }
                if (obj instanceof String) {
                    this.writeString((String)obj, unshared);
                    break block28;
                }
                if (cl.isArray()) {
                    this.writeArray(obj, desc, unshared);
                    break block28;
                }
                if (obj instanceof Enum) {
                    this.writeEnum((Enum)obj, desc, unshared);
                    break block28;
                }
                if (obj instanceof Serializable) {
                    this.writeOrdinaryObject(obj, desc, unshared);
                    break block28;
                }
                if (extendedDebugInfo) {
                    throw new NotSerializableException(cl.getName() + "\n" + this.debugInfoStack.toString());
                }
                throw new NotSerializableException(cl.getName());
            }
            finally {
                --this.depth;
                this.bout.setBlockDataMode(oldMode);
            }
        }
    }

    private void writeNull() throws IOException {
        this.bout.writeByte(112);
    }

    private void writeHandle(int handle) throws IOException {
        this.bout.writeByte(113);
        this.bout.writeInt(0x7E0000 + handle);
    }

    private void writeClass(Class cl, boolean unshared) throws IOException {
        this.bout.writeByte(118);
        this.writeClassDesc(ObjectStreamClass.lookup(cl, true), false);
        this.handles.assign(unshared ? null : cl);
    }

    private void writeClassDesc(ObjectStreamClass desc, boolean unshared) throws IOException {
        int handle;
        if (desc == null) {
            this.writeNull();
        } else if (!unshared && (handle = this.handles.lookup(desc)) != -1) {
            this.writeHandle(handle);
        } else if (desc.isProxy()) {
            this.writeProxyDesc(desc, unshared);
        } else {
            this.writeNonProxyDesc(desc, unshared);
        }
    }

    private boolean isCustomSubclass() {
        return this.getClass().getClassLoader() != ObjectOutputStream.class.getClassLoader();
    }

    private void writeProxyDesc(ObjectStreamClass desc, boolean unshared) throws IOException {
        this.bout.writeByte(125);
        this.handles.assign(unshared ? null : desc);
        Class<?> cl = desc.forClass();
        Class<?>[] ifaces = cl.getInterfaces();
        this.bout.writeInt(ifaces.length);
        for (int i = 0; i < ifaces.length; ++i) {
            this.bout.writeUTF(ifaces[i].getName());
        }
        this.bout.setBlockDataMode(true);
        if (cl != null && this.isCustomSubclass()) {
            ReflectUtil.checkPackageAccess(cl);
        }
        this.annotateProxyClass(cl);
        this.bout.setBlockDataMode(false);
        this.bout.writeByte(120);
        this.writeClassDesc(desc.getSuperDesc(), false);
    }

    private void writeNonProxyDesc(ObjectStreamClass desc, boolean unshared) throws IOException {
        this.bout.writeByte(114);
        this.handles.assign(unshared ? null : desc);
        if (this.protocol == 1) {
            desc.writeNonProxy(this);
        } else {
            this.writeClassDescriptor(desc);
        }
        Class<?> cl = desc.forClass();
        this.bout.setBlockDataMode(true);
        if (cl != null && this.isCustomSubclass()) {
            ReflectUtil.checkPackageAccess(cl);
        }
        this.annotateClass(cl);
        this.bout.setBlockDataMode(false);
        this.bout.writeByte(120);
        this.writeClassDesc(desc.getSuperDesc(), false);
    }

    private void writeString(String str, boolean unshared) throws IOException {
        this.handles.assign(unshared ? null : str);
        long utflen = this.bout.getUTFLength(str);
        if (utflen <= 65535L) {
            this.bout.writeByte(116);
            this.bout.writeUTF(str, utflen);
        } else {
            this.bout.writeByte(124);
            this.bout.writeLongUTF(str, utflen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeArray(Object array, ObjectStreamClass desc, boolean unshared) throws IOException {
        this.bout.writeByte(117);
        this.writeClassDesc(desc, false);
        this.handles.assign(unshared ? null : array);
        Class<?> ccl = desc.forClass().getComponentType();
        if (ccl.isPrimitive()) {
            if (ccl == Integer.TYPE) {
                int[] ia = (int[])array;
                this.bout.writeInt(ia.length);
                this.bout.writeInts(ia, 0, ia.length);
                return;
            } else if (ccl == Byte.TYPE) {
                byte[] ba = (byte[])array;
                this.bout.writeInt(ba.length);
                this.bout.write(ba, 0, ba.length, true);
                return;
            } else if (ccl == Long.TYPE) {
                long[] ja = (long[])array;
                this.bout.writeInt(ja.length);
                this.bout.writeLongs(ja, 0, ja.length);
                return;
            } else if (ccl == Float.TYPE) {
                float[] fa = (float[])array;
                this.bout.writeInt(fa.length);
                this.bout.writeFloats(fa, 0, fa.length);
                return;
            } else if (ccl == Double.TYPE) {
                double[] da = (double[])array;
                this.bout.writeInt(da.length);
                this.bout.writeDoubles(da, 0, da.length);
                return;
            } else if (ccl == Short.TYPE) {
                short[] sa = (short[])array;
                this.bout.writeInt(sa.length);
                this.bout.writeShorts(sa, 0, sa.length);
                return;
            } else if (ccl == Character.TYPE) {
                char[] ca = (char[])array;
                this.bout.writeInt(ca.length);
                this.bout.writeChars(ca, 0, ca.length);
                return;
            } else {
                if (ccl != Boolean.TYPE) throw new InternalError();
                boolean[] za = (boolean[])array;
                this.bout.writeInt(za.length);
                this.bout.writeBooleans(za, 0, za.length);
            }
            return;
        }
        Object[] objs = (Object[])array;
        int len = objs.length;
        this.bout.writeInt(len);
        if (extendedDebugInfo) {
            this.debugInfoStack.push("array (class \"" + array.getClass().getName() + "\", size: " + len + ")");
        }
        try {
            for (int i = 0; i < len; ++i) {
                if (extendedDebugInfo) {
                    this.debugInfoStack.push("element of array (index: " + i + ")");
                }
                try {
                    this.writeObject0(objs[i], false);
                    continue;
                }
                finally {
                    if (extendedDebugInfo) {
                        this.debugInfoStack.pop();
                    }
                }
            }
            return;
        }
        finally {
            if (extendedDebugInfo) {
                this.debugInfoStack.pop();
            }
        }
    }

    private void writeEnum(Enum en, ObjectStreamClass desc, boolean unshared) throws IOException {
        this.bout.writeByte(126);
        ObjectStreamClass sdesc = desc.getSuperDesc();
        this.writeClassDesc(sdesc.forClass() == Enum.class ? desc : sdesc, false);
        this.handles.assign(unshared ? null : en);
        this.writeString(en.name(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOrdinaryObject(Object obj, ObjectStreamClass desc, boolean unshared) throws IOException {
        if (extendedDebugInfo) {
            this.debugInfoStack.push((this.depth == 1 ? "root " : "") + "object (class \"" + obj.getClass().getName() + "\", " + obj.toString() + ")");
        }
        try {
            desc.checkSerialize();
            this.bout.writeByte(115);
            this.writeClassDesc(desc, false);
            this.handles.assign(unshared ? null : obj);
            if (desc.isExternalizable() && !desc.isProxy()) {
                this.writeExternalData((Externalizable)obj);
            } else {
                this.writeSerialData(obj, desc);
            }
        }
        finally {
            if (extendedDebugInfo) {
                this.debugInfoStack.pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeExternalData(Externalizable obj) throws IOException {
        PutFieldImpl oldPut = this.curPut;
        this.curPut = null;
        if (extendedDebugInfo) {
            this.debugInfoStack.push("writeExternal data");
        }
        SerialCallbackContext oldContext = this.curContext;
        try {
            this.curContext = null;
            if (this.protocol == 1) {
                obj.writeExternal(this);
            } else {
                this.bout.setBlockDataMode(true);
                obj.writeExternal(this);
                this.bout.setBlockDataMode(false);
                this.bout.writeByte(120);
            }
        }
        finally {
            this.curContext = oldContext;
            if (extendedDebugInfo) {
                this.debugInfoStack.pop();
            }
        }
        this.curPut = oldPut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSerialData(Object obj, ObjectStreamClass desc) throws IOException {
        ObjectStreamClass.ClassDataSlot[] slots = desc.getClassDataLayout();
        for (int i = 0; i < slots.length; ++i) {
            ObjectStreamClass slotDesc = slots[i].desc;
            if (slotDesc.hasWriteObjectMethod()) {
                PutFieldImpl oldPut = this.curPut;
                this.curPut = null;
                SerialCallbackContext oldContext = this.curContext;
                if (extendedDebugInfo) {
                    this.debugInfoStack.push("custom writeObject data (class \"" + slotDesc.getName() + "\")");
                }
                try {
                    this.curContext = new SerialCallbackContext(obj, slotDesc);
                    this.bout.setBlockDataMode(true);
                    slotDesc.invokeWriteObject(obj, this);
                    this.bout.setBlockDataMode(false);
                    this.bout.writeByte(120);
                }
                finally {
                    this.curContext.setUsed();
                    this.curContext = oldContext;
                    if (extendedDebugInfo) {
                        this.debugInfoStack.pop();
                    }
                }
                this.curPut = oldPut;
                continue;
            }
            this.defaultWriteFields(obj, slotDesc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defaultWriteFields(Object obj, ObjectStreamClass desc) throws IOException {
        Class<?> cl = desc.forClass();
        if (cl != null && obj != null && !cl.isInstance(obj)) {
            throw new ClassCastException();
        }
        desc.checkDefaultSerialize();
        int primDataSize = desc.getPrimDataSize();
        if (this.primVals == null || this.primVals.length < primDataSize) {
            this.primVals = new byte[primDataSize];
        }
        desc.getPrimFieldValues(obj, this.primVals);
        this.bout.write(this.primVals, 0, primDataSize, false);
        ObjectStreamField[] fields = desc.getFields(false);
        Object[] objVals = new Object[desc.getNumObjFields()];
        int numPrimFields = fields.length - objVals.length;
        desc.getObjFieldValues(obj, objVals);
        for (int i = 0; i < objVals.length; ++i) {
            if (extendedDebugInfo) {
                this.debugInfoStack.push("field (class \"" + desc.getName() + "\", name: \"" + fields[numPrimFields + i].getName() + "\", type: \"" + fields[numPrimFields + i].getType() + "\")");
            }
            try {
                this.writeObject0(objVals[i], fields[numPrimFields + i].isUnshared());
                continue;
            }
            finally {
                if (extendedDebugInfo) {
                    this.debugInfoStack.pop();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFatalException(IOException ex) throws IOException {
        this.clear();
        boolean oldMode = this.bout.setBlockDataMode(false);
        try {
            this.bout.writeByte(123);
            this.writeObject0(ex, false);
            this.clear();
        }
        finally {
            this.bout.setBlockDataMode(oldMode);
        }
    }

    private static native void floatsToBytes(float[] var0, int var1, byte[] var2, int var3, int var4);

    private static native void doublesToBytes(double[] var0, int var1, byte[] var2, int var3, int var4);

    private static class DebugTraceInfoStack {
        private final List<String> stack = new ArrayList<String>();

        DebugTraceInfoStack() {
        }

        void clear() {
            this.stack.clear();
        }

        void pop() {
            this.stack.remove(this.stack.size() - 1);
        }

        void push(String entry) {
            this.stack.add("\t- " + entry);
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            if (!this.stack.isEmpty()) {
                for (int i = this.stack.size(); i > 0; --i) {
                    buffer.append(this.stack.get(i - 1) + (i != 1 ? "\n" : ""));
                }
            }
            return buffer.toString();
        }
    }

    private static class ReplaceTable {
        private final HandleTable htab;
        private Object[] reps;

        ReplaceTable(int initialCapacity, float loadFactor) {
            this.htab = new HandleTable(initialCapacity, loadFactor);
            this.reps = new Object[initialCapacity];
        }

        void assign(Object obj, Object rep) {
            int index = this.htab.assign(obj);
            while (index >= this.reps.length) {
                this.grow();
            }
            this.reps[index] = rep;
        }

        Object lookup(Object obj) {
            int index = this.htab.lookup(obj);
            return index >= 0 ? this.reps[index] : obj;
        }

        void clear() {
            Arrays.fill(this.reps, 0, this.htab.size(), null);
            this.htab.clear();
        }

        int size() {
            return this.htab.size();
        }

        private void grow() {
            Object[] newReps = new Object[(this.reps.length << 1) + 1];
            System.arraycopy(this.reps, 0, newReps, 0, this.reps.length);
            this.reps = newReps;
        }
    }

    private static class HandleTable {
        private int size;
        private int threshold;
        private final float loadFactor;
        private int[] spine;
        private int[] next;
        private Object[] objs;

        HandleTable(int initialCapacity, float loadFactor) {
            this.loadFactor = loadFactor;
            this.spine = new int[initialCapacity];
            this.next = new int[initialCapacity];
            this.objs = new Object[initialCapacity];
            this.threshold = (int)((float)initialCapacity * loadFactor);
            this.clear();
        }

        int assign(Object obj) {
            if (this.size >= this.next.length) {
                this.growEntries();
            }
            if (this.size >= this.threshold) {
                this.growSpine();
            }
            this.insert(obj, this.size);
            return this.size++;
        }

        int lookup(Object obj) {
            if (this.size == 0) {
                return -1;
            }
            int index = this.hash(obj) % this.spine.length;
            int i = this.spine[index];
            while (i >= 0) {
                if (this.objs[i] == obj) {
                    return i;
                }
                i = this.next[i];
            }
            return -1;
        }

        void clear() {
            Arrays.fill(this.spine, -1);
            Arrays.fill(this.objs, 0, this.size, null);
            this.size = 0;
        }

        int size() {
            return this.size;
        }

        private void insert(Object obj, int handle) {
            int index = this.hash(obj) % this.spine.length;
            this.objs[handle] = obj;
            this.next[handle] = this.spine[index];
            this.spine[index] = handle;
        }

        private void growSpine() {
            this.spine = new int[(this.spine.length << 1) + 1];
            this.threshold = (int)((float)this.spine.length * this.loadFactor);
            Arrays.fill(this.spine, -1);
            for (int i = 0; i < this.size; ++i) {
                this.insert(this.objs[i], i);
            }
        }

        private void growEntries() {
            int newLength = (this.next.length << 1) + 1;
            int[] newNext = new int[newLength];
            System.arraycopy(this.next, 0, newNext, 0, this.size);
            this.next = newNext;
            Object[] newObjs = new Object[newLength];
            System.arraycopy(this.objs, 0, newObjs, 0, this.size);
            this.objs = newObjs;
        }

        private int hash(Object obj) {
            return System.identityHashCode(obj) & Integer.MAX_VALUE;
        }
    }

    private static class BlockDataOutputStream
    extends OutputStream
    implements DataOutput {
        private static final int MAX_BLOCK_SIZE = 1024;
        private static final int MAX_HEADER_SIZE = 5;
        private static final int CHAR_BUF_SIZE = 256;
        private final byte[] buf = new byte[1024];
        private final byte[] hbuf = new byte[5];
        private final char[] cbuf = new char[256];
        private boolean blkmode = false;
        private int pos = 0;
        private final OutputStream out;
        private final DataOutputStream dout;

        BlockDataOutputStream(OutputStream out) {
            this.out = out;
            this.dout = new DataOutputStream(this);
        }

        boolean setBlockDataMode(boolean mode) throws IOException {
            if (this.blkmode == mode) {
                return this.blkmode;
            }
            this.drain();
            this.blkmode = mode;
            return !this.blkmode;
        }

        boolean getBlockDataMode() {
            return this.blkmode;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.pos >= 1024) {
                this.drain();
            }
            this.buf[this.pos++] = (byte)b;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length, false);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.write(b, off, len, false);
        }

        @Override
        public void flush() throws IOException {
            this.drain();
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.flush();
            this.out.close();
        }

        void write(byte[] b, int off, int len, boolean copy) throws IOException {
            if (!copy && !this.blkmode) {
                this.drain();
                this.out.write(b, off, len);
                return;
            }
            while (len > 0) {
                if (this.pos >= 1024) {
                    this.drain();
                }
                if (len >= 1024 && !copy && this.pos == 0) {
                    this.writeBlockHeader(1024);
                    this.out.write(b, off, 1024);
                    off += 1024;
                    len -= 1024;
                    continue;
                }
                int wlen = Math.min(len, 1024 - this.pos);
                System.arraycopy(b, off, this.buf, this.pos, wlen);
                this.pos += wlen;
                off += wlen;
                len -= wlen;
            }
        }

        void drain() throws IOException {
            if (this.pos == 0) {
                return;
            }
            if (this.blkmode) {
                this.writeBlockHeader(this.pos);
            }
            this.out.write(this.buf, 0, this.pos);
            this.pos = 0;
        }

        private void writeBlockHeader(int len) throws IOException {
            if (len <= 255) {
                this.hbuf[0] = 119;
                this.hbuf[1] = (byte)len;
                this.out.write(this.hbuf, 0, 2);
            } else {
                this.hbuf[0] = 122;
                Bits.putInt(this.hbuf, 1, len);
                this.out.write(this.hbuf, 0, 5);
            }
        }

        @Override
        public void writeBoolean(boolean v) throws IOException {
            if (this.pos >= 1024) {
                this.drain();
            }
            Bits.putBoolean(this.buf, this.pos++, v);
        }

        @Override
        public void writeByte(int v) throws IOException {
            if (this.pos >= 1024) {
                this.drain();
            }
            this.buf[this.pos++] = (byte)v;
        }

        @Override
        public void writeChar(int v) throws IOException {
            if (this.pos + 2 <= 1024) {
                Bits.putChar(this.buf, this.pos, (char)v);
                this.pos += 2;
            } else {
                this.dout.writeChar(v);
            }
        }

        @Override
        public void writeShort(int v) throws IOException {
            if (this.pos + 2 <= 1024) {
                Bits.putShort(this.buf, this.pos, (short)v);
                this.pos += 2;
            } else {
                this.dout.writeShort(v);
            }
        }

        @Override
        public void writeInt(int v) throws IOException {
            if (this.pos + 4 <= 1024) {
                Bits.putInt(this.buf, this.pos, v);
                this.pos += 4;
            } else {
                this.dout.writeInt(v);
            }
        }

        @Override
        public void writeFloat(float v) throws IOException {
            if (this.pos + 4 <= 1024) {
                Bits.putFloat(this.buf, this.pos, v);
                this.pos += 4;
            } else {
                this.dout.writeFloat(v);
            }
        }

        @Override
        public void writeLong(long v) throws IOException {
            if (this.pos + 8 <= 1024) {
                Bits.putLong(this.buf, this.pos, v);
                this.pos += 8;
            } else {
                this.dout.writeLong(v);
            }
        }

        @Override
        public void writeDouble(double v) throws IOException {
            if (this.pos + 8 <= 1024) {
                Bits.putDouble(this.buf, this.pos, v);
                this.pos += 8;
            } else {
                this.dout.writeDouble(v);
            }
        }

        @Override
        public void writeBytes(String s) throws IOException {
            int n;
            int endoff = s.length();
            int cpos = 0;
            int csize = 0;
            for (int off = 0; off < endoff; off += n) {
                if (cpos >= csize) {
                    cpos = 0;
                    csize = Math.min(endoff - off, 256);
                    s.getChars(off, off + csize, this.cbuf, 0);
                }
                if (this.pos >= 1024) {
                    this.drain();
                }
                n = Math.min(csize - cpos, 1024 - this.pos);
                int stop = this.pos + n;
                while (this.pos < stop) {
                    this.buf[this.pos++] = (byte)this.cbuf[cpos++];
                }
            }
        }

        @Override
        public void writeChars(String s) throws IOException {
            int csize;
            int endoff = s.length();
            for (int off = 0; off < endoff; off += csize) {
                csize = Math.min(endoff - off, 256);
                s.getChars(off, off + csize, this.cbuf, 0);
                this.writeChars(this.cbuf, 0, csize);
            }
        }

        @Override
        public void writeUTF(String s) throws IOException {
            this.writeUTF(s, this.getUTFLength(s));
        }

        void writeBooleans(boolean[] v, int off, int len) throws IOException {
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos >= 1024) {
                    this.drain();
                }
                int stop = Math.min(endoff, off + (1024 - this.pos));
                while (off < stop) {
                    Bits.putBoolean(this.buf, this.pos++, v[off++]);
                }
            }
        }

        void writeChars(char[] v, int off, int len) throws IOException {
            int limit = 1022;
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos <= limit) {
                    int avail = 1024 - this.pos >> 1;
                    int stop = Math.min(endoff, off + avail);
                    while (off < stop) {
                        Bits.putChar(this.buf, this.pos, v[off++]);
                        this.pos += 2;
                    }
                    continue;
                }
                this.dout.writeChar(v[off++]);
            }
        }

        void writeShorts(short[] v, int off, int len) throws IOException {
            int limit = 1022;
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos <= limit) {
                    int avail = 1024 - this.pos >> 1;
                    int stop = Math.min(endoff, off + avail);
                    while (off < stop) {
                        Bits.putShort(this.buf, this.pos, v[off++]);
                        this.pos += 2;
                    }
                    continue;
                }
                this.dout.writeShort(v[off++]);
            }
        }

        void writeInts(int[] v, int off, int len) throws IOException {
            int limit = 1020;
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos <= limit) {
                    int avail = 1024 - this.pos >> 2;
                    int stop = Math.min(endoff, off + avail);
                    while (off < stop) {
                        Bits.putInt(this.buf, this.pos, v[off++]);
                        this.pos += 4;
                    }
                    continue;
                }
                this.dout.writeInt(v[off++]);
            }
        }

        void writeFloats(float[] v, int off, int len) throws IOException {
            int limit = 1020;
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos <= limit) {
                    int avail = 1024 - this.pos >> 2;
                    int chunklen = Math.min(endoff - off, avail);
                    ObjectOutputStream.floatsToBytes(v, off, this.buf, this.pos, chunklen);
                    off += chunklen;
                    this.pos += chunklen << 2;
                    continue;
                }
                this.dout.writeFloat(v[off++]);
            }
        }

        void writeLongs(long[] v, int off, int len) throws IOException {
            int limit = 1016;
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos <= limit) {
                    int avail = 1024 - this.pos >> 3;
                    int stop = Math.min(endoff, off + avail);
                    while (off < stop) {
                        Bits.putLong(this.buf, this.pos, v[off++]);
                        this.pos += 8;
                    }
                    continue;
                }
                this.dout.writeLong(v[off++]);
            }
        }

        void writeDoubles(double[] v, int off, int len) throws IOException {
            int limit = 1016;
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos <= limit) {
                    int avail = 1024 - this.pos >> 3;
                    int chunklen = Math.min(endoff - off, avail);
                    ObjectOutputStream.doublesToBytes(v, off, this.buf, this.pos, chunklen);
                    off += chunklen;
                    this.pos += chunklen << 3;
                    continue;
                }
                this.dout.writeDouble(v[off++]);
            }
        }

        long getUTFLength(String s) {
            int csize;
            int len = s.length();
            long utflen = 0L;
            for (int off = 0; off < len; off += csize) {
                csize = Math.min(len - off, 256);
                s.getChars(off, off + csize, this.cbuf, 0);
                for (int cpos = 0; cpos < csize; ++cpos) {
                    char c = this.cbuf[cpos];
                    if (c >= '\u0001' && c <= '\u007f') {
                        ++utflen;
                        continue;
                    }
                    if (c > '\u07ff') {
                        utflen += 3L;
                        continue;
                    }
                    utflen += 2L;
                }
            }
            return utflen;
        }

        void writeUTF(String s, long utflen) throws IOException {
            if (utflen > 65535L) {
                throw new UTFDataFormatException();
            }
            this.writeShort((int)utflen);
            if (utflen == (long)s.length()) {
                this.writeBytes(s);
            } else {
                this.writeUTFBody(s);
            }
        }

        void writeLongUTF(String s) throws IOException {
            this.writeLongUTF(s, this.getUTFLength(s));
        }

        void writeLongUTF(String s, long utflen) throws IOException {
            this.writeLong(utflen);
            if (utflen == (long)s.length()) {
                this.writeBytes(s);
            } else {
                this.writeUTFBody(s);
            }
        }

        private void writeUTFBody(String s) throws IOException {
            int csize;
            int limit = 1021;
            int len = s.length();
            for (int off = 0; off < len; off += csize) {
                csize = Math.min(len - off, 256);
                s.getChars(off, off + csize, this.cbuf, 0);
                for (int cpos = 0; cpos < csize; ++cpos) {
                    char c = this.cbuf[cpos];
                    if (this.pos <= limit) {
                        if (c <= '\u007f' && c != '\u0000') {
                            this.buf[this.pos++] = (byte)c;
                            continue;
                        }
                        if (c > '\u07ff') {
                            this.buf[this.pos + 2] = (byte)(0x80 | c >> 0 & 0x3F);
                            this.buf[this.pos + 1] = (byte)(0x80 | c >> 6 & 0x3F);
                            this.buf[this.pos + 0] = (byte)(0xE0 | c >> 12 & 0xF);
                            this.pos += 3;
                            continue;
                        }
                        this.buf[this.pos + 1] = (byte)(0x80 | c >> 0 & 0x3F);
                        this.buf[this.pos + 0] = (byte)(0xC0 | c >> 6 & 0x1F);
                        this.pos += 2;
                        continue;
                    }
                    if (c <= '\u007f' && c != '\u0000') {
                        this.write(c);
                        continue;
                    }
                    if (c > '\u07ff') {
                        this.write(0xE0 | c >> 12 & 0xF);
                        this.write(0x80 | c >> 6 & 0x3F);
                        this.write(0x80 | c >> 0 & 0x3F);
                        continue;
                    }
                    this.write(0xC0 | c >> 6 & 0x1F);
                    this.write(0x80 | c >> 0 & 0x3F);
                }
            }
        }
    }

    private class PutFieldImpl
    extends PutField {
        private final ObjectStreamClass desc;
        private final byte[] primVals;
        private final Object[] objVals;

        PutFieldImpl(ObjectStreamClass desc) {
            this.desc = desc;
            this.primVals = new byte[desc.getPrimDataSize()];
            this.objVals = new Object[desc.getNumObjFields()];
        }

        @Override
        public void put(String name, boolean val) {
            Bits.putBoolean(this.primVals, this.getFieldOffset(name, Boolean.TYPE), val);
        }

        @Override
        public void put(String name, byte val) {
            this.primVals[this.getFieldOffset((String)name, Byte.TYPE)] = val;
        }

        @Override
        public void put(String name, char val) {
            Bits.putChar(this.primVals, this.getFieldOffset(name, Character.TYPE), val);
        }

        @Override
        public void put(String name, short val) {
            Bits.putShort(this.primVals, this.getFieldOffset(name, Short.TYPE), val);
        }

        @Override
        public void put(String name, int val) {
            Bits.putInt(this.primVals, this.getFieldOffset(name, Integer.TYPE), val);
        }

        @Override
        public void put(String name, float val) {
            Bits.putFloat(this.primVals, this.getFieldOffset(name, Float.TYPE), val);
        }

        @Override
        public void put(String name, long val) {
            Bits.putLong(this.primVals, this.getFieldOffset(name, Long.TYPE), val);
        }

        @Override
        public void put(String name, double val) {
            Bits.putDouble(this.primVals, this.getFieldOffset(name, Double.TYPE), val);
        }

        @Override
        public void put(String name, Object val) {
            this.objVals[this.getFieldOffset((String)name, Object.class)] = val;
        }

        @Override
        public void write(ObjectOutput out) throws IOException {
            if (ObjectOutputStream.this != out) {
                throw new IllegalArgumentException("wrong stream");
            }
            out.write(this.primVals, 0, this.primVals.length);
            ObjectStreamField[] fields = this.desc.getFields(false);
            int numPrimFields = fields.length - this.objVals.length;
            for (int i = 0; i < this.objVals.length; ++i) {
                if (fields[numPrimFields + i].isUnshared()) {
                    throw new IOException("cannot write unshared object");
                }
                out.writeObject(this.objVals[i]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeFields() throws IOException {
            ObjectOutputStream.this.bout.write(this.primVals, 0, this.primVals.length, false);
            ObjectStreamField[] fields = this.desc.getFields(false);
            int numPrimFields = fields.length - this.objVals.length;
            for (int i = 0; i < this.objVals.length; ++i) {
                if (extendedDebugInfo) {
                    ObjectOutputStream.this.debugInfoStack.push("field (class \"" + this.desc.getName() + "\", name: \"" + fields[numPrimFields + i].getName() + "\", type: \"" + fields[numPrimFields + i].getType() + "\")");
                }
                try {
                    ObjectOutputStream.this.writeObject0(this.objVals[i], fields[numPrimFields + i].isUnshared());
                    continue;
                }
                finally {
                    if (extendedDebugInfo) {
                        ObjectOutputStream.this.debugInfoStack.pop();
                    }
                }
            }
        }

        private int getFieldOffset(String name, Class type) {
            ObjectStreamField field = this.desc.getField(name, type);
            if (field == null) {
                throw new IllegalArgumentException("no such field " + name + " with type " + type);
            }
            return field.getOffset();
        }
    }

    public static abstract class PutField {
        public abstract void put(String var1, boolean var2);

        public abstract void put(String var1, byte var2);

        public abstract void put(String var1, char var2);

        public abstract void put(String var1, short var2);

        public abstract void put(String var1, int var2);

        public abstract void put(String var1, long var2);

        public abstract void put(String var1, float var2);

        public abstract void put(String var1, double var2);

        public abstract void put(String var1, Object var2);

        @Deprecated
        public abstract void write(ObjectOutput var1) throws IOException;
    }

    private static class Caches {
        static final ConcurrentMap<ObjectStreamClass.WeakClassKey, Boolean> subclassAudits = new ConcurrentHashMap<ObjectStreamClass.WeakClassKey, Boolean>();
        static final ReferenceQueue<Class<?>> subclassAuditsQueue = new ReferenceQueue();

        private Caches() {
        }
    }
}

