/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Point;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import sun.awt.image.DataBufferNative;
import sun.java2d.SurfaceData;

public class WritableRasterNative
extends WritableRaster {
    public static WritableRasterNative createNativeRaster(SampleModel sm, DataBuffer db) {
        return new WritableRasterNative(sm, db);
    }

    protected WritableRasterNative(SampleModel sm, DataBuffer db) {
        super(sm, db, new Point(0, 0));
    }

    public static WritableRasterNative createNativeRaster(ColorModel cm, SurfaceData sd, int width, int height) {
        SampleModel smHw = null;
        int dataType = 0;
        int scanStride = width;
        switch (cm.getPixelSize()) {
            case 8: 
            case 12: {
                dataType = cm.getPixelSize() == 8 ? 0 : 1;
                int[] bandOffsets = new int[]{0};
                smHw = new PixelInterleavedSampleModel(dataType, width, height, 1, scanStride, bandOffsets);
                break;
            }
            case 15: 
            case 16: {
                dataType = 1;
                int[] bitMasks = new int[3];
                DirectColorModel dcm = (DirectColorModel)cm;
                bitMasks[0] = dcm.getRedMask();
                bitMasks[1] = dcm.getGreenMask();
                bitMasks[2] = dcm.getBlueMask();
                smHw = new SinglePixelPackedSampleModel(dataType, width, height, scanStride, bitMasks);
                break;
            }
            case 24: 
            case 32: {
                dataType = 3;
                int[] bitMasks = new int[3];
                DirectColorModel dcm = (DirectColorModel)cm;
                bitMasks[0] = dcm.getRedMask();
                bitMasks[1] = dcm.getGreenMask();
                bitMasks[2] = dcm.getBlueMask();
                smHw = new SinglePixelPackedSampleModel(dataType, width, height, scanStride, bitMasks);
                break;
            }
            default: {
                throw new InternalError("Unsupported depth " + cm.getPixelSize());
            }
        }
        DataBufferNative dbn = new DataBufferNative(sd, dataType, width, height);
        return new WritableRasterNative(smHw, dbn);
    }
}

