/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.Introspector;
import com.sun.jmx.mbeanserver.ModifiableClassLoaderRepository;
import com.sun.jmx.mbeanserver.ObjectInputStreamWithLoader;
import com.sun.jmx.mbeanserver.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanPermission;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import sun.reflect.misc.ConstructorUtil;
import sun.reflect.misc.ReflectUtil;

public class MBeanInstantiator {
    private final ModifiableClassLoaderRepository clr;
    private static final Map<String, Class<?>> primitiveClasses = Util.newMap();

    MBeanInstantiator(ModifiableClassLoaderRepository clr) {
        this.clr = clr;
    }

    public void testCreation(Class<?> c) throws NotCompliantMBeanException {
        Introspector.testCreation(c);
    }

    public Class<?> findClassWithDefaultLoaderRepository(String className) throws ReflectionException {
        Class<?> theClass;
        if (className == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The class name cannot be null"), "Exception occurred during object instantiation");
        }
        ReflectUtil.checkPackageAccess(className);
        try {
            if (this.clr == null) {
                throw new ClassNotFoundException(className);
            }
            theClass = this.clr.loadClass(className);
        }
        catch (ClassNotFoundException ee) {
            throw new ReflectionException(ee, "The MBean class could not be loaded by the default loader repository");
        }
        return theClass;
    }

    public Class<?> findClass(String className, ClassLoader loader) throws ReflectionException {
        return MBeanInstantiator.loadClass(className, loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> findClass(String className, ObjectName aLoader) throws ReflectionException, InstanceNotFoundException {
        if (aLoader == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Null loader passed in parameter");
        }
        ClassLoader loader = null;
        MBeanInstantiator mBeanInstantiator = this;
        synchronized (mBeanInstantiator) {
            loader = this.getClassLoader(aLoader);
        }
        if (loader == null) {
            throw new InstanceNotFoundException("The loader named " + aLoader + " is not registered in the MBeanServer");
        }
        return this.findClass(className, loader);
    }

    public Class<?>[] findSignatureClasses(String[] signature, ClassLoader loader) throws ReflectionException {
        if (signature == null) {
            return null;
        }
        ClassLoader aLoader = loader;
        int length = signature.length;
        Class[] tab = new Class[length];
        if (length == 0) {
            return tab;
        }
        try {
            for (int i = 0; i < length; ++i) {
                Class<?> primCla = primitiveClasses.get(signature[i]);
                if (primCla != null) {
                    tab[i] = primCla;
                    continue;
                }
                ReflectUtil.checkPackageAccess(signature[i]);
                tab[i] = aLoader != null ? Class.forName(signature[i], false, aLoader) : this.findClass(signature[i], this.getClass().getClassLoader());
            }
        }
        catch (ClassNotFoundException e) {
            if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINEST, MBeanInstantiator.class.getName(), "findSignatureClasses", "The parameter class could not be found", e);
            }
            throw new ReflectionException(e, "The parameter class could not be found");
        }
        catch (RuntimeException e) {
            if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINEST, MBeanInstantiator.class.getName(), "findSignatureClasses", "Unexpected exception", e);
            }
            throw e;
        }
        return tab;
    }

    public Object instantiate(Class<?> theClass) throws ReflectionException, MBeanException {
        Object moi;
        MBeanInstantiator.checkMBeanPermission(theClass, null, null, "instantiate");
        Constructor<?> cons = this.findConstructor(theClass, null);
        if (cons == null) {
            throw new ReflectionException(new NoSuchMethodException("No such constructor"));
        }
        try {
            ReflectUtil.checkPackageAccess(theClass);
            MBeanInstantiator.ensureClassAccess(theClass);
            moi = cons.newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)t, "RuntimeException thrown in the MBean's empty constructor");
            }
            if (t instanceof Error) {
                throw new RuntimeErrorException((Error)t, "Error thrown in the MBean's empty constructor");
            }
            throw new MBeanException((Exception)t, "Exception thrown in the MBean's empty constructor");
        }
        catch (NoSuchMethodError error) {
            throw new ReflectionException(new NoSuchMethodException("No constructor"), "No such constructor");
        }
        catch (InstantiationException e) {
            throw new ReflectionException(e, "Exception thrown trying to invoke the MBean's empty constructor");
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e, "Exception thrown trying to invoke the MBean's empty constructor");
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e, "Exception thrown trying to invoke the MBean's empty constructor");
        }
        return moi;
    }

    public Object instantiate(Class<?> theClass, Object[] params, String[] signature, ClassLoader loader) throws ReflectionException, MBeanException {
        Object moi;
        Class<?>[] tab;
        MBeanInstantiator.checkMBeanPermission(theClass, null, null, "instantiate");
        try {
            ClassLoader aLoader = theClass.getClassLoader();
            tab = signature == null ? null : this.findSignatureClasses(signature, aLoader);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e, "The constructor parameter classes could not be loaded");
        }
        Constructor<?> cons = this.findConstructor(theClass, tab);
        if (cons == null) {
            throw new ReflectionException(new NoSuchMethodException("No such constructor"));
        }
        try {
            ReflectUtil.checkPackageAccess(theClass);
            MBeanInstantiator.ensureClassAccess(theClass);
            moi = cons.newInstance(params);
        }
        catch (NoSuchMethodError error) {
            throw new ReflectionException(new NoSuchMethodException("No such constructor found"), "No such constructor");
        }
        catch (InstantiationException e) {
            throw new ReflectionException(e, "Exception thrown trying to invoke the MBean's constructor");
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e, "Exception thrown trying to invoke the MBean's constructor");
        }
        catch (InvocationTargetException e) {
            Throwable th = e.getTargetException();
            if (th instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)th, "RuntimeException thrown in the MBean's constructor");
            }
            if (th instanceof Error) {
                throw new RuntimeErrorException((Error)th, "Error thrown in the MBean's constructor");
            }
            throw new MBeanException((Exception)th, "Exception thrown in the MBean's constructor");
        }
        return moi;
    }

    public ObjectInputStream deserialize(ClassLoader loader, byte[] data) throws OperationsException {
        ObjectInputStreamWithLoader objIn;
        if (data == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Null data passed in parameter");
        }
        if (data.length == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Empty data passed in parameter");
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(data);
        try {
            objIn = new ObjectInputStreamWithLoader(bIn, loader);
        }
        catch (IOException e) {
            throw new OperationsException("An IOException occurred trying to de-serialize the data");
        }
        return objIn;
    }

    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data, ClassLoader loader) throws InstanceNotFoundException, OperationsException, ReflectionException {
        ObjectInputStreamWithLoader objIn;
        Class<?> theClass;
        if (data == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Null data passed in parameter");
        }
        if (data.length == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Empty data passed in parameter");
        }
        if (className == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Null className passed in parameter");
        }
        ReflectUtil.checkPackageAccess(className);
        if (loaderName == null) {
            theClass = this.findClass(className, loader);
        } else {
            try {
                ClassLoader instance = null;
                instance = this.getClassLoader(loaderName);
                if (instance == null) {
                    throw new ClassNotFoundException(className);
                }
                theClass = Class.forName(className, false, instance);
            }
            catch (ClassNotFoundException e) {
                throw new ReflectionException(e, "The MBean class could not be loaded by the " + loaderName.toString() + " class loader");
            }
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(data);
        try {
            objIn = new ObjectInputStreamWithLoader(bIn, theClass.getClassLoader());
        }
        catch (IOException e) {
            throw new OperationsException("An IOException occurred trying to de-serialize the data");
        }
        return objIn;
    }

    public Object instantiate(String className) throws ReflectionException, MBeanException {
        return this.instantiate(className, (Object[])null, (String[])null, null);
    }

    public Object instantiate(String className, ObjectName loaderName, ClassLoader loader) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.instantiate(className, loaderName, null, null, loader);
    }

    public Object instantiate(String className, Object[] params, String[] signature, ClassLoader loader) throws ReflectionException, MBeanException {
        Class<?> theClass = this.findClassWithDefaultLoaderRepository(className);
        return this.instantiate(theClass, params, signature, loader);
    }

    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature, ClassLoader loader) throws ReflectionException, MBeanException, InstanceNotFoundException {
        Class<?> theClass = loaderName == null ? this.findClass(className, loader) : this.findClass(className, loaderName);
        return this.instantiate(theClass, params, signature, loader);
    }

    public ModifiableClassLoaderRepository getClassLoaderRepository() {
        MBeanInstantiator.checkMBeanPermission((String)null, null, null, "getClassLoaderRepository");
        return this.clr;
    }

    static Class<?> loadClass(String className, ClassLoader loader) throws ReflectionException {
        Class<?> theClass;
        if (className == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The class name cannot be null"), "Exception occurred during object instantiation");
        }
        ReflectUtil.checkPackageAccess(className);
        try {
            if (loader == null) {
                loader = MBeanInstantiator.class.getClassLoader();
            }
            theClass = loader != null ? Class.forName(className, false, loader) : Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e, "The MBean class could not be loaded");
        }
        return theClass;
    }

    static Class<?>[] loadSignatureClasses(String[] signature, ClassLoader loader) throws ReflectionException {
        if (signature == null) {
            return null;
        }
        ClassLoader aLoader = loader == null ? MBeanInstantiator.class.getClassLoader() : loader;
        int length = signature.length;
        Class[] tab = new Class[length];
        if (length == 0) {
            return tab;
        }
        try {
            for (int i = 0; i < length; ++i) {
                Class<?> primCla = primitiveClasses.get(signature[i]);
                if (primCla != null) {
                    tab[i] = primCla;
                    continue;
                }
                ReflectUtil.checkPackageAccess(signature[i]);
                tab[i] = Class.forName(signature[i], false, aLoader);
            }
        }
        catch (ClassNotFoundException e) {
            if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINEST, MBeanInstantiator.class.getName(), "findSignatureClasses", "The parameter class could not be found", e);
            }
            throw new ReflectionException(e, "The parameter class could not be found");
        }
        catch (RuntimeException e) {
            if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINEST, MBeanInstantiator.class.getName(), "findSignatureClasses", "Unexpected exception", e);
            }
            throw e;
        }
        return tab;
    }

    private Constructor<?> findConstructor(Class<?> c, Class<?>[] params) {
        try {
            return ConstructorUtil.getConstructor(c, params);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void checkMBeanPermission(Class<?> clazz, String member, ObjectName objectName, String actions2) {
        if (clazz != null) {
            MBeanInstantiator.checkMBeanPermission(clazz.getName(), member, objectName, actions2);
        }
    }

    private static void checkMBeanPermission(String classname, String member, ObjectName objectName, String actions2) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            MBeanPermission perm = new MBeanPermission(classname, member, objectName, actions2);
            sm.checkPermission(perm);
        }
    }

    private static void ensureClassAccess(Class clazz) throws IllegalAccessException {
        int mod = clazz.getModifiers();
        if (!Modifier.isPublic(mod)) {
            throw new IllegalAccessException("Class is not public and can't be instantiated");
        }
    }

    private ClassLoader getClassLoader(final ObjectName name) {
        if (this.clr == null) {
            return null;
        }
        Permissions permissions = new Permissions();
        permissions.add(new MBeanPermission("*", null, name, "getClassLoader"));
        ProtectionDomain protectionDomain = new ProtectionDomain(null, permissions);
        ProtectionDomain[] domains = new ProtectionDomain[]{protectionDomain};
        AccessControlContext ctx = new AccessControlContext(domains);
        ClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return MBeanInstantiator.this.clr.getClassLoader(name);
            }
        }, ctx);
        return loader;
    }

    static {
        for (Class c : new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Character.TYPE, Boolean.TYPE}) {
            primitiveClasses.put(c.getName(), c);
        }
    }
}

