/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.lang.invoke.CallSite;
import java.lang.invoke.Invokers;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleProxies;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.sql.DriverManager;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.Logger;
import javax.sql.rowset.serial.SerialJavaObject;
import sun.misc.Unsafe;
import sun.reflect.Reflection;

class MethodHandleNatives {
    static final boolean COUNT_GWT;
    private static String[] REFERENCE_KIND_NAME;

    private MethodHandleNatives() {
    }

    static native void init(MemberName var0, Object var1);

    static native void expand(MemberName var0);

    static native MemberName resolve(MemberName var0, Class<?> var1) throws LinkageError, ClassNotFoundException;

    static native int getMembers(Class<?> var0, String var1, String var2, int var3, Class<?> var4, int var5, MemberName[] var6);

    static native long objectFieldOffset(MemberName var0);

    static native long staticFieldOffset(MemberName var0);

    static native Object staticFieldBase(MemberName var0);

    static native Object getMemberVMInfo(MemberName var0);

    static native int getConstant(int var0);

    static native void setCallSiteTargetNormal(CallSite var0, MethodHandle var1);

    static native void setCallSiteTargetVolatile(CallSite var0, MethodHandle var1);

    private static native void registerNatives();

    static boolean refKindIsValid(int refKind) {
        return refKind > 0 && refKind < 10;
    }

    static boolean refKindIsField(byte refKind) {
        assert (MethodHandleNatives.refKindIsValid(refKind));
        return refKind <= 4;
    }

    static boolean refKindIsGetter(byte refKind) {
        assert (MethodHandleNatives.refKindIsValid(refKind));
        return refKind <= 2;
    }

    static boolean refKindIsSetter(byte refKind) {
        return MethodHandleNatives.refKindIsField(refKind) && !MethodHandleNatives.refKindIsGetter(refKind);
    }

    static boolean refKindIsMethod(byte refKind) {
        return !MethodHandleNatives.refKindIsField(refKind) && refKind != 8;
    }

    static boolean refKindHasReceiver(byte refKind) {
        assert (MethodHandleNatives.refKindIsValid(refKind));
        return (refKind & 1) != 0;
    }

    static boolean refKindIsStatic(byte refKind) {
        return !MethodHandleNatives.refKindHasReceiver(refKind) && refKind != 8;
    }

    static boolean refKindDoesDispatch(byte refKind) {
        assert (MethodHandleNatives.refKindIsValid(refKind));
        return refKind == 5 || refKind == 9;
    }

    static String refKindName(byte refKind) {
        assert (MethodHandleNatives.refKindIsValid(refKind));
        return REFERENCE_KIND_NAME[refKind];
    }

    private static native int getNamedCon(int var0, Object[] var1);

    static boolean verifyConstants() {
        Object[] box = new Object[]{null};
        int i = 0;
        while (true) {
            block4: {
                box[0] = null;
                int vmval = MethodHandleNatives.getNamedCon(i, box);
                if (box[0] == null) break;
                String name = (String)box[0];
                try {
                    Field con = Constants.class.getDeclaredField(name);
                    int jval = con.getInt(null);
                    if (jval == vmval) break block4;
                    String err = name + ": JVM has " + vmval + " while Java has " + jval;
                    if (name.equals("CONV_OP_LIMIT")) {
                        System.err.println("warning: " + err);
                        break block4;
                    }
                    throw new InternalError(err);
                }
                catch (IllegalAccessException | NoSuchFieldException ex) {
                    String err = name + ": JVM has " + vmval + " which Java does not define";
                }
            }
            ++i;
        }
        return true;
    }

    static MemberName linkCallSite(Object callerObj, Object bootstrapMethodObj, Object nameObj, Object typeObj, Object staticArguments, Object[] appendixResult) {
        MethodHandle bootstrapMethod = (MethodHandle)bootstrapMethodObj;
        Class caller = (Class)callerObj;
        String name = nameObj.toString().intern();
        MethodType type = (MethodType)typeObj;
        appendixResult[0] = CallSite.makeSite(bootstrapMethod, name, type, staticArguments, caller);
        return Invokers.linkToCallSiteMethod(type);
    }

    static MethodType findMethodHandleType(Class<?> rtype, Class<?>[] ptypes) {
        return MethodType.makeImpl(rtype, ptypes, true);
    }

    static MemberName linkMethod(Class<?> callerClass, int refKind, Class<?> defc, String name, Object type, Object[] appendixResult) {
        if (!MethodHandleStatics.TRACE_METHOD_LINKAGE) {
            return MethodHandleNatives.linkMethodImpl(callerClass, refKind, defc, name, type, appendixResult);
        }
        return MethodHandleNatives.linkMethodTracing(callerClass, refKind, defc, name, type, appendixResult);
    }

    static MemberName linkMethodImpl(Class<?> callerClass, int refKind, Class<?> defc, String name, Object type, Object[] appendixResult) {
        try {
            if (defc == MethodHandle.class && refKind == 5) {
                switch (name) {
                    case "invoke": {
                        return Invokers.genericInvokerMethod(MethodHandleNatives.fixMethodType(callerClass, type), appendixResult);
                    }
                    case "invokeExact": {
                        return Invokers.exactInvokerMethod(MethodHandleNatives.fixMethodType(callerClass, type), appendixResult);
                    }
                }
            }
        }
        catch (Throwable ex) {
            if (ex instanceof LinkageError) {
                throw (LinkageError)ex;
            }
            throw new LinkageError(ex.getMessage(), ex);
        }
        throw new LinkageError("no such method " + defc.getName() + "." + name + type);
    }

    private static MethodType fixMethodType(Class<?> callerClass, Object type) {
        if (type instanceof MethodType) {
            return (MethodType)type;
        }
        return MethodType.fromMethodDescriptorString((String)type, callerClass.getClassLoader());
    }

    static MemberName linkMethodTracing(Class<?> callerClass, int refKind, Class<?> defc, String name, Object type, Object[] appendixResult) {
        System.out.println("linkMethod " + defc.getName() + "." + name + type + "/" + Integer.toHexString(refKind));
        try {
            MemberName res = MethodHandleNatives.linkMethodImpl(callerClass, refKind, defc, name, type, appendixResult);
            System.out.println("linkMethod => " + res + " + " + appendixResult[0]);
            return res;
        }
        catch (Throwable ex) {
            System.out.println("linkMethod => throw " + ex);
            throw ex;
        }
    }

    static MethodHandle linkMethodHandleConstant(Class<?> callerClass, int refKind, Class<?> defc, String name, Object type) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.Lookup.IMPL_LOOKUP.in(callerClass);
            assert (MethodHandleNatives.refKindIsValid(refKind));
            return lookup.linkMethodHandleConstant((byte)refKind, defc, name, type);
        }
        catch (ReflectiveOperationException ex) {
            IncompatibleClassChangeError err = new IncompatibleClassChangeError();
            err.initCause(ex);
            throw err;
        }
    }

    static boolean isCallerSensitive(MemberName mem) {
        if (!mem.isMethod()) {
            return false;
        }
        return MethodHandleNatives.isCallerSensitiveMethod(mem.getDeclaringClass(), mem.getName()) || MethodHandleNatives.canBeCalledVirtual(mem);
    }

    private static boolean isCallerSensitiveMethod(Class<?> defc, String method) {
        switch (method) {
            case "doPrivileged": 
            case "doPrivilegedWithCombiner": {
                return defc == AccessController.class;
            }
            case "checkMemberAccess": {
                return defc == SecurityManager.class;
            }
            case "getUnsafe": {
                return defc == Unsafe.class;
            }
            case "lookup": {
                return defc == MethodHandles.class;
            }
            case "invoke": {
                return defc == Method.class;
            }
            case "get": 
            case "getBoolean": 
            case "getByte": 
            case "getChar": 
            case "getShort": 
            case "getInt": 
            case "getLong": 
            case "getFloat": 
            case "getDouble": 
            case "set": 
            case "setBoolean": 
            case "setByte": 
            case "setChar": 
            case "setShort": 
            case "setInt": 
            case "setLong": 
            case "setFloat": 
            case "setDouble": {
                return defc == Field.class;
            }
            case "newInstance": {
                if (defc == Constructor.class) {
                    return true;
                }
                if (defc != Class.class) break;
                return true;
            }
            case "getFields": {
                return defc == Class.class || defc == SerialJavaObject.class;
            }
            case "forName": 
            case "getClassLoader": 
            case "getClasses": 
            case "getMethods": 
            case "getConstructors": 
            case "getDeclaredClasses": 
            case "getDeclaredFields": 
            case "getDeclaredMethods": 
            case "getDeclaredConstructors": 
            case "getField": 
            case "getMethod": 
            case "getConstructor": 
            case "getDeclaredField": 
            case "getDeclaredMethod": 
            case "getDeclaredConstructor": 
            case "getDeclaringClass": 
            case "getEnclosingClass": 
            case "getEnclosingMethod": 
            case "getEnclosingConstructor": {
                return defc == Class.class;
            }
            case "getConnection": 
            case "getDriver": 
            case "getDrivers": 
            case "deregisterDriver": {
                return defc == DriverManager.class;
            }
            case "newUpdater": {
                if (defc == AtomicIntegerFieldUpdater.class) {
                    return true;
                }
                if (defc == AtomicLongFieldUpdater.class) {
                    return true;
                }
                if (defc != AtomicReferenceFieldUpdater.class) break;
                return true;
            }
            case "getContextClassLoader": {
                return defc == Thread.class;
            }
            case "getPackage": 
            case "getPackages": {
                return defc == Package.class;
            }
            case "getParent": 
            case "getSystemClassLoader": {
                return defc == ClassLoader.class;
            }
            case "load": 
            case "loadLibrary": {
                if (defc == Runtime.class) {
                    return true;
                }
                if (defc != System.class) break;
                return true;
            }
            case "getCallerClass": {
                if (defc == Reflection.class) {
                    return true;
                }
                if (defc != System.class) break;
                return true;
            }
            case "getCallerClassLoader": {
                return defc == ClassLoader.class;
            }
            case "registerAsParallelCapable": {
                return defc == ClassLoader.class;
            }
            case "getInvocationHandler": 
            case "getProxyClass": 
            case "newProxyInstance": {
                return defc == Proxy.class;
            }
            case "asInterfaceInstance": {
                return defc == MethodHandleProxies.class;
            }
            case "getBundle": 
            case "clearCache": {
                return defc == ResourceBundle.class;
            }
            case "getType": {
                return defc == ObjectStreamField.class;
            }
            case "forClass": {
                return defc == ObjectStreamClass.class;
            }
            case "getLogger": {
                return defc == Logger.class;
            }
            case "getAnonymousLogger": {
                return defc == Logger.class;
            }
        }
        return false;
    }

    private static boolean canBeCalledVirtual(MemberName mem) {
        assert (mem.isInvocable());
        Class<?> defc = mem.getDeclaringClass();
        switch (mem.getName()) {
            case "checkMemberAccess": {
                return MethodHandleNatives.canBeCalledVirtual(mem, SecurityManager.class);
            }
            case "getContextClassLoader": {
                return MethodHandleNatives.canBeCalledVirtual(mem, Thread.class);
            }
        }
        return false;
    }

    static boolean canBeCalledVirtual(MemberName symbolicRef, Class<?> definingClass) {
        Class<?> symbolicRefClass = symbolicRef.getDeclaringClass();
        if (symbolicRefClass == definingClass) {
            return true;
        }
        if (symbolicRef.isStatic() || symbolicRef.isPrivate()) {
            return false;
        }
        return definingClass.isAssignableFrom(symbolicRefClass) || symbolicRefClass.isInterface();
    }

    static {
        MethodHandleNatives.registerNatives();
        COUNT_GWT = MethodHandleNatives.getConstant(4) != 0;
        MethodHandleImpl.initStatics();
        int HR_MASK = 682;
        for (byte refKind = 1; refKind < 10; refKind = (byte)(refKind + 1)) {
            assert (MethodHandleNatives.refKindHasReceiver(refKind) == ((1 << refKind & 0x2AA) != 0)) : refKind;
        }
        REFERENCE_KIND_NAME = new String[]{null, "getField", "getStatic", "putField", "putStatic", "invokeVirtual", "invokeStatic", "invokeSpecial", "newInvokeSpecial", "invokeInterface"};
        assert (MethodHandleNatives.verifyConstants());
    }

    static class Constants {
        static final int GC_COUNT_GWT = 4;
        static final int GC_LAMBDA_SUPPORT = 5;
        static final int MN_IS_METHOD = 65536;
        static final int MN_IS_CONSTRUCTOR = 131072;
        static final int MN_IS_FIELD = 262144;
        static final int MN_IS_TYPE = 524288;
        static final int MN_CALLER_SENSITIVE = 0x100000;
        static final int MN_REFERENCE_KIND_SHIFT = 24;
        static final int MN_REFERENCE_KIND_MASK = 15;
        static final int MN_SEARCH_SUPERCLASSES = 0x100000;
        static final int MN_SEARCH_INTERFACES = 0x200000;
        static final int T_BOOLEAN = 4;
        static final int T_CHAR = 5;
        static final int T_FLOAT = 6;
        static final int T_DOUBLE = 7;
        static final int T_BYTE = 8;
        static final int T_SHORT = 9;
        static final int T_INT = 10;
        static final int T_LONG = 11;
        static final int T_OBJECT = 12;
        static final int T_VOID = 14;
        static final int T_ILLEGAL = 99;
        static final byte CONSTANT_Utf8 = 1;
        static final byte CONSTANT_Integer = 3;
        static final byte CONSTANT_Float = 4;
        static final byte CONSTANT_Long = 5;
        static final byte CONSTANT_Double = 6;
        static final byte CONSTANT_Class = 7;
        static final byte CONSTANT_String = 8;
        static final byte CONSTANT_Fieldref = 9;
        static final byte CONSTANT_Methodref = 10;
        static final byte CONSTANT_InterfaceMethodref = 11;
        static final byte CONSTANT_NameAndType = 12;
        static final byte CONSTANT_MethodHandle = 15;
        static final byte CONSTANT_MethodType = 16;
        static final byte CONSTANT_InvokeDynamic = 18;
        static final byte CONSTANT_LIMIT = 19;
        static final char ACC_PUBLIC = '\u0001';
        static final char ACC_PRIVATE = '\u0002';
        static final char ACC_PROTECTED = '\u0004';
        static final char ACC_STATIC = '\b';
        static final char ACC_FINAL = '\u0010';
        static final char ACC_SYNCHRONIZED = ' ';
        static final char ACC_VOLATILE = '@';
        static final char ACC_TRANSIENT = '\u0080';
        static final char ACC_NATIVE = '\u0100';
        static final char ACC_INTERFACE = '\u0200';
        static final char ACC_ABSTRACT = '\u0400';
        static final char ACC_STRICT = '\u0800';
        static final char ACC_SYNTHETIC = '\u1000';
        static final char ACC_ANNOTATION = '\u2000';
        static final char ACC_ENUM = '\u4000';
        static final char ACC_SUPER = ' ';
        static final char ACC_BRIDGE = '@';
        static final char ACC_VARARGS = '\u0080';
        static final byte REF_NONE = 0;
        static final byte REF_getField = 1;
        static final byte REF_getStatic = 2;
        static final byte REF_putField = 3;
        static final byte REF_putStatic = 4;
        static final byte REF_invokeVirtual = 5;
        static final byte REF_invokeStatic = 6;
        static final byte REF_invokeSpecial = 7;
        static final byte REF_newInvokeSpecial = 8;
        static final byte REF_invokeInterface = 9;
        static final byte REF_LIMIT = 10;

        Constants() {
        }
    }
}

