/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils;

import com.sun.org.apache.xml.internal.security.transforms.implementations.FuncHere;
import com.sun.org.apache.xml.internal.security.utils.XPathAPI;
import com.sun.org.apache.xml.internal.utils.PrefixResolver;
import com.sun.org.apache.xml.internal.utils.PrefixResolverDefault;
import com.sun.org.apache.xpath.internal.Expression;
import com.sun.org.apache.xpath.internal.XPath;
import com.sun.org.apache.xpath.internal.XPathContext;
import com.sun.org.apache.xpath.internal.compiler.FunctionTable;
import com.sun.org.apache.xpath.internal.objects.XObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XalanXPathAPI
implements XPathAPI {
    private static Logger log = Logger.getLogger(XalanXPathAPI.class.getName());
    private String xpathStr = null;
    private XPath xpath = null;
    private static FunctionTable funcTable = null;
    private static boolean installed;
    private XPathContext context;

    @Override
    public NodeList selectNodeList(Node contextNode, Node xpathnode, String str, Node namespaceNode) throws TransformerException {
        XObject list = this.eval(contextNode, xpathnode, str, namespaceNode);
        return list.nodelist();
    }

    @Override
    public boolean evaluate(Node contextNode, Node xpathnode, String str, Node namespaceNode) throws TransformerException {
        XObject object = this.eval(contextNode, xpathnode, str, namespaceNode);
        return object.bool();
    }

    @Override
    public void clear() {
        this.xpathStr = null;
        this.xpath = null;
        this.context = null;
    }

    public static synchronized boolean isInstalled() {
        return installed;
    }

    private XObject eval(Node contextNode, Node xpathnode, String str, Node namespaceNode) throws TransformerException {
        if (this.context == null) {
            this.context = new XPathContext(xpathnode);
            this.context.setSecureProcessing(true);
        }
        Node resolverNode = namespaceNode.getNodeType() == 9 ? ((Document)namespaceNode).getDocumentElement() : namespaceNode;
        PrefixResolverDefault prefixResolver = new PrefixResolverDefault(resolverNode);
        if (!str.equals(this.xpathStr)) {
            if (str.indexOf("here()") > 0) {
                this.context.reset();
            }
            this.xpath = this.createXPath(str, prefixResolver);
            this.xpathStr = str;
        }
        int ctxtNode = this.context.getDTMHandleFromNode(contextNode);
        return this.xpath.execute(this.context, ctxtNode, (PrefixResolver)prefixResolver);
    }

    private XPath createXPath(String str, PrefixResolver prefixResolver) throws TransformerException {
        XPath xpath;
        block3: {
            xpath = null;
            Class[] classes = new Class[]{String.class, SourceLocator.class, PrefixResolver.class, Integer.TYPE, ErrorListener.class, FunctionTable.class};
            Object[] objects = new Object[]{str, null, prefixResolver, 0, null, funcTable};
            try {
                Constructor constructor = XPath.class.getConstructor(classes);
                xpath = (XPath)constructor.newInstance(objects);
            }
            catch (Exception ex) {
                if (!log.isLoggable(Level.FINE)) break block3;
                log.log(Level.FINE, ex.getMessage(), ex);
            }
        }
        if (xpath == null) {
            xpath = new XPath(str, null, prefixResolver, 0, null);
        }
        return xpath;
    }

    private static synchronized void fixupFunctionTable() {
        Object[] params;
        Method installFunction;
        Class[] args;
        installed = false;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Registering Here function");
        }
        try {
            args = new Class[]{String.class, Expression.class};
            installFunction = FunctionTable.class.getMethod("installFunction", args);
            if ((installFunction.getModifiers() & 8) != 0) {
                params = new Object[]{"here", new FuncHere()};
                installFunction.invoke(null, params);
                installed = true;
            }
        }
        catch (Exception ex) {
            log.log(Level.FINE, "Error installing function using the static installFunction method", ex);
        }
        if (!installed) {
            try {
                funcTable = new FunctionTable();
                args = new Class[]{String.class, Class.class};
                installFunction = FunctionTable.class.getMethod("installFunction", args);
                params = new Object[]{"here", FuncHere.class};
                installFunction.invoke(funcTable, params);
                installed = true;
            }
            catch (Exception ex) {
                log.log(Level.FINE, "Error installing function using the static installFunction method", ex);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            if (installed) {
                log.log(Level.FINE, "Registered class " + FuncHere.class.getName() + " for XPath function 'here()' function in internal table");
            } else {
                log.log(Level.FINE, "Unable to register class " + FuncHere.class.getName() + " for XPath function 'here()' function in internal table");
            }
        }
    }

    static {
        XalanXPathAPI.fixupFunctionTable();
    }
}

