/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.AtomicBooleanDeserializer;
import com.fasterxml.jackson.databind.deser.std.ByteBufferDeserializer;
import com.fasterxml.jackson.databind.deser.std.CharsetDeserializer;
import com.fasterxml.jackson.databind.deser.std.ClassDeserializer;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.deser.std.InetAddressDeserializer;
import com.fasterxml.jackson.databind.deser.std.InetSocketAddressDeserializer;
import com.fasterxml.jackson.databind.deser.std.StackTraceElementDeserializer;
import com.fasterxml.jackson.databind.deser.std.UUIDDeserializer;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Currency;
import java.util.HashSet;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;

public class JdkDeserializers {
    private static final HashSet<String> _classNames;

    public static JsonDeserializer<?> find(Class<?> rawType, String clsName) {
        if (!_classNames.contains(clsName)) {
            return null;
        }
        if (rawType == URI.class) {
            return URIDeserializer.instance;
        }
        if (rawType == URL.class) {
            return URLDeserializer.instance;
        }
        if (rawType == File.class) {
            return FileDeserializer.instance;
        }
        if (rawType == UUID.class) {
            return UUIDDeserializer.instance;
        }
        if (rawType == Currency.class) {
            return CurrencyDeserializer.instance;
        }
        if (rawType == Pattern.class) {
            return PatternDeserializer.instance;
        }
        if (rawType == Locale.class) {
            return LocaleDeserializer.instance;
        }
        if (rawType == InetAddress.class) {
            return InetAddressDeserializer.instance;
        }
        if (rawType == InetSocketAddress.class) {
            return InetSocketAddressDeserializer.instance;
        }
        if (rawType == Charset.class) {
            return new CharsetDeserializer();
        }
        if (rawType == Class.class) {
            return ClassDeserializer.instance;
        }
        if (rawType == StackTraceElement.class) {
            return StackTraceElementDeserializer.instance;
        }
        if (rawType == AtomicBoolean.class) {
            return AtomicBooleanDeserializer.instance;
        }
        if (rawType == ByteBuffer.class) {
            return new ByteBufferDeserializer();
        }
        throw new IllegalArgumentException("Internal error: can't find deserializer for " + clsName);
    }

    static {
        Class[] numberTypes;
        _classNames = new HashSet();
        for (Class cls : numberTypes = new Class[]{UUID.class, URL.class, URI.class, File.class, Currency.class, Pattern.class, Locale.class, InetAddress.class, InetSocketAddress.class, Charset.class, AtomicBoolean.class, Class.class, StackTraceElement.class, ByteBuffer.class}) {
            _classNames.add(cls.getName());
        }
    }

    public static class FileDeserializer
    extends FromStringDeserializer<File> {
        public static final FileDeserializer instance = new FileDeserializer();

        public FileDeserializer() {
            super(File.class);
        }

        @Override
        protected File _deserialize(String value, DeserializationContext ctxt) {
            return new File(value);
        }
    }

    protected static class LocaleDeserializer
    extends FromStringDeserializer<Locale> {
        public static final LocaleDeserializer instance = new LocaleDeserializer();

        public LocaleDeserializer() {
            super(Locale.class);
        }

        @Override
        protected Locale _deserialize(String value, DeserializationContext ctxt) throws IOException {
            int ix = value.indexOf(95);
            if (ix < 0) {
                return new Locale(value);
            }
            String first = value.substring(0, ix);
            if ((ix = (value = value.substring(ix + 1)).indexOf(95)) < 0) {
                return new Locale(first, value);
            }
            String second = value.substring(0, ix);
            return new Locale(first, second, value.substring(ix + 1));
        }
    }

    public static class PatternDeserializer
    extends FromStringDeserializer<Pattern> {
        public static final PatternDeserializer instance = new PatternDeserializer();

        public PatternDeserializer() {
            super(Pattern.class);
        }

        @Override
        protected Pattern _deserialize(String value, DeserializationContext ctxt) throws IllegalArgumentException {
            return Pattern.compile(value);
        }
    }

    public static class CurrencyDeserializer
    extends FromStringDeserializer<Currency> {
        public static final CurrencyDeserializer instance = new CurrencyDeserializer();

        public CurrencyDeserializer() {
            super(Currency.class);
        }

        @Override
        protected Currency _deserialize(String value, DeserializationContext ctxt) throws IllegalArgumentException {
            return Currency.getInstance(value);
        }
    }

    public static class URIDeserializer
    extends FromStringDeserializer<URI> {
        public static final URIDeserializer instance = new URIDeserializer();

        public URIDeserializer() {
            super(URI.class);
        }

        @Override
        protected URI _deserialize(String value, DeserializationContext ctxt) throws IllegalArgumentException {
            return URI.create(value);
        }

        @Override
        protected URI _deserializeFromEmptyString() {
            return URI.create("");
        }
    }

    public static class URLDeserializer
    extends FromStringDeserializer<URL> {
        public static final URLDeserializer instance = new URLDeserializer();

        public URLDeserializer() {
            super(URL.class);
        }

        @Override
        protected URL _deserialize(String value, DeserializationContext ctxt) throws IOException {
            return new URL(value);
        }
    }
}

