/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;
import sun.misc.Unsafe;

public class AtomicInteger
extends Number
implements Serializable {
    private static final long serialVersionUID = 6214790243416807050L;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long valueOffset;
    private volatile int value;

    public AtomicInteger(int initialValue) {
        this.value = initialValue;
    }

    public AtomicInteger() {
    }

    public final int get() {
        return this.value;
    }

    public final void set(int newValue) {
        this.value = newValue;
    }

    public final void lazySet(int newValue) {
        unsafe.putOrderedInt(this, valueOffset, newValue);
    }

    public final int getAndSet(int newValue) {
        int current;
        while (!this.compareAndSet(current = this.get(), newValue)) {
        }
        return current;
    }

    public final boolean compareAndSet(int expect, int update) {
        return unsafe.compareAndSwapInt(this, valueOffset, expect, update);
    }

    public final boolean weakCompareAndSet(int expect, int update) {
        return unsafe.compareAndSwapInt(this, valueOffset, expect, update);
    }

    public final int getAndIncrement() {
        int next;
        int current;
        while (!this.compareAndSet(current = this.get(), next = current + 1)) {
        }
        return current;
    }

    public final int getAndDecrement() {
        int next;
        int current;
        while (!this.compareAndSet(current = this.get(), next = current - 1)) {
        }
        return current;
    }

    public final int getAndAdd(int delta) {
        int next;
        int current;
        while (!this.compareAndSet(current = this.get(), next = current + delta)) {
        }
        return current;
    }

    public final int incrementAndGet() {
        int next;
        int current;
        while (!this.compareAndSet(current = this.get(), next = current + 1)) {
        }
        return next;
    }

    public final int decrementAndGet() {
        int next;
        int current;
        while (!this.compareAndSet(current = this.get(), next = current - 1)) {
        }
        return next;
    }

    public final int addAndGet(int delta) {
        int next;
        int current;
        while (!this.compareAndSet(current = this.get(), next = current + delta)) {
        }
        return next;
    }

    public String toString() {
        return Integer.toString(this.get());
    }

    @Override
    public int intValue() {
        return this.get();
    }

    @Override
    public long longValue() {
        return this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    static {
        try {
            valueOffset = unsafe.objectFieldOffset(AtomicInteger.class.getDeclaredField("value"));
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }
}

