/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.TimeZone;
import sun.misc.JavaNetHttpCookieAccess;
import sun.misc.SharedSecrets;

public final class HttpCookie
implements Cloneable {
    private String name;
    private String value;
    private String comment;
    private String commentURL;
    private boolean toDiscard;
    private String domain;
    private long maxAge = -1L;
    private String path;
    private String portlist;
    private boolean secure;
    private boolean httpOnly;
    private int version = 1;
    private final String header;
    private long whenCreated = 0L;
    private static final long MAX_AGE_UNSPECIFIED = -1L;
    private static final String[] COOKIE_DATE_FORMATS = new String[]{"EEE',' dd-MMM-yyyy HH:mm:ss 'GMT'", "EEE',' dd MMM yyyy HH:mm:ss 'GMT'", "EEE MMM dd yyyy HH:mm:ss 'GMT'Z", "EEE',' dd-MMM-yy HH:mm:ss 'GMT'", "EEE',' dd MMM yy HH:mm:ss 'GMT'", "EEE MMM dd yy HH:mm:ss 'GMT'Z"};
    private static final String SET_COOKIE = "set-cookie:";
    private static final String SET_COOKIE2 = "set-cookie2:";
    private static final String tspecials = ",;";
    static Map<String, CookieAttributeAssignor> assignors = null;
    static final TimeZone GMT;

    public HttpCookie(String name, String value) {
        this(name, value, null);
    }

    private HttpCookie(String name, String value, String header) {
        name = name.trim();
        if (name.length() == 0 || !HttpCookie.isToken(name) || name.charAt(0) == '$') {
            throw new IllegalArgumentException("Illegal cookie name");
        }
        this.name = name;
        this.value = value;
        this.toDiscard = false;
        this.secure = false;
        this.whenCreated = System.currentTimeMillis();
        this.portlist = null;
        this.header = header;
    }

    public static List<HttpCookie> parse(String header) {
        return HttpCookie.parse(header, false);
    }

    private static List<HttpCookie> parse(String header, boolean retainHeader) {
        int version = HttpCookie.guessCookieVersion(header);
        if (HttpCookie.startsWithIgnoreCase(header, SET_COOKIE2)) {
            header = header.substring(SET_COOKIE2.length());
        } else if (HttpCookie.startsWithIgnoreCase(header, SET_COOKIE)) {
            header = header.substring(SET_COOKIE.length());
        }
        ArrayList<HttpCookie> cookies = new ArrayList<HttpCookie>();
        if (version == 0) {
            HttpCookie cookie = HttpCookie.parseInternal(header, retainHeader);
            cookie.setVersion(0);
            cookies.add(cookie);
        } else {
            List<String> cookieStrings = HttpCookie.splitMultiCookies(header);
            for (String cookieStr : cookieStrings) {
                HttpCookie cookie = HttpCookie.parseInternal(cookieStr, retainHeader);
                cookie.setVersion(1);
                cookies.add(cookie);
            }
        }
        return cookies;
    }

    public boolean hasExpired() {
        if (this.maxAge == 0L) {
            return true;
        }
        if (this.maxAge == -1L) {
            return false;
        }
        long deltaSecond = (System.currentTimeMillis() - this.whenCreated) / 1000L;
        return deltaSecond > this.maxAge;
    }

    public void setComment(String purpose) {
        this.comment = purpose;
    }

    public String getComment() {
        return this.comment;
    }

    public void setCommentURL(String purpose) {
        this.commentURL = purpose;
    }

    public String getCommentURL() {
        return this.commentURL;
    }

    public void setDiscard(boolean discard) {
        this.toDiscard = discard;
    }

    public boolean getDiscard() {
        return this.toDiscard;
    }

    public void setPortlist(String ports) {
        this.portlist = ports;
    }

    public String getPortlist() {
        return this.portlist;
    }

    public void setDomain(String pattern) {
        this.domain = pattern != null ? pattern.toLowerCase() : pattern;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setMaxAge(long expiry) {
        this.maxAge = expiry;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public void setPath(String uri) {
        this.path = uri;
    }

    public String getPath() {
        return this.path;
    }

    public void setSecure(boolean flag) {
        this.secure = flag;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String newValue) {
        this.value = newValue;
    }

    public String getValue() {
        return this.value;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int v) {
        if (v != 0 && v != 1) {
            throw new IllegalArgumentException("cookie version should be 0 or 1");
        }
        this.version = v;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public static boolean domainMatches(String domain, String host) {
        if (domain == null || host == null) {
            return false;
        }
        boolean isLocalDomain = ".local".equalsIgnoreCase(domain);
        int embeddedDotInDomain = domain.indexOf(46);
        if (embeddedDotInDomain == 0) {
            embeddedDotInDomain = domain.indexOf(46, 1);
        }
        if (!(isLocalDomain || embeddedDotInDomain != -1 && embeddedDotInDomain != domain.length() - 1)) {
            return false;
        }
        int firstDotInHost = host.indexOf(46);
        if (firstDotInHost == -1 && isLocalDomain) {
            return true;
        }
        int domainLength = domain.length();
        int lengthDiff = host.length() - domainLength;
        if (lengthDiff == 0) {
            return host.equalsIgnoreCase(domain);
        }
        if (lengthDiff > 0) {
            String H = host.substring(0, lengthDiff);
            String D = host.substring(lengthDiff);
            return H.indexOf(46) == -1 && D.equalsIgnoreCase(domain);
        }
        if (lengthDiff == -1) {
            return domain.charAt(0) == '.' && host.equalsIgnoreCase(domain.substring(1));
        }
        return false;
    }

    public String toString() {
        if (this.getVersion() > 0) {
            return this.toRFC2965HeaderString();
        }
        return this.toNetscapeHeaderString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HttpCookie)) {
            return false;
        }
        HttpCookie other = (HttpCookie)obj;
        return HttpCookie.equalsIgnoreCase(this.getName(), other.getName()) && HttpCookie.equalsIgnoreCase(this.getDomain(), other.getDomain()) && Objects.equals(this.getPath(), other.getPath());
    }

    public int hashCode() {
        int h1 = this.name.toLowerCase().hashCode();
        int h2 = this.domain != null ? this.domain.toLowerCase().hashCode() : 0;
        int h3 = this.path != null ? this.path.hashCode() : 0;
        return h1 + h2 + h3;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private static boolean isToken(String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '\u007f' && tspecials.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    private static HttpCookie parseInternal(String header, boolean retainHeader) {
        String value;
        String name;
        int index;
        StringTokenizer tokenizer;
        String namevaluePair;
        HttpCookie cookie;
        block6: {
            cookie = null;
            namevaluePair = null;
            tokenizer = new StringTokenizer(header, ";");
            try {
                namevaluePair = tokenizer.nextToken();
                index = namevaluePair.indexOf(61);
                if (index != -1) {
                    name = namevaluePair.substring(0, index).trim();
                    value = namevaluePair.substring(index + 1).trim();
                    cookie = retainHeader ? new HttpCookie(name, HttpCookie.stripOffSurroundingQuote(value), header) : new HttpCookie(name, HttpCookie.stripOffSurroundingQuote(value));
                    break block6;
                }
                throw new IllegalArgumentException("Invalid cookie name-value pair");
            }
            catch (NoSuchElementException ignored) {
                throw new IllegalArgumentException("Empty cookie header string");
            }
        }
        while (tokenizer.hasMoreTokens()) {
            namevaluePair = tokenizer.nextToken();
            index = namevaluePair.indexOf(61);
            if (index != -1) {
                name = namevaluePair.substring(0, index).trim();
                value = namevaluePair.substring(index + 1).trim();
            } else {
                name = namevaluePair.trim();
                value = null;
            }
            HttpCookie.assignAttribute(cookie, name, value);
        }
        return cookie;
    }

    private static void assignAttribute(HttpCookie cookie, String attrName, String attrValue) {
        attrValue = HttpCookie.stripOffSurroundingQuote(attrValue);
        CookieAttributeAssignor assignor = assignors.get(attrName.toLowerCase());
        if (assignor != null) {
            assignor.assign(cookie, attrName, attrValue);
        }
    }

    private String header() {
        return this.header;
    }

    private String toNetscapeHeaderString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName() + "=" + this.getValue());
        return sb.toString();
    }

    private String toRFC2965HeaderString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("=\"").append(this.getValue()).append('\"');
        if (this.getPath() != null) {
            sb.append(";$Path=\"").append(this.getPath()).append('\"');
        }
        if (this.getDomain() != null) {
            sb.append(";$Domain=\"").append(this.getDomain()).append('\"');
        }
        if (this.getPortlist() != null) {
            sb.append(";$Port=\"").append(this.getPortlist()).append('\"');
        }
        return sb.toString();
    }

    private long expiryDate2DeltaSeconds(String dateString) {
        GregorianCalendar cal = new GregorianCalendar(GMT);
        for (int i = 0; i < COOKIE_DATE_FORMATS.length; ++i) {
            SimpleDateFormat df = new SimpleDateFormat(COOKIE_DATE_FORMATS[i], Locale.US);
            cal.set(1970, 0, 1, 0, 0, 0);
            df.setTimeZone(GMT);
            df.setLenient(false);
            df.set2DigitYearStart(cal.getTime());
            try {
                cal.setTime(df.parse(dateString));
                if (!COOKIE_DATE_FORMATS[i].contains("yyyy")) {
                    int year = cal.get(1);
                    year = (year %= 100) < 70 ? (year += 2000) : (year += 1900);
                    cal.set(1, year);
                }
                return (cal.getTimeInMillis() - this.whenCreated) / 1000L;
            }
            catch (Exception exception) {
                continue;
            }
        }
        return 0L;
    }

    private static int guessCookieVersion(String header) {
        int version = 0;
        if ((header = header.toLowerCase()).indexOf("expires=") != -1) {
            version = 0;
        } else if (header.indexOf("version=") != -1) {
            version = 1;
        } else if (header.indexOf("max-age") != -1) {
            version = 1;
        } else if (HttpCookie.startsWithIgnoreCase(header, SET_COOKIE2)) {
            version = 1;
        }
        return version;
    }

    private static String stripOffSurroundingQuote(String str) {
        if (str != null && str.length() > 2 && str.charAt(0) == '\"' && str.charAt(str.length() - 1) == '\"') {
            return str.substring(1, str.length() - 1);
        }
        if (str != null && str.length() > 2 && str.charAt(0) == '\'' && str.charAt(str.length() - 1) == '\'') {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    private static boolean equalsIgnoreCase(String s, String t) {
        if (s == t) {
            return true;
        }
        if (s != null && t != null) {
            return s.equalsIgnoreCase(t);
        }
        return false;
    }

    private static boolean startsWithIgnoreCase(String s, String start) {
        if (s == null || start == null) {
            return false;
        }
        return s.length() >= start.length() && start.equalsIgnoreCase(s.substring(0, start.length()));
    }

    private static List<String> splitMultiCookies(String header) {
        ArrayList<String> cookies = new ArrayList<String>();
        int quoteCount = 0;
        int q = 0;
        for (int p = 0; p < header.length(); ++p) {
            char c = header.charAt(p);
            if (c == '\"') {
                ++quoteCount;
            }
            if (c != ',' || quoteCount % 2 != 0) continue;
            cookies.add(header.substring(q, p));
            q = p + 1;
        }
        cookies.add(header.substring(q));
        return cookies;
    }

    static {
        assignors = new HashMap<String, CookieAttributeAssignor>();
        assignors.put("comment", new CookieAttributeAssignor(){

            @Override
            public void assign(HttpCookie cookie, String attrName, String attrValue) {
                if (cookie.getComment() == null) {
                    cookie.setComment(attrValue);
                }
            }
        });
        assignors.put("commenturl", new CookieAttributeAssignor(){

            @Override
            public void assign(HttpCookie cookie, String attrName, String attrValue) {
                if (cookie.getCommentURL() == null) {
                    cookie.setCommentURL(attrValue);
                }
            }
        });
        assignors.put("discard", new CookieAttributeAssignor(){

            @Override
            public void assign(HttpCookie cookie, String attrName, String attrValue) {
                cookie.setDiscard(true);
            }
        });
        assignors.put("domain", new CookieAttributeAssignor(){

            @Override
            public void assign(HttpCookie cookie, String attrName, String attrValue) {
                if (cookie.getDomain() == null) {
                    cookie.setDomain(attrValue);
                }
            }
        });
        assignors.put("max-age", new CookieAttributeAssignor(){

            @Override
            public void assign(HttpCookie cookie, String attrName, String attrValue) {
                try {
                    long maxage = Long.parseLong(attrValue);
                    if (cookie.getMaxAge() == -1L) {
                        cookie.setMaxAge(maxage);
                    }
                }
                catch (NumberFormatException ignored) {
                    throw new IllegalArgumentException("Illegal cookie max-age attribute");
                }
            }
        });
        assignors.put("path", new CookieAttributeAssignor(){

            @Override
            public void assign(HttpCookie cookie, String attrName, String attrValue) {
                if (cookie.getPath() == null) {
                    cookie.setPath(attrValue);
                }
            }
        });
        assignors.put("port", new CookieAttributeAssignor(){

            @Override
            public void assign(HttpCookie cookie, String attrName, String attrValue) {
                if (cookie.getPortlist() == null) {
                    cookie.setPortlist(attrValue == null ? "" : attrValue);
                }
            }
        });
        assignors.put("secure", new CookieAttributeAssignor(){

            @Override
            public void assign(HttpCookie cookie, String attrName, String attrValue) {
                cookie.setSecure(true);
            }
        });
        assignors.put("httponly", new CookieAttributeAssignor(){

            @Override
            public void assign(HttpCookie cookie, String attrName, String attrValue) {
                cookie.setHttpOnly(true);
            }
        });
        assignors.put("version", new CookieAttributeAssignor(){

            @Override
            public void assign(HttpCookie cookie, String attrName, String attrValue) {
                try {
                    int version = Integer.parseInt(attrValue);
                    cookie.setVersion(version);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        assignors.put("expires", new CookieAttributeAssignor(){

            @Override
            public void assign(HttpCookie cookie, String attrName, String attrValue) {
                if (cookie.getMaxAge() == -1L) {
                    cookie.setMaxAge(cookie.expiryDate2DeltaSeconds(attrValue));
                }
            }
        });
        SharedSecrets.setJavaNetHttpCookieAccess(new JavaNetHttpCookieAccess(){

            @Override
            public List<HttpCookie> parse(String header) {
                return HttpCookie.parse(header, true);
            }

            @Override
            public String header(HttpCookie cookie) {
                return cookie.header;
            }
        });
        GMT = TimeZone.getTimeZone("GMT");
    }

    static interface CookieAttributeAssignor {
        public void assign(HttpCookie var1, String var2, String var3);
    }
}

