/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.StubNotFoundException;
import java.rmi.UnknownHostException;
import java.rmi.UnmarshalException;
import java.rmi.activation.ActivateFailedException;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationID;
import java.rmi.activation.UnknownObjectException;
import java.rmi.server.Operation;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteObjectInvocationHandler;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteStub;
import sun.rmi.server.Util;

public class ActivatableRef
implements RemoteRef {
    private static final long serialVersionUID = 7579060052569229166L;
    protected ActivationID id;
    protected RemoteRef ref;
    transient boolean force = false;
    private static final int MAX_RETRIES = 3;
    private static final String versionComplaint = "activation requires 1.2 stubs";

    public ActivatableRef() {
    }

    public ActivatableRef(ActivationID id, RemoteRef ref) {
        this.id = id;
        this.ref = ref;
    }

    public static Remote getStub(ActivationDesc desc, ActivationID id) throws StubNotFoundException {
        String className = desc.getClassName();
        try {
            Class<?> cl = RMIClassLoader.loadClass(desc.getLocation(), className);
            ActivatableRef clientRef = new ActivatableRef(id, null);
            return Util.createProxy(cl, clientRef, false);
        }
        catch (IllegalArgumentException e) {
            throw new StubNotFoundException("class implements an illegal remote interface", e);
        }
        catch (ClassNotFoundException e) {
            throw new StubNotFoundException("unable to load class: " + className, e);
        }
        catch (MalformedURLException e) {
            throw new StubNotFoundException("malformed URL", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Remote obj, Method method, Object[] params, long opnum) throws Exception {
        RemoteRef localRef;
        boolean force = false;
        RemoteException exception = null;
        ActivatableRef activatableRef = this;
        synchronized (activatableRef) {
            if (this.ref == null) {
                localRef = this.activate(force);
                force = true;
            } else {
                localRef = this.ref;
            }
        }
        for (int retries = 3; retries > 0; --retries) {
            try {
                return localRef.invoke(obj, method, params, opnum);
            }
            catch (NoSuchObjectException e) {
                exception = e;
            }
            catch (ConnectException e) {
                exception = e;
            }
            catch (UnknownHostException e) {
                exception = e;
            }
            catch (ConnectIOException e) {
                exception = e;
            }
            catch (MarshalException e) {
                throw e;
            }
            catch (ServerError e) {
                throw e;
            }
            catch (ServerException e) {
                throw e;
            }
            catch (RemoteException e) {
                ActivatableRef activatableRef2 = this;
                synchronized (activatableRef2) {
                    if (localRef == this.ref) {
                        this.ref = null;
                    }
                }
                throw e;
            }
            if (retries <= 1) continue;
            ActivatableRef activatableRef3 = this;
            synchronized (activatableRef3) {
                if (localRef.remoteEquals(this.ref) || this.ref == null) {
                    RemoteRef newRef = this.activate(force);
                    if (newRef.remoteEquals(localRef) && exception instanceof NoSuchObjectException && !force) {
                        newRef = this.activate(true);
                    }
                    localRef = newRef;
                    force = true;
                } else {
                    localRef = this.ref;
                    force = false;
                }
                continue;
            }
        }
        throw exception;
    }

    private synchronized RemoteRef getRef() throws RemoteException {
        if (this.ref == null) {
            this.ref = this.activate(false);
        }
        return this.ref;
    }

    private RemoteRef activate(boolean force) throws RemoteException {
        assert (Thread.holdsLock(this));
        this.ref = null;
        try {
            Remote proxy = this.id.activate(force);
            ActivatableRef newRef = null;
            if (proxy instanceof RemoteStub) {
                newRef = (ActivatableRef)((RemoteStub)proxy).getRef();
            } else {
                RemoteObjectInvocationHandler handler = (RemoteObjectInvocationHandler)Proxy.getInvocationHandler(proxy);
                newRef = (ActivatableRef)handler.getRef();
            }
            this.ref = newRef.ref;
            return this.ref;
        }
        catch (ConnectException e) {
            throw new ConnectException("activation failed", e);
        }
        catch (RemoteException e) {
            throw new ConnectIOException("activation failed", e);
        }
        catch (UnknownObjectException e) {
            throw new NoSuchObjectException("object not registered");
        }
        catch (ActivationException e) {
            throw new ActivateFailedException("activation failed", e);
        }
    }

    @Override
    public synchronized RemoteCall newCall(RemoteObject obj, Operation[] ops, int opnum, long hash) throws RemoteException {
        throw new UnsupportedOperationException(versionComplaint);
    }

    @Override
    public void invoke(RemoteCall call) throws Exception {
        throw new UnsupportedOperationException(versionComplaint);
    }

    @Override
    public void done(RemoteCall call) throws RemoteException {
        throw new UnsupportedOperationException(versionComplaint);
    }

    @Override
    public String getRefClass(ObjectOutput out) {
        return "ActivatableRef";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        RemoteRef localRef = this.ref;
        out.writeObject(this.id);
        if (localRef == null) {
            out.writeUTF("");
        } else {
            out.writeUTF(localRef.getRefClass(out));
            localRef.writeExternal(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = (ActivationID)in.readObject();
        this.ref = null;
        String className = in.readUTF();
        if (className.equals("")) {
            return;
        }
        try {
            Class<?> refClass = Class.forName("sun.rmi.server." + className);
            this.ref = (RemoteRef)refClass.newInstance();
            this.ref.readExternal(in);
        }
        catch (InstantiationException e) {
            throw new UnmarshalException("Unable to create remote reference", e);
        }
        catch (IllegalAccessException e) {
            throw new UnmarshalException("Illegal access creating remote reference");
        }
    }

    @Override
    public String remoteToString() {
        return Util.getUnqualifiedName(this.getClass()) + " [remoteRef: " + this.ref + "]";
    }

    @Override
    public int remoteHashCode() {
        return this.id.hashCode();
    }

    @Override
    public boolean remoteEquals(RemoteRef ref) {
        if (ref instanceof ActivatableRef) {
            return this.id.equals(((ActivatableRef)ref).id);
        }
        return false;
    }
}

