/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.url;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;

public final class UrlUtil {
    private UrlUtil() {
    }

    public static final String decode(String s) throws MalformedURLException {
        try {
            return UrlUtil.decode(s, "8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw new MalformedURLException("ISO-Latin-1 decoder unavailable");
        }
    }

    public static final String decode(String s, String enc) throws MalformedURLException, UnsupportedEncodingException {
        try {
            return URLDecoder.decode(s, enc);
        }
        catch (IllegalArgumentException iae) {
            MalformedURLException mue = new MalformedURLException("Invalid URI encoding: " + s);
            mue.initCause(iae);
            throw mue;
        }
    }

    public static final String encode(String s, String enc) throws UnsupportedEncodingException {
        byte[] bytes = s.getBytes(enc);
        int count = bytes.length;
        String allowed = "=,+;.'-@&/$_()!~*:";
        char[] buf = new char[3 * count];
        int j = 0;
        for (int i = 0; i < count; ++i) {
            if (bytes[i] >= 97 && bytes[i] <= 122 || bytes[i] >= 65 && bytes[i] <= 90 || bytes[i] >= 48 && bytes[i] <= 57 || "=,+;.'-@&/$_()!~*:".indexOf(bytes[i]) >= 0) {
                buf[j++] = (char)bytes[i];
                continue;
            }
            buf[j++] = 37;
            buf[j++] = Character.forDigit(0xF & bytes[i] >>> 4, 16);
            buf[j++] = Character.forDigit(0xF & bytes[i], 16);
        }
        return new String(buf, 0, j);
    }
}

