/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.spnego;

import java.io.IOException;
import org.ietf.jgss.GSSException;
import sun.security.jgss.GSSToken;
import sun.security.jgss.spnego.SpNegoContext;
import sun.security.jgss.spnego.SpNegoMechFactory;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

abstract class SpNegoToken
extends GSSToken {
    static final int NEG_TOKEN_INIT_ID = 0;
    static final int NEG_TOKEN_TARG_ID = 1;
    private int tokenType;
    static final boolean DEBUG = SpNegoContext.DEBUG;
    public static ObjectIdentifier OID;

    protected SpNegoToken(int tokenType) {
        this.tokenType = tokenType;
    }

    abstract byte[] encode() throws GSSException;

    byte[] getEncoded() throws IOException, GSSException {
        DerOutputStream token = new DerOutputStream();
        token.write(this.encode());
        switch (this.tokenType) {
            case 0: {
                DerOutputStream initToken = new DerOutputStream();
                initToken.write(DerValue.createTag((byte)-128, true, (byte)0), token);
                return initToken.toByteArray();
            }
            case 1: {
                DerOutputStream targToken = new DerOutputStream();
                targToken.write(DerValue.createTag((byte)-128, true, (byte)1), token);
                return targToken.toByteArray();
            }
        }
        return token.toByteArray();
    }

    final int getType() {
        return this.tokenType;
    }

    static String getTokenName(int type) {
        switch (type) {
            case 0: {
                return "SPNEGO NegTokenInit";
            }
            case 1: {
                return "SPNEGO NegTokenTarg";
            }
        }
        return "SPNEGO Mechanism Token";
    }

    static NegoResult getNegoResultType(int result) {
        switch (result) {
            case 0: {
                return NegoResult.ACCEPT_COMPLETE;
            }
            case 1: {
                return NegoResult.ACCEPT_INCOMPLETE;
            }
            case 2: {
                return NegoResult.REJECT;
            }
        }
        return NegoResult.ACCEPT_COMPLETE;
    }

    static String getNegoResultString(int result) {
        switch (result) {
            case 0: {
                return "Accept Complete";
            }
            case 1: {
                return "Accept InComplete";
            }
            case 2: {
                return "Reject";
            }
        }
        return "Unknown Negotiated Result: " + result;
    }

    static int checkNextField(int last, int current) throws GSSException {
        if (last < current) {
            return current;
        }
        throw new GSSException(10, -1, "Invalid SpNegoToken token : wrong order");
    }

    static {
        try {
            OID = new ObjectIdentifier(SpNegoMechFactory.GSS_SPNEGO_MECH_OID.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static enum NegoResult {
        ACCEPT_COMPLETE,
        ACCEPT_INCOMPLETE,
        REJECT;

    }
}

