/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.ServiceUIFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.EnumSyntax;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.ColorSupported;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.CopiesSupported;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.Finishings;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobSheets;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.NumberUp;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PDLOverrideSupported;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PagesPerMinute;
import javax.print.attribute.standard.PagesPerMinuteColor;
import javax.print.attribute.standard.PrinterInfo;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterLocation;
import javax.print.attribute.standard.PrinterMakeAndModel;
import javax.print.attribute.standard.PrinterMessageFromOperator;
import javax.print.attribute.standard.PrinterMoreInfo;
import javax.print.attribute.standard.PrinterMoreInfoManufacturer;
import javax.print.attribute.standard.PrinterName;
import javax.print.attribute.standard.PrinterState;
import javax.print.attribute.standard.PrinterStateReasons;
import javax.print.attribute.standard.PrinterURI;
import javax.print.attribute.standard.QueuedJobCount;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import javax.print.event.PrintServiceAttributeListener;
import sun.print.AttributeClass;
import sun.print.CUPSPrinter;
import sun.print.CustomMediaSizeName;
import sun.print.CustomMediaTray;
import sun.print.PSPrinterJob;
import sun.print.ServiceNotifier;
import sun.print.SunPrinterJobService;
import sun.print.UnixPrintJob;
import sun.print.UnixPrintServiceLookup;
import sun.security.action.GetPropertyAction;

public class IPPPrintService
implements PrintService,
SunPrinterJobService {
    public static final boolean debugPrint;
    private static final String debugPrefix = "IPPPrintService>> ";
    private static final String FORCE_PIPE_PROP = "sun.print.ippdebug";
    private String printer;
    private URI myURI;
    private URL myURL;
    private transient ServiceNotifier notifier = null;
    private static int MAXCOPIES;
    private static short MAX_ATTRIBUTE_LENGTH;
    private CUPSPrinter cps;
    private HttpURLConnection urlConnection = null;
    private DocFlavor[] supportedDocFlavors;
    private Class[] supportedCats;
    private MediaTray[] mediaTrays;
    private MediaSizeName[] mediaSizeNames;
    private CustomMediaSizeName[] customMediaSizeNames;
    private int defaultMediaIndex;
    private boolean isCupsPrinter;
    private boolean init;
    private Boolean isPS;
    private HashMap getAttMap;
    private boolean pngImagesAdded = false;
    private boolean gifImagesAdded = false;
    private boolean jpgImagesAdded = false;
    private static final byte STATUSCODE_SUCCESS = 0;
    private static final byte GRPTAG_OP_ATTRIBUTES = 1;
    private static final byte GRPTAG_JOB_ATTRIBUTES = 2;
    private static final byte GRPTAG_PRINTER_ATTRIBUTES = 4;
    private static final byte GRPTAG_END_ATTRIBUTES = 3;
    public static final String OP_GET_ATTRIBUTES = "000B";
    public static final String OP_CUPS_GET_DEFAULT = "4001";
    public static final String OP_CUPS_GET_PRINTERS = "4002";
    private static Object[] printReqAttribDefault;
    private static Object[][] serviceAttributes;
    private static DocFlavor[] appPDF;
    private static DocFlavor[] appPostScript;
    private static DocFlavor[] appOctetStream;
    private static DocFlavor[] textPlain;
    private static DocFlavor[] textPlainHost;
    private static DocFlavor[] imageJPG;
    private static DocFlavor[] imageGIF;
    private static DocFlavor[] imagePNG;
    private static DocFlavor[] textHtml;
    private static DocFlavor[] textHtmlHost;
    private static DocFlavor[] appPCL;
    private static Object[] allDocFlavors;

    protected static void debug_println(String str) {
        if (debugPrint) {
            System.out.println(str);
        }
    }

    IPPPrintService(String name, URL url) {
        if (name == null || url == null) {
            throw new IllegalArgumentException("null uri or printer name");
        }
        this.printer = name;
        this.supportedDocFlavors = null;
        this.supportedCats = null;
        this.mediaSizeNames = null;
        this.customMediaSizeNames = null;
        this.mediaTrays = null;
        this.myURL = url;
        this.cps = null;
        this.isCupsPrinter = false;
        this.init = false;
        this.defaultMediaIndex = -1;
        String host = this.myURL.getHost();
        if (host != null && host.equals(CUPSPrinter.getServer())) {
            this.isCupsPrinter = true;
            try {
                this.myURI = new URI("ipp://" + host + "/printers/" + this.printer);
                IPPPrintService.debug_println("IPPPrintService>> IPPPrintService myURI : " + this.myURI);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("invalid url");
            }
        }
    }

    IPPPrintService(String name, String uriStr, boolean isCups) {
        if (name == null || uriStr == null) {
            throw new IllegalArgumentException("null uri or printer name");
        }
        this.printer = name;
        this.supportedDocFlavors = null;
        this.supportedCats = null;
        this.mediaSizeNames = null;
        this.customMediaSizeNames = null;
        this.mediaTrays = null;
        this.cps = null;
        this.init = false;
        this.defaultMediaIndex = -1;
        try {
            this.myURL = new URL(uriStr.replaceFirst("ipp", "http"));
        }
        catch (Exception e) {
            IPPPrintService.debug_println("IPPPrintService>>  IPPPrintService, myURL=" + this.myURL + " Exception= " + e);
        }
        this.isCupsPrinter = isCups;
        try {
            this.myURI = new URI(uriStr);
            IPPPrintService.debug_println("IPPPrintService>> IPPPrintService myURI : " + this.myURI);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("invalid uri");
        }
    }

    private void initAttributes() {
        if (!this.init) {
            this.customMediaSizeNames = new CustomMediaSizeName[0];
            this.urlConnection = IPPPrintService.getIPPConnection(this.myURL);
            if (this.urlConnection == null) {
                this.mediaSizeNames = new MediaSizeName[0];
                this.mediaTrays = new MediaTray[0];
                IPPPrintService.debug_println("IPPPrintService>> initAttributes, NULL urlConnection ");
                this.init = true;
                return;
            }
            this.opGetAttributes();
            if (this.isCupsPrinter) {
                try {
                    this.cps = new CUPSPrinter(this.printer);
                    this.mediaSizeNames = this.cps.getMediaSizeNames();
                    this.mediaTrays = this.cps.getMediaTrays();
                    this.customMediaSizeNames = this.cps.getCustomMediaSizeNames();
                    this.urlConnection.disconnect();
                    this.init = true;
                    return;
                }
                catch (Exception e) {
                    IPPPrintService.debug_println("IPPPrintService>> initAttributes, error creating CUPSPrinter e=" + e);
                }
            }
            Media[] allMedia = this.getSupportedMedia();
            ArrayList<Media> sizeList = new ArrayList<Media>();
            ArrayList<Media> trayList = new ArrayList<Media>();
            for (int i = 0; i < allMedia.length; ++i) {
                if (allMedia[i] instanceof MediaSizeName) {
                    sizeList.add(allMedia[i]);
                    continue;
                }
                if (!(allMedia[i] instanceof MediaTray)) continue;
                trayList.add(allMedia[i]);
            }
            if (sizeList != null) {
                this.mediaSizeNames = new MediaSizeName[sizeList.size()];
                this.mediaSizeNames = sizeList.toArray(this.mediaSizeNames);
            }
            if (trayList != null) {
                this.mediaTrays = new MediaTray[trayList.size()];
                this.mediaTrays = trayList.toArray(this.mediaTrays);
            }
            this.urlConnection.disconnect();
            this.init = true;
        }
    }

    @Override
    public DocPrintJob createPrintJob() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPrintJobAccess();
        }
        return new UnixPrintJob(this);
    }

    @Override
    public synchronized Object getSupportedAttributeValues(Class<? extends Attribute> category, DocFlavor flavor, AttributeSet attributes) {
        if (category == null) {
            throw new NullPointerException("null category");
        }
        if (!Attribute.class.isAssignableFrom(category)) {
            throw new IllegalArgumentException(category + " does not implement Attribute");
        }
        if (flavor != null) {
            if (!this.isDocFlavorSupported(flavor)) {
                throw new IllegalArgumentException(flavor + " is an unsupported flavor");
            }
            if (this.isAutoSense(flavor)) {
                return null;
            }
        }
        if (!this.isAttributeCategorySupported(category)) {
            return null;
        }
        if (!this.isDestinationSupported(flavor, attributes)) {
            return null;
        }
        this.initAttributes();
        if (category == Copies.class || category == CopiesSupported.class) {
            if (flavor == null || !flavor.equals(DocFlavor.INPUT_STREAM.POSTSCRIPT) && !flavor.equals(DocFlavor.URL.POSTSCRIPT) && !flavor.equals(DocFlavor.BYTE_ARRAY.POSTSCRIPT)) {
                AttributeClass attribClass;
                CopiesSupported cs = new CopiesSupported(1, MAXCOPIES);
                AttributeClass attributeClass = attribClass = this.getAttMap != null ? (AttributeClass)this.getAttMap.get(cs.getName()) : null;
                if (attribClass != null) {
                    int[] range = attribClass.getIntRangeValue();
                    cs = new CopiesSupported(range[0], range[1]);
                }
                return cs;
            }
            return null;
        }
        if (category == Chromaticity.class) {
            if (flavor == null || flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) || !this.isIPPSupportedImages(flavor.getMimeType())) {
                Chromaticity[] arr = new Chromaticity[]{Chromaticity.COLOR};
                return arr;
            }
            return null;
        }
        if (category == Destination.class) {
            if (flavor == null || flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                try {
                    return new Destination(new File("out.ps").toURI());
                }
                catch (SecurityException se) {
                    try {
                        return new Destination(new URI("file:out.ps"));
                    }
                    catch (URISyntaxException e) {
                        return null;
                    }
                }
            }
            return null;
        }
        if (category == Fidelity.class) {
            Fidelity[] arr = new Fidelity[]{Fidelity.FIDELITY_FALSE, Fidelity.FIDELITY_TRUE};
            return arr;
        }
        if (category == Finishings.class) {
            int[] finArray;
            AttributeClass attribClass;
            AttributeClass attributeClass = attribClass = this.getAttMap != null ? (AttributeClass)this.getAttMap.get("finishings-supported") : null;
            if (attribClass != null && (finArray = attribClass.getArrayOfIntValues()) != null && finArray.length > 0) {
                Finishings[] finSup = new Finishings[finArray.length];
                block11: for (int i = 0; i < finArray.length; ++i) {
                    finSup[i] = Finishings.NONE;
                    Finishings[] fAll = (Finishings[])new ExtFinishing(100).getAll();
                    for (int j = 0; j < fAll.length; ++j) {
                        if (finArray[i] != fAll[j].getValue()) continue;
                        finSup[i] = fAll[j];
                        continue block11;
                    }
                }
                return finSup;
            }
        } else {
            if (category == JobName.class) {
                return new JobName("Java Printing", null);
            }
            if (category == JobSheets.class) {
                JobSheets[] arr = new JobSheets[]{JobSheets.NONE, JobSheets.STANDARD};
                return arr;
            }
            if (category == Media.class) {
                int i;
                Media[] allMedia = new Media[this.mediaSizeNames.length + this.mediaTrays.length];
                for (i = 0; i < this.mediaSizeNames.length; ++i) {
                    allMedia[i] = this.mediaSizeNames[i];
                }
                for (i = 0; i < this.mediaTrays.length; ++i) {
                    allMedia[i + this.mediaSizeNames.length] = this.mediaTrays[i];
                }
                if (allMedia.length == 0) {
                    allMedia = new Media[]{(Media)this.getDefaultAttributeValue(Media.class)};
                }
                return allMedia;
            }
            if (category == MediaPrintableArea.class) {
                MediaPrintableArea[] mpas = null;
                if (this.cps != null) {
                    mpas = this.cps.getMediaPrintableArea();
                }
                if (mpas == null) {
                    mpas = new MediaPrintableArea[]{(MediaPrintableArea)this.getDefaultAttributeValue(MediaPrintableArea.class)};
                }
                if (attributes == null || attributes.size() == 0) {
                    ArrayList<MediaPrintableArea> printableList = new ArrayList<MediaPrintableArea>();
                    for (int i = 0; i < mpas.length; ++i) {
                        if (mpas[i] == null) continue;
                        printableList.add(mpas[i]);
                    }
                    if (printableList.size() > 0) {
                        mpas = new MediaPrintableArea[printableList.size()];
                        printableList.toArray(mpas);
                    }
                    return mpas;
                }
                int match = -1;
                Media media = (Media)attributes.get(Media.class);
                if (media != null && media instanceof MediaSizeName) {
                    MediaSizeName msn = (MediaSizeName)media;
                    if (this.mediaSizeNames.length == 0 && msn.equals(this.getDefaultAttributeValue(Media.class))) {
                        return mpas;
                    }
                    for (int i = 0; i < this.mediaSizeNames.length; ++i) {
                        if (!msn.equals(this.mediaSizeNames[i])) continue;
                        match = i;
                    }
                }
                if (match == -1) {
                    return null;
                }
                MediaPrintableArea[] arr = new MediaPrintableArea[]{mpas[match]};
                return arr;
            }
            if (category == NumberUp.class) {
                AttributeClass attribClass;
                AttributeClass attributeClass = attribClass = this.getAttMap != null ? (AttributeClass)this.getAttMap.get("number-up-supported") : null;
                if (attribClass != null) {
                    int[] values = attribClass.getArrayOfIntValues();
                    if (values != null) {
                        NumberUp[] nUp = new NumberUp[values.length];
                        for (int i = 0; i < values.length; ++i) {
                            nUp[i] = new NumberUp(values[i]);
                        }
                        return nUp;
                    }
                    return null;
                }
            } else {
                if (category == OrientationRequested.class) {
                    int[] orientArray;
                    AttributeClass attribClass;
                    if (flavor != null && (flavor.equals(DocFlavor.INPUT_STREAM.POSTSCRIPT) || flavor.equals(DocFlavor.URL.POSTSCRIPT) || flavor.equals(DocFlavor.BYTE_ARRAY.POSTSCRIPT))) {
                        return null;
                    }
                    boolean revPort = false;
                    OrientationRequested[] orientSup = null;
                    AttributeClass attributeClass = attribClass = this.getAttMap != null ? (AttributeClass)this.getAttMap.get("orientation-requested-supported") : null;
                    if (attribClass != null && (orientArray = attribClass.getArrayOfIntValues()) != null && orientArray.length > 0) {
                        orientSup = new OrientationRequested[orientArray.length];
                        block18: for (int i = 0; i < orientArray.length; ++i) {
                            switch (orientArray[i]) {
                                default: {
                                    orientSup[i] = OrientationRequested.PORTRAIT;
                                    continue block18;
                                }
                                case 4: {
                                    orientSup[i] = OrientationRequested.LANDSCAPE;
                                    continue block18;
                                }
                                case 5: {
                                    orientSup[i] = OrientationRequested.REVERSE_LANDSCAPE;
                                    continue block18;
                                }
                                case 6: {
                                    orientSup[i] = OrientationRequested.REVERSE_PORTRAIT;
                                    revPort = true;
                                }
                            }
                        }
                    }
                    if (flavor == null || flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                        OrientationRequested[] orSup;
                        if (revPort && flavor == null) {
                            orSup = new OrientationRequested[]{OrientationRequested.PORTRAIT, OrientationRequested.LANDSCAPE, OrientationRequested.REVERSE_LANDSCAPE, OrientationRequested.REVERSE_PORTRAIT};
                            return orSup;
                        }
                        orSup = new OrientationRequested[]{OrientationRequested.PORTRAIT, OrientationRequested.LANDSCAPE, OrientationRequested.REVERSE_LANDSCAPE};
                        return orSup;
                    }
                    return orientSup;
                }
                if (category == PageRanges.class) {
                    if (flavor == null || flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                        PageRanges[] arr = new PageRanges[]{new PageRanges(1, Integer.MAX_VALUE)};
                        return arr;
                    }
                    return null;
                }
                if (category == RequestingUserName.class) {
                    String userName = "";
                    try {
                        userName = System.getProperty("user.name", "");
                    }
                    catch (SecurityException orientSup) {
                        // empty catch block
                    }
                    return new RequestingUserName(userName, null);
                }
                if (category == Sides.class) {
                    String[] sidesArray;
                    AttributeClass attribClass;
                    AttributeClass attributeClass = attribClass = this.getAttMap != null ? (AttributeClass)this.getAttMap.get("sides-supported") : null;
                    if (attribClass != null && (sidesArray = attribClass.getArrayOfStringValues()) != null && sidesArray.length > 0) {
                        Sides[] sidesSup = new Sides[sidesArray.length];
                        for (int i = 0; i < sidesArray.length; ++i) {
                            sidesSup[i] = sidesArray[i].endsWith("long-edge") ? Sides.TWO_SIDED_LONG_EDGE : (sidesArray[i].endsWith("short-edge") ? Sides.TWO_SIDED_SHORT_EDGE : Sides.ONE_SIDED);
                        }
                        return sidesSup;
                    }
                }
            }
        }
        return null;
    }

    @Override
    public AttributeSet getUnsupportedAttributes(DocFlavor flavor, AttributeSet attributes) {
        if (flavor != null && !this.isDocFlavorSupported(flavor)) {
            throw new IllegalArgumentException("flavor " + flavor + "is not supported");
        }
        if (attributes == null) {
            return null;
        }
        HashAttributeSet unsupp = new HashAttributeSet();
        Attribute[] attrs = attributes.toArray();
        for (int i = 0; i < attrs.length; ++i) {
            try {
                Attribute attr = attrs[i];
                if (!this.isAttributeCategorySupported(attr.getCategory())) {
                    unsupp.add(attr);
                    continue;
                }
                if (this.isAttributeValueSupported(attr, flavor, attributes)) continue;
                unsupp.add(attr);
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (unsupp.isEmpty()) {
            return null;
        }
        return unsupp;
    }

    @Override
    public synchronized DocFlavor[] getSupportedDocFlavors() {
        AttributeClass attribClass;
        if (this.supportedDocFlavors != null) {
            int len = this.supportedDocFlavors.length;
            DocFlavor[] copyflavors = new DocFlavor[len];
            System.arraycopy(this.supportedDocFlavors, 0, copyflavors, 0, len);
            return copyflavors;
        }
        this.initAttributes();
        if (this.getAttMap != null && this.getAttMap.containsKey("document-format-supported") && (attribClass = (AttributeClass)this.getAttMap.get("document-format-supported")) != null) {
            boolean psSupported = false;
            String[] docFlavors = attribClass.getArrayOfStringValues();
            HashSet<Object> docList = new HashSet<Object>();
            String hostEnc = DocFlavor.hostEncoding.toLowerCase(Locale.ENGLISH);
            boolean addHostEncoding = !hostEnc.equals("utf-8") && !hostEnc.equals("utf-16") && !hostEnc.equals("utf-16be") && !hostEnc.equals("utf-16le") && !hostEnc.equals("us-ascii");
            for (int i = 0; i < docFlavors.length; ++i) {
                int j;
                for (j = 0; j < allDocFlavors.length; ++j) {
                    DocFlavor[] flavors = (DocFlavor[])allDocFlavors[j];
                    String mimeType = flavors[0].getMimeType();
                    if (!mimeType.startsWith(docFlavors[i])) continue;
                    docList.addAll(Arrays.asList(flavors));
                    if (mimeType.equals("text/plain") && addHostEncoding) {
                        docList.add(Arrays.asList(textPlainHost));
                        break;
                    }
                    if (mimeType.equals("text/html") && addHostEncoding) {
                        docList.add(Arrays.asList(textHtmlHost));
                        break;
                    }
                    if (mimeType.equals("image/png")) {
                        this.pngImagesAdded = true;
                        break;
                    }
                    if (mimeType.equals("image/gif")) {
                        this.gifImagesAdded = true;
                        break;
                    }
                    if (mimeType.equals("image/jpeg")) {
                        this.jpgImagesAdded = true;
                        break;
                    }
                    if (mimeType.indexOf("postscript") == -1) break;
                    psSupported = true;
                    break;
                }
                if (j != allDocFlavors.length) continue;
                docList.add(new DocFlavor.BYTE_ARRAY(docFlavors[i]));
                docList.add(new DocFlavor.INPUT_STREAM(docFlavors[i]));
                docList.add(new DocFlavor.URL(docFlavors[i]));
            }
            if (psSupported || this.isCupsPrinter) {
                docList.add(DocFlavor.SERVICE_FORMATTED.PAGEABLE);
                docList.add(DocFlavor.SERVICE_FORMATTED.PRINTABLE);
                docList.addAll(Arrays.asList(imageJPG));
                docList.addAll(Arrays.asList(imagePNG));
                docList.addAll(Arrays.asList(imageGIF));
            }
            this.supportedDocFlavors = new DocFlavor[docList.size()];
            docList.toArray(this.supportedDocFlavors);
            int len = this.supportedDocFlavors.length;
            DocFlavor[] copyflavors = new DocFlavor[len];
            System.arraycopy(this.supportedDocFlavors, 0, copyflavors, 0, len);
            return copyflavors;
        }
        return null;
    }

    @Override
    public boolean isDocFlavorSupported(DocFlavor flavor) {
        if (this.supportedDocFlavors == null) {
            this.getSupportedDocFlavors();
        }
        if (this.supportedDocFlavors != null) {
            for (int f = 0; f < this.supportedDocFlavors.length; ++f) {
                if (!flavor.equals(this.supportedDocFlavors[f])) continue;
                return true;
            }
        }
        return false;
    }

    public CustomMediaSizeName findCustomMedia(MediaSizeName media) {
        if (this.customMediaSizeNames == null) {
            return null;
        }
        for (int i = 0; i < this.customMediaSizeNames.length; ++i) {
            CustomMediaSizeName custom = this.customMediaSizeNames[i];
            MediaSizeName msn = custom.getStandardMedia();
            if (!media.equals(msn)) continue;
            return this.customMediaSizeNames[i];
        }
        return null;
    }

    private Media getIPPMedia(String mediaName) {
        CustomMediaSizeName sampleSize = new CustomMediaSizeName("sample", "", 0.0f, 0.0f);
        Media[] sizes = sampleSize.getSuperEnumTable();
        for (int i = 0; i < sizes.length; ++i) {
            if (!mediaName.equals("" + sizes[i])) continue;
            return sizes[i];
        }
        CustomMediaTray sampleTray = new CustomMediaTray("sample", "");
        Media[] trays = sampleTray.getSuperEnumTable();
        for (int i = 0; i < trays.length; ++i) {
            if (!mediaName.equals("" + trays[i])) continue;
            return trays[i];
        }
        return null;
    }

    private Media[] getSupportedMedia() {
        AttributeClass attribClass;
        if (this.getAttMap != null && this.getAttMap.containsKey("media-supported") && (attribClass = (AttributeClass)this.getAttMap.get("media-supported")) != null) {
            String[] mediaVals = attribClass.getArrayOfStringValues();
            Media[] mediaNames = new Media[mediaVals.length];
            for (int i = 0; i < mediaVals.length; ++i) {
                Media msn;
                mediaNames[i] = msn = this.getIPPMedia(mediaVals[i]);
            }
            return mediaNames;
        }
        return new Media[0];
    }

    public synchronized Class[] getSupportedAttributeCategories() {
        if (this.supportedCats != null) {
            Class[] copyCats = new Class[this.supportedCats.length];
            System.arraycopy(this.supportedCats, 0, copyCats, 0, copyCats.length);
            return copyCats;
        }
        this.initAttributes();
        ArrayList<Class<Attribute>> catList = new ArrayList<Class<Attribute>>();
        for (int i = 0; i < printReqAttribDefault.length; ++i) {
            PrintRequestAttribute pra = (PrintRequestAttribute)printReqAttribDefault[i];
            if (this.getAttMap == null || !this.getAttMap.containsKey(pra.getName() + "-supported")) continue;
            Class<? extends Attribute> cl = pra.getCategory();
            catList.add(cl);
        }
        if (this.isCupsPrinter) {
            if (!catList.contains(Media.class)) {
                catList.add(Media.class);
            }
            catList.add(MediaPrintableArea.class);
            catList.add(Destination.class);
            if (!UnixPrintServiceLookup.isLinux()) {
                catList.add(SheetCollate.class);
            }
        }
        if (this.getAttMap != null && this.getAttMap.containsKey("color-supported")) {
            catList.add(Chromaticity.class);
        }
        this.supportedCats = new Class[catList.size()];
        catList.toArray(this.supportedCats);
        Class[] copyCats = new Class[this.supportedCats.length];
        System.arraycopy(this.supportedCats, 0, copyCats, 0, copyCats.length);
        return copyCats;
    }

    @Override
    public boolean isAttributeCategorySupported(Class<? extends Attribute> category) {
        if (category == null) {
            throw new NullPointerException("null category");
        }
        if (!Attribute.class.isAssignableFrom(category)) {
            throw new IllegalArgumentException(category + " is not an Attribute");
        }
        if (this.supportedCats == null) {
            this.getSupportedAttributeCategories();
        }
        if (category == OrientationRequested.class) {
            return true;
        }
        for (int i = 0; i < this.supportedCats.length; ++i) {
            if (category != this.supportedCats[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized <T extends PrintServiceAttribute> T getAttribute(Class<T> category) {
        if (category == null) {
            throw new NullPointerException("category");
        }
        if (!PrintServiceAttribute.class.isAssignableFrom(category)) {
            throw new IllegalArgumentException("Not a PrintServiceAttribute");
        }
        this.initAttributes();
        if (category == PrinterName.class) {
            return (T)new PrinterName(this.printer, null);
        }
        if (category == QueuedJobCount.class) {
            AttributeClass ac;
            QueuedJobCount qjc = new QueuedJobCount(0);
            AttributeClass attributeClass = ac = this.getAttMap != null ? (AttributeClass)this.getAttMap.get(qjc.getName()) : null;
            if (ac != null) {
                qjc = new QueuedJobCount(ac.getIntValue());
            }
            return (T)qjc;
        }
        if (category == PrinterIsAcceptingJobs.class) {
            AttributeClass ac;
            PrinterIsAcceptingJobs accJob = PrinterIsAcceptingJobs.ACCEPTING_JOBS;
            AttributeClass attributeClass = ac = this.getAttMap != null ? (AttributeClass)this.getAttMap.get(accJob.getName()) : null;
            if (ac != null && ac.getByteValue() == 0) {
                accJob = PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS;
            }
            return (T)accJob;
        }
        if (category == ColorSupported.class) {
            AttributeClass ac;
            ColorSupported cs = ColorSupported.SUPPORTED;
            AttributeClass attributeClass = ac = this.getAttMap != null ? (AttributeClass)this.getAttMap.get(cs.getName()) : null;
            if (ac != null && ac.getByteValue() == 0) {
                cs = ColorSupported.NOT_SUPPORTED;
            }
            return (T)cs;
        }
        if (category == PDLOverrideSupported.class) {
            if (this.isCupsPrinter) {
                return (T)PDLOverrideSupported.NOT_ATTEMPTED;
            }
            return (T)PDLOverrideSupported.NOT_ATTEMPTED;
        }
        return null;
    }

    @Override
    public synchronized PrintServiceAttributeSet getAttributes() {
        this.init = false;
        this.initAttributes();
        HashPrintServiceAttributeSet attrs = new HashPrintServiceAttributeSet();
        for (int i = 0; i < serviceAttributes.length; ++i) {
            Class c;
            Object psa;
            String name = (String)serviceAttributes[i][1];
            if (this.getAttMap == null || !this.getAttMap.containsKey(name) || (psa = this.getAttribute(c = (Class)serviceAttributes[i][0])) == null) continue;
            attrs.add((Attribute)psa);
        }
        return AttributeSetUtilities.unmodifiableView(attrs);
    }

    public boolean isIPPSupportedImages(String mimeType) {
        if (this.supportedDocFlavors == null) {
            this.getSupportedDocFlavors();
        }
        if (mimeType.equals("image/png") && this.pngImagesAdded) {
            return true;
        }
        if (mimeType.equals("image/gif") && this.gifImagesAdded) {
            return true;
        }
        return mimeType.equals("image/jpeg") && this.jpgImagesAdded;
    }

    private boolean isSupportedCopies(Copies copies) {
        int max;
        int min;
        CopiesSupported cs = (CopiesSupported)this.getSupportedAttributeValues(Copies.class, null, null);
        int[][] members = cs.getMembers();
        if (members.length > 0 && members[0].length > 0) {
            min = members[0][0];
            max = members[0][1];
        } else {
            min = 1;
            max = MAXCOPIES;
        }
        int value = copies.getValue();
        return value >= min && value <= max;
    }

    private boolean isAutoSense(DocFlavor flavor) {
        return flavor.equals(DocFlavor.BYTE_ARRAY.AUTOSENSE) || flavor.equals(DocFlavor.INPUT_STREAM.AUTOSENSE) || flavor.equals(DocFlavor.URL.AUTOSENSE);
    }

    private synchronized boolean isSupportedMediaTray(MediaTray msn) {
        this.initAttributes();
        if (this.mediaTrays != null) {
            for (int i = 0; i < this.mediaTrays.length; ++i) {
                if (!msn.equals(this.mediaTrays[i])) continue;
                return true;
            }
        }
        return false;
    }

    private synchronized boolean isSupportedMedia(MediaSizeName msn) {
        this.initAttributes();
        if (msn.equals((Media)this.getDefaultAttributeValue(Media.class))) {
            return true;
        }
        for (int i = 0; i < this.mediaSizeNames.length; ++i) {
            IPPPrintService.debug_println("IPPPrintService>> isSupportedMedia, mediaSizeNames[i] " + this.mediaSizeNames[i]);
            if (!msn.equals(this.mediaSizeNames[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isDestinationSupported(DocFlavor flavor, AttributeSet attributes) {
        return attributes == null || attributes.get(Destination.class) == null || flavor == null || flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE);
    }

    @Override
    public boolean isAttributeValueSupported(Attribute attr, DocFlavor flavor, AttributeSet attributes) {
        Class<? extends Attribute> category;
        if (attr == null) {
            throw new NullPointerException("null attribute");
        }
        if (flavor != null) {
            if (!this.isDocFlavorSupported(flavor)) {
                throw new IllegalArgumentException(flavor + " is an unsupported flavor");
            }
            if (this.isAutoSense(flavor)) {
                return false;
            }
        }
        if (!this.isAttributeCategorySupported(category = attr.getCategory())) {
            return false;
        }
        if (!this.isDestinationSupported(flavor, attributes)) {
            return false;
        }
        if (attr.getCategory() == Chromaticity.class) {
            if (flavor == null || flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) || !this.isIPPSupportedImages(flavor.getMimeType())) {
                return attr == Chromaticity.COLOR;
            }
            return false;
        }
        if (attr.getCategory() == Copies.class) {
            return (flavor == null || !flavor.equals(DocFlavor.INPUT_STREAM.POSTSCRIPT) && !flavor.equals(DocFlavor.URL.POSTSCRIPT) && !flavor.equals(DocFlavor.BYTE_ARRAY.POSTSCRIPT)) && this.isSupportedCopies((Copies)attr);
        }
        if (attr.getCategory() == Destination.class) {
            URI uri;
            return (flavor == null || flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) && "file".equals((uri = ((Destination)attr).getURI()).getScheme()) && !uri.getSchemeSpecificPart().equals("");
        }
        if (attr.getCategory() == Media.class) {
            if (attr instanceof MediaSizeName) {
                return this.isSupportedMedia((MediaSizeName)attr);
            }
            if (attr instanceof MediaTray) {
                return this.isSupportedMediaTray((MediaTray)attr);
            }
        } else if (attr.getCategory() == PageRanges.class) {
            if (flavor != null && !flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                return false;
            }
        } else if (attr.getCategory() == SheetCollate.class) {
            if (flavor != null && !flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                return false;
            }
        } else {
            if (attr.getCategory() == Sides.class) {
                Sides[] sidesArray = (Sides[])this.getSupportedAttributeValues(Sides.class, flavor, attributes);
                if (sidesArray != null) {
                    for (int i = 0; i < sidesArray.length; ++i) {
                        if (sidesArray[i] != (Sides)attr) continue;
                        return true;
                    }
                }
                return false;
            }
            if (attr.getCategory() == OrientationRequested.class) {
                OrientationRequested[] orientArray = (OrientationRequested[])this.getSupportedAttributeValues(OrientationRequested.class, flavor, attributes);
                if (orientArray != null) {
                    for (int i = 0; i < orientArray.length; ++i) {
                        if (orientArray[i] != (OrientationRequested)attr) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized Object getDefaultAttributeValue(Class<? extends Attribute> category) {
        AttributeClass attribClass;
        if (category == null) {
            throw new NullPointerException("null category");
        }
        if (!Attribute.class.isAssignableFrom(category)) {
            throw new IllegalArgumentException(category + " is not an Attribute");
        }
        if (!this.isAttributeCategorySupported(category)) {
            return null;
        }
        this.initAttributes();
        String catName = null;
        for (int i = 0; i < printReqAttribDefault.length; ++i) {
            PrintRequestAttribute pra = (PrintRequestAttribute)printReqAttribDefault[i];
            if (pra.getCategory() != category) continue;
            catName = pra.getName();
            break;
        }
        String attribName = catName + "-default";
        AttributeClass attributeClass = attribClass = this.getAttMap != null ? (AttributeClass)this.getAttMap.get(attribName) : null;
        if (category == Copies.class) {
            if (attribClass != null) {
                return new Copies(attribClass.getIntValue());
            }
            return new Copies(1);
        }
        if (category == Chromaticity.class) {
            return Chromaticity.COLOR;
        }
        if (category == Destination.class) {
            try {
                return new Destination(new File("out.ps").toURI());
            }
            catch (SecurityException se) {
                try {
                    return new Destination(new URI("file:out.ps"));
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }
        }
        if (category == Fidelity.class) {
            return Fidelity.FIDELITY_FALSE;
        }
        if (category == Finishings.class) {
            return Finishings.NONE;
        }
        if (category == JobName.class) {
            return new JobName("Java Printing", null);
        }
        if (category == JobSheets.class) {
            if (attribClass != null && attribClass.getStringValue().equals("none")) {
                return JobSheets.NONE;
            }
            return JobSheets.STANDARD;
        }
        if (category == Media.class) {
            this.defaultMediaIndex = 0;
            if (this.mediaSizeNames.length == 0) {
                String defaultCountry = Locale.getDefault().getCountry();
                if (defaultCountry != null && (defaultCountry.equals("") || defaultCountry.equals(Locale.US.getCountry()) || defaultCountry.equals(Locale.CANADA.getCountry()))) {
                    return MediaSizeName.NA_LETTER;
                }
                return MediaSizeName.ISO_A4;
            }
            if (attribClass != null) {
                String name = attribClass.getStringValue();
                if (this.isCupsPrinter) {
                    for (int i = 0; i < this.customMediaSizeNames.length; ++i) {
                        if (this.customMediaSizeNames[i].toString().indexOf(name) == -1) continue;
                        this.defaultMediaIndex = i;
                        return this.mediaSizeNames[this.defaultMediaIndex];
                    }
                } else {
                    for (int i = 0; i < this.mediaSizeNames.length; ++i) {
                        if (this.mediaSizeNames[i].toString().indexOf(name) == -1) continue;
                        this.defaultMediaIndex = i;
                        return this.mediaSizeNames[this.defaultMediaIndex];
                    }
                }
            }
            return this.mediaSizeNames[this.defaultMediaIndex];
        }
        if (category == MediaPrintableArea.class) {
            float ih;
            float iw;
            MediaPrintableArea[] mpas;
            if (this.cps != null && (mpas = this.cps.getMediaPrintableArea()) != null) {
                if (this.defaultMediaIndex == -1) {
                    this.getDefaultAttributeValue(Media.class);
                }
                return mpas[this.defaultMediaIndex];
            }
            String defaultCountry = Locale.getDefault().getCountry();
            if (defaultCountry != null && (defaultCountry.equals("") || defaultCountry.equals(Locale.US.getCountry()) || defaultCountry.equals(Locale.CANADA.getCountry()))) {
                iw = MediaSize.NA.LETTER.getX(25400) - 0.5f;
                ih = MediaSize.NA.LETTER.getY(25400) - 0.5f;
            } else {
                iw = MediaSize.ISO.A4.getX(25400) - 0.5f;
                ih = MediaSize.ISO.A4.getY(25400) - 0.5f;
            }
            return new MediaPrintableArea(0.25f, 0.25f, iw, ih, 25400);
        }
        if (category == NumberUp.class) {
            return new NumberUp(1);
        }
        if (category == OrientationRequested.class) {
            if (attribClass != null) {
                switch (attribClass.getIntValue()) {
                    default: {
                        return OrientationRequested.PORTRAIT;
                    }
                    case 4: {
                        return OrientationRequested.LANDSCAPE;
                    }
                    case 5: {
                        return OrientationRequested.REVERSE_LANDSCAPE;
                    }
                    case 6: 
                }
                return OrientationRequested.REVERSE_PORTRAIT;
            }
            return OrientationRequested.PORTRAIT;
        }
        if (category == PageRanges.class) {
            if (attribClass != null) {
                int[] range = attribClass.getIntRangeValue();
                return new PageRanges(range[0], range[1]);
            }
            return new PageRanges(1, Integer.MAX_VALUE);
        }
        if (category == RequestingUserName.class) {
            String userName = "";
            try {
                userName = System.getProperty("user.name", "");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return new RequestingUserName(userName, null);
        }
        if (category == SheetCollate.class) {
            return SheetCollate.UNCOLLATED;
        }
        if (category == Sides.class) {
            if (attribClass != null) {
                if (attribClass.getStringValue().endsWith("long-edge")) {
                    return Sides.TWO_SIDED_LONG_EDGE;
                }
                if (attribClass.getStringValue().endsWith("short-edge")) {
                    return Sides.TWO_SIDED_SHORT_EDGE;
                }
            }
            return Sides.ONE_SIDED;
        }
        return null;
    }

    @Override
    public ServiceUIFactory getServiceUIFactory() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeNotifier() {
        IPPPrintService iPPPrintService = this;
        synchronized (iPPPrintService) {
            if (this.notifier != null) {
                this.notifier.wake();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPrintServiceAttributeListener(PrintServiceAttributeListener listener) {
        IPPPrintService iPPPrintService = this;
        synchronized (iPPPrintService) {
            if (listener == null) {
                return;
            }
            if (this.notifier == null) {
                this.notifier = new ServiceNotifier(this);
            }
            this.notifier.addListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePrintServiceAttributeListener(PrintServiceAttributeListener listener) {
        IPPPrintService iPPPrintService = this;
        synchronized (iPPPrintService) {
            if (listener == null || this.notifier == null) {
                return;
            }
            this.notifier.removeListener(listener);
            if (this.notifier.isEmpty()) {
                this.notifier.stopNotifier();
                this.notifier = null;
            }
        }
    }

    @Override
    public String getName() {
        return this.printer;
    }

    @Override
    public boolean usesClass(Class c) {
        return c == PSPrinterJob.class;
    }

    public static HttpURLConnection getIPPConnection(URL url) {
        HttpURLConnection connection;
        try {
            connection = (HttpURLConnection)url.openConnection();
        }
        catch (IOException ioe) {
            return null;
        }
        if (!(connection instanceof HttpURLConnection)) {
            return null;
        }
        connection.setUseCaches(false);
        connection.setDefaultUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-type", "application/ipp");
        return connection;
    }

    public synchronized boolean isPostscript() {
        block5: {
            if (this.isPS == null) {
                this.isPS = Boolean.TRUE;
                if (this.isCupsPrinter) {
                    try {
                        String lineStr;
                        this.urlConnection = IPPPrintService.getIPPConnection(new URL(this.myURL + ".ppd"));
                        InputStream is = this.urlConnection.getInputStream();
                        if (is == null) break block5;
                        BufferedReader d = new BufferedReader(new InputStreamReader(is, Charset.forName("ISO-8859-1")));
                        while ((lineStr = d.readLine()) != null) {
                            if (!lineStr.startsWith("*cupsFilter:")) continue;
                            this.isPS = Boolean.FALSE;
                            break;
                        }
                    }
                    catch (IOException e) {
                        IPPPrintService.debug_println(" isPostscript, e= " + e);
                    }
                }
            }
        }
        return this.isPS;
    }

    private void opGetAttributes() {
        try {
            boolean success;
            IPPPrintService.debug_println("IPPPrintService>> opGetAttributes myURI " + this.myURI + " myURL " + this.myURL);
            AttributeClass[] attClNoUri = new AttributeClass[]{AttributeClass.ATTRIBUTES_CHARSET, AttributeClass.ATTRIBUTES_NATURAL_LANGUAGE};
            AttributeClass[] attCl = new AttributeClass[]{AttributeClass.ATTRIBUTES_CHARSET, AttributeClass.ATTRIBUTES_NATURAL_LANGUAGE, new AttributeClass("printer-uri", 69, "" + this.myURI)};
            OutputStream os = (OutputStream)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return IPPPrintService.this.urlConnection.getOutputStream();
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            });
            if (os == null) {
                return;
            }
            boolean bl = success = this.myURI == null ? IPPPrintService.writeIPPRequest(os, OP_GET_ATTRIBUTES, attClNoUri) : IPPPrintService.writeIPPRequest(os, OP_GET_ATTRIBUTES, attCl);
            if (success) {
                InputStream is = null;
                is = this.urlConnection.getInputStream();
                if (is != null) {
                    HashMap[] responseMap = IPPPrintService.readIPPResponse(is);
                    if (responseMap != null && responseMap.length > 0) {
                        this.getAttMap = responseMap[0];
                    }
                } else {
                    IPPPrintService.debug_println("IPPPrintService>> opGetAttributes - null input stream");
                }
                is.close();
            }
            os.close();
        }
        catch (IOException e) {
            IPPPrintService.debug_println("IPPPrintService>> opGetAttributes - input/output stream: " + e);
        }
    }

    public static boolean writeIPPRequest(OutputStream os, String operCode, AttributeClass[] attCl) {
        OutputStreamWriter osw;
        try {
            osw = new OutputStreamWriter(os, "UTF-8");
        }
        catch (UnsupportedEncodingException exc) {
            IPPPrintService.debug_println("IPPPrintService>> writeIPPRequest, UTF-8 not supported? Exception: " + exc);
            return false;
        }
        IPPPrintService.debug_println("IPPPrintService>> writeIPPRequest, op code= " + operCode);
        char[] opCode = new char[]{(char)Byte.parseByte(operCode.substring(0, 2), 16), (char)Byte.parseByte(operCode.substring(2, 4), 16)};
        char[] bytes = new char[]{'\u0001', '\u0001', '\u0000', '\u0001'};
        try {
            osw.write(bytes, 0, 2);
            osw.write(opCode, 0, 2);
            bytes[0] = '\u0000';
            bytes[1] = '\u0000';
            osw.write(bytes, 0, 4);
            bytes[0] = '\u0001';
            osw.write(bytes[0]);
            for (int i = 0; i < attCl.length; ++i) {
                AttributeClass ac = attCl[i];
                osw.write(ac.getType());
                char[] lenStr = ac.getLenChars();
                osw.write(lenStr, 0, 2);
                osw.write("" + ac, 0, ac.getName().length());
                if (ac.getType() < 53 || ac.getType() > 73) continue;
                String valStr = (String)ac.getObjectValue();
                bytes[0] = '\u0000';
                bytes[1] = (char)valStr.length();
                osw.write(bytes, 0, 2);
                osw.write(valStr, 0, valStr.length());
            }
            osw.write(3);
            osw.flush();
            osw.close();
        }
        catch (IOException ioe) {
            IPPPrintService.debug_println("IPPPrintService>> writeIPPRequest, IPPPrintService Exception in writeIPPRequest: " + ioe);
            return false;
        }
        return true;
    }

    public static HashMap[] readIPPResponse(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        byte[] response = new byte[MAX_ATTRIBUTE_LENGTH];
        try {
            DataInputStream ois = new DataInputStream(inputStream);
            if (ois.read(response, 0, 8) > -1 && response[2] == 0) {
                int counter = 0;
                short len = 0;
                String attribStr = null;
                int valTagByte = 68;
                ArrayList respList = new ArrayList();
                HashMap<String, AttributeClass> responseMap = new HashMap<String, AttributeClass>();
                response[0] = ois.readByte();
                while (response[0] >= 1 && response[0] <= 4 && response[0] != 3) {
                    AttributeClass ac;
                    byte[] outArray;
                    IPPPrintService.debug_println("IPPPrintService>> readIPPResponse, checking group tag,  response[0]= " + response[0]);
                    ByteArrayOutputStream outObj = new ByteArrayOutputStream();
                    counter = 0;
                    attribStr = null;
                    response[0] = ois.readByte();
                    while (response[0] >= 16 && response[0] <= 74) {
                        len = ois.readShort();
                        if (len != 0 && attribStr != null) {
                            outObj.write(counter);
                            outObj.flush();
                            outObj.close();
                            outArray = outObj.toByteArray();
                            if (responseMap.containsKey(attribStr)) {
                                respList.add(responseMap);
                                responseMap = new HashMap();
                            }
                            if (valTagByte >= 33) {
                                ac = new AttributeClass(attribStr, valTagByte, outArray);
                                responseMap.put(ac.getName(), ac);
                                IPPPrintService.debug_println("IPPPrintService>> readIPPResponse " + ac);
                            }
                            outObj = new ByteArrayOutputStream();
                            counter = 0;
                        }
                        if (counter == 0) {
                            valTagByte = response[0];
                        }
                        if (len != 0) {
                            if (len > MAX_ATTRIBUTE_LENGTH) {
                                response = new byte[len];
                            }
                            ois.read(response, 0, len);
                            attribStr = new String(response, 0, (int)len);
                        }
                        len = ois.readShort();
                        outObj.write(len);
                        if (len > MAX_ATTRIBUTE_LENGTH) {
                            response = new byte[len];
                        }
                        ois.read(response, 0, len);
                        outObj.write(response, 0, len);
                        ++counter;
                        response[0] = ois.readByte();
                    }
                    if (attribStr == null) continue;
                    outObj.write(counter);
                    outObj.flush();
                    outObj.close();
                    if (counter != 0 && responseMap.containsKey(attribStr)) {
                        respList.add(responseMap);
                        responseMap = new HashMap();
                    }
                    outArray = outObj.toByteArray();
                    ac = new AttributeClass(attribStr, valTagByte, outArray);
                    responseMap.put(ac.getName(), ac);
                }
                ois.close();
                if (responseMap != null && responseMap.size() > 0) {
                    respList.add(responseMap);
                }
                return respList.toArray(new HashMap[respList.size()]);
            }
            IPPPrintService.debug_println("IPPPrintService>> readIPPResponse client error, IPP status code-" + Integer.toHexString(response[2]) + " & " + Integer.toHexString(response[3]));
            return null;
        }
        catch (IOException e) {
            IPPPrintService.debug_println("IPPPrintService>> readIPPResponse: " + e);
            if (debugPrint) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public String toString() {
        return "IPP Printer : " + this.getName();
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof IPPPrintService && ((IPPPrintService)obj).getName().equals(this.getName());
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() + this.getName().hashCode();
    }

    static {
        String debugStr = AccessController.doPrivileged(new GetPropertyAction(FORCE_PIPE_PROP));
        debugPrint = "true".equalsIgnoreCase(debugStr);
        MAXCOPIES = 1000;
        MAX_ATTRIBUTE_LENGTH = (short)255;
        printReqAttribDefault = new Object[]{Chromaticity.COLOR, new Copies(1), Fidelity.FIDELITY_FALSE, Finishings.NONE, new JobName("", Locale.getDefault()), JobSheets.NONE, MediaSizeName.NA_LETTER, new NumberUp(1), OrientationRequested.PORTRAIT, new PageRanges(1), new RequestingUserName("", Locale.getDefault()), Sides.ONE_SIDED};
        serviceAttributes = new Object[][]{{ColorSupported.class, "color-supported"}, {PagesPerMinute.class, "pages-per-minute"}, {PagesPerMinuteColor.class, "pages-per-minute-color"}, {PDLOverrideSupported.class, "pdl-override-supported"}, {PrinterInfo.class, "printer-info"}, {PrinterIsAcceptingJobs.class, "printer-is-accepting-jobs"}, {PrinterLocation.class, "printer-location"}, {PrinterMakeAndModel.class, "printer-make-and-model"}, {PrinterMessageFromOperator.class, "printer-message-from-operator"}, {PrinterMoreInfo.class, "printer-more-info"}, {PrinterMoreInfoManufacturer.class, "printer-more-info-manufacturer"}, {PrinterName.class, "printer-name"}, {PrinterState.class, "printer-state"}, {PrinterStateReasons.class, "printer-state-reasons"}, {PrinterURI.class, "printer-uri"}, {QueuedJobCount.class, "queued-job-count"}};
        appPDF = new DocFlavor[]{DocFlavor.BYTE_ARRAY.PDF, DocFlavor.INPUT_STREAM.PDF, DocFlavor.URL.PDF};
        appPostScript = new DocFlavor[]{DocFlavor.BYTE_ARRAY.POSTSCRIPT, DocFlavor.INPUT_STREAM.POSTSCRIPT, DocFlavor.URL.POSTSCRIPT};
        appOctetStream = new DocFlavor[]{DocFlavor.BYTE_ARRAY.AUTOSENSE, DocFlavor.INPUT_STREAM.AUTOSENSE, DocFlavor.URL.AUTOSENSE};
        textPlain = new DocFlavor[]{DocFlavor.BYTE_ARRAY.TEXT_PLAIN_UTF_8, DocFlavor.BYTE_ARRAY.TEXT_PLAIN_UTF_16, DocFlavor.BYTE_ARRAY.TEXT_PLAIN_UTF_16BE, DocFlavor.BYTE_ARRAY.TEXT_PLAIN_UTF_16LE, DocFlavor.BYTE_ARRAY.TEXT_PLAIN_US_ASCII, DocFlavor.INPUT_STREAM.TEXT_PLAIN_UTF_8, DocFlavor.INPUT_STREAM.TEXT_PLAIN_UTF_16, DocFlavor.INPUT_STREAM.TEXT_PLAIN_UTF_16BE, DocFlavor.INPUT_STREAM.TEXT_PLAIN_UTF_16LE, DocFlavor.INPUT_STREAM.TEXT_PLAIN_US_ASCII, DocFlavor.URL.TEXT_PLAIN_UTF_8, DocFlavor.URL.TEXT_PLAIN_UTF_16, DocFlavor.URL.TEXT_PLAIN_UTF_16BE, DocFlavor.URL.TEXT_PLAIN_UTF_16LE, DocFlavor.URL.TEXT_PLAIN_US_ASCII, DocFlavor.CHAR_ARRAY.TEXT_PLAIN, DocFlavor.STRING.TEXT_PLAIN, DocFlavor.READER.TEXT_PLAIN};
        textPlainHost = new DocFlavor[]{DocFlavor.BYTE_ARRAY.TEXT_PLAIN_HOST, DocFlavor.INPUT_STREAM.TEXT_PLAIN_HOST, DocFlavor.URL.TEXT_PLAIN_HOST};
        imageJPG = new DocFlavor[]{DocFlavor.BYTE_ARRAY.JPEG, DocFlavor.INPUT_STREAM.JPEG, DocFlavor.URL.JPEG};
        imageGIF = new DocFlavor[]{DocFlavor.BYTE_ARRAY.GIF, DocFlavor.INPUT_STREAM.GIF, DocFlavor.URL.GIF};
        imagePNG = new DocFlavor[]{DocFlavor.BYTE_ARRAY.PNG, DocFlavor.INPUT_STREAM.PNG, DocFlavor.URL.PNG};
        textHtml = new DocFlavor[]{DocFlavor.BYTE_ARRAY.TEXT_HTML_UTF_8, DocFlavor.BYTE_ARRAY.TEXT_HTML_UTF_16, DocFlavor.BYTE_ARRAY.TEXT_HTML_UTF_16BE, DocFlavor.BYTE_ARRAY.TEXT_HTML_UTF_16LE, DocFlavor.BYTE_ARRAY.TEXT_HTML_US_ASCII, DocFlavor.INPUT_STREAM.TEXT_HTML_UTF_8, DocFlavor.INPUT_STREAM.TEXT_HTML_UTF_16, DocFlavor.INPUT_STREAM.TEXT_HTML_UTF_16BE, DocFlavor.INPUT_STREAM.TEXT_HTML_UTF_16LE, DocFlavor.INPUT_STREAM.TEXT_HTML_US_ASCII, DocFlavor.URL.TEXT_HTML_UTF_8, DocFlavor.URL.TEXT_HTML_UTF_16, DocFlavor.URL.TEXT_HTML_UTF_16BE, DocFlavor.URL.TEXT_HTML_UTF_16LE, DocFlavor.URL.TEXT_HTML_US_ASCII};
        textHtmlHost = new DocFlavor[]{DocFlavor.BYTE_ARRAY.TEXT_HTML_HOST, DocFlavor.INPUT_STREAM.TEXT_HTML_HOST, DocFlavor.URL.TEXT_HTML_HOST};
        appPCL = new DocFlavor[]{DocFlavor.BYTE_ARRAY.PCL, DocFlavor.INPUT_STREAM.PCL, DocFlavor.URL.PCL};
        allDocFlavors = new Object[]{appPDF, appPostScript, appOctetStream, textPlain, imageJPG, imageGIF, imagePNG, textHtml, appPCL};
    }

    private class ExtFinishing
    extends Finishings {
        ExtFinishing(int value) {
            super(100);
        }

        EnumSyntax[] getAll() {
            EnumSyntax[] es = super.getEnumValueTable();
            return es;
        }
    }
}

