/*
 * Decompiled with CFR 0.152.
 */
package com.sun.beans.decoder;

import com.sun.beans.decoder.AccessorElementHandler;
import com.sun.beans.finder.FieldFinder;
import java.lang.reflect.Field;

final class FieldElementHandler
extends AccessorElementHandler {
    private Class<?> type;

    FieldElementHandler() {
    }

    @Override
    public void addAttribute(String name, String value) {
        if (name.equals("class")) {
            this.type = this.getOwner().findClass(value);
        } else {
            super.addAttribute(name, value);
        }
    }

    @Override
    protected boolean isArgument() {
        return super.isArgument() && this.type != null;
    }

    @Override
    protected Object getContextBean() {
        return this.type != null ? this.type : super.getContextBean();
    }

    @Override
    protected Object getValue(String name) {
        try {
            return FieldElementHandler.getFieldValue(this.getContextBean(), name);
        }
        catch (Exception exception) {
            this.getOwner().handleException(exception);
            return null;
        }
    }

    @Override
    protected void setValue(String name, Object value) {
        try {
            FieldElementHandler.setFieldValue(this.getContextBean(), name, value);
        }
        catch (Exception exception) {
            this.getOwner().handleException(exception);
        }
    }

    static Object getFieldValue(Object bean, String name) throws IllegalAccessException, NoSuchFieldException {
        return FieldElementHandler.findField(bean, name).get(bean);
    }

    private static void setFieldValue(Object bean, String name, Object value) throws IllegalAccessException, NoSuchFieldException {
        FieldElementHandler.findField(bean, name).set(bean, value);
    }

    private static Field findField(Object bean, String name) throws NoSuchFieldException {
        return bean instanceof Class ? FieldFinder.findStaticField((Class)bean, name) : FieldFinder.findField(bean.getClass(), name);
    }
}

