/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.jgss;

import java.net.InetAddress;
import java.util.Arrays;

public class ChannelBinding {
    private InetAddress initiator;
    private InetAddress acceptor;
    private byte[] appData;

    public ChannelBinding(InetAddress initAddr, InetAddress acceptAddr, byte[] appData) {
        this.initiator = initAddr;
        this.acceptor = acceptAddr;
        if (appData != null) {
            this.appData = new byte[appData.length];
            System.arraycopy(appData, 0, this.appData, 0, appData.length);
        }
    }

    public ChannelBinding(byte[] appData) {
        this(null, null, appData);
    }

    public InetAddress getInitiatorAddress() {
        return this.initiator;
    }

    public InetAddress getAcceptorAddress() {
        return this.acceptor;
    }

    public byte[] getApplicationData() {
        if (this.appData == null) {
            return null;
        }
        byte[] retVal = new byte[this.appData.length];
        System.arraycopy(this.appData, 0, retVal, 0, this.appData.length);
        return retVal;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ChannelBinding)) {
            return false;
        }
        ChannelBinding cb = (ChannelBinding)obj;
        if (this.initiator != null && cb.initiator == null || this.initiator == null && cb.initiator != null) {
            return false;
        }
        if (this.initiator != null && !this.initiator.equals(cb.initiator)) {
            return false;
        }
        if (this.acceptor != null && cb.acceptor == null || this.acceptor == null && cb.acceptor != null) {
            return false;
        }
        if (this.acceptor != null && !this.acceptor.equals(cb.acceptor)) {
            return false;
        }
        return Arrays.equals(this.appData, cb.appData);
    }

    public int hashCode() {
        if (this.initiator != null) {
            return this.initiator.hashCode();
        }
        if (this.acceptor != null) {
            return this.acceptor.hashCode();
        }
        if (this.appData != null) {
            return new String(this.appData).hashCode();
        }
        return 1;
    }
}

