/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled.spi;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public abstract class FormatConversionProvider {
    public abstract AudioFormat.Encoding[] getSourceEncodings();

    public abstract AudioFormat.Encoding[] getTargetEncodings();

    public boolean isSourceEncodingSupported(AudioFormat.Encoding sourceEncoding) {
        AudioFormat.Encoding[] sourceEncodings = this.getSourceEncodings();
        for (int i = 0; i < sourceEncodings.length; ++i) {
            if (!sourceEncoding.equals(sourceEncodings[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isTargetEncodingSupported(AudioFormat.Encoding targetEncoding) {
        AudioFormat.Encoding[] targetEncodings = this.getTargetEncodings();
        for (int i = 0; i < targetEncodings.length; ++i) {
            if (!targetEncoding.equals(targetEncodings[i])) continue;
            return true;
        }
        return false;
    }

    public abstract AudioFormat.Encoding[] getTargetEncodings(AudioFormat var1);

    public boolean isConversionSupported(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        AudioFormat.Encoding[] targetEncodings = this.getTargetEncodings(sourceFormat);
        for (int i = 0; i < targetEncodings.length; ++i) {
            if (!targetEncoding.equals(targetEncodings[i])) continue;
            return true;
        }
        return false;
    }

    public abstract AudioFormat[] getTargetFormats(AudioFormat.Encoding var1, AudioFormat var2);

    public boolean isConversionSupported(AudioFormat targetFormat, AudioFormat sourceFormat) {
        AudioFormat[] targetFormats = this.getTargetFormats(targetFormat.getEncoding(), sourceFormat);
        for (int i = 0; i < targetFormats.length; ++i) {
            if (!targetFormat.matches(targetFormats[i])) continue;
            return true;
        }
        return false;
    }

    public abstract AudioInputStream getAudioInputStream(AudioFormat.Encoding var1, AudioInputStream var2);

    public abstract AudioInputStream getAudioInputStream(AudioFormat var1, AudioInputStream var2);
}

