/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Iterator;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.XFireFactory;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.client.Client;
import org.codehaus.xfire.client.XFireProxy;
import org.codehaus.xfire.service.Binding;
import org.codehaus.xfire.service.Endpoint;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.transport.Transport;

public class XFireProxyFactory {
    private XFire xfire;

    public XFireProxyFactory() {
        this.xfire = XFireFactory.newInstance().getXFire();
    }

    public XFireProxyFactory(XFire xfire) {
        this.xfire = xfire;
    }

    public Object create(Service service, String url) throws MalformedURLException {
        Collection transports = this.xfire.getTransportManager().getTransportsForUri(url);
        if (transports.size() == 0) {
            throw new XFireRuntimeException("No Transport is available for url " + url);
        }
        Binding binding = null;
        Transport transport = null;
        Iterator itr = transports.iterator();
        while (itr.hasNext() && binding == null) {
            transport = (Transport)itr.next();
            for (int i = 0; i < transport.getSupportedBindings().length && (binding = service.getBinding(transport.getSupportedBindings()[i])) == null; ++i) {
            }
        }
        Client client = new Client(transport, binding, url);
        return this.create(client);
    }

    public Object create(Service service, Transport transport, String url) throws MalformedURLException {
        return this.create(new Client(transport, service, url));
    }

    public Object create(Client client) {
        client.setXFire(this.xfire);
        XFireProxy handler = new XFireProxy(client);
        Class serviceClass = client.getService().getServiceInfo().getServiceClass();
        if (!serviceClass.isInterface()) {
            throw new IllegalStateException("Service class is not an interface. Please use an interface specify or specify one via a @WebService annotation.");
        }
        return Proxy.newProxyInstance(serviceClass.getClassLoader(), new Class[]{serviceClass}, (InvocationHandler)handler);
    }

    public Object create(Endpoint endpoint) throws MalformedURLException {
        Binding binding = endpoint.getBinding();
        Transport t = this.xfire.getTransportManager().getTransport(binding.getBindingId());
        if (t == null) {
            throw new XFireRuntimeException("Could not find transport for binding " + binding.getBindingId());
        }
        return this.create(new Client(t, endpoint));
    }

    public Object create(Binding binding, String address) throws MalformedURLException {
        Transport t = this.xfire.getTransportManager().getTransport(binding.getBindingId());
        if (t == null) {
            throw new XFireRuntimeException("Could not find transport for binding " + binding.getBindingId());
        }
        Client client = new Client(t, binding, address);
        return this.create(client);
    }
}

