/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.config.ParamConfig;
import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.exceptions.InternalErrorException;
import amazon.fws.clicommando.processors.CommandProcessor;
import amazon.fws.clicommando.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import org.apache.commons.codec.binary.Base64;

public class EncodeCommandProcessor
implements CommandProcessor {
    public static final String BASE64_ENCODING = "Base64";

    public Command process(Command process) throws CliCommandoException {
        Collection<ParamConfig> parameters = process.getCurrentCommandConfig().getAllParameters();
        for (ParamConfig param : parameters) {
            String encoding = param.getEncoding();
            if (StringUtils.isEmpty(encoding)) continue;
            if (!BASE64_ENCODING.equalsIgnoreCase(encoding)) {
                throw new ConfigurationErrorException("Illegal encoding: " + encoding);
            }
            String paramValue = param.getValue();
            if (paramValue == null) continue;
            try {
                paramValue = new String(Base64.encodeBase64((byte[])param.getValue().getBytes()), "UTF-8");
                param.setValue(paramValue, param.getInputMode());
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                throw new InternalErrorException("Probably a bug, unknown encoding: " + encoding);
            }
        }
        return process;
    }
}

