/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.FastShortMessage;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Track;

final class SMFParser {
    private static final int MTrk_MAGIC = 1297379947;
    private static final boolean STRICT_PARSER = false;
    private static final boolean DEBUG = false;
    int tracks;
    DataInputStream stream;
    private int trackLength = 0;
    private byte[] trackData = null;
    private int pos = 0;

    SMFParser() {
    }

    private int readUnsigned() throws IOException {
        return this.trackData[this.pos++] & 0xFF;
    }

    private void read(byte[] data) throws IOException {
        System.arraycopy(this.trackData, this.pos, data, 0, data.length);
        this.pos += data.length;
    }

    private long readVarInt() throws IOException {
        long value = 0L;
        int currentByte = 0;
        do {
            currentByte = this.trackData[this.pos++] & 0xFF;
            value = (value << 7) + (long)(currentByte & 0x7F);
        } while ((currentByte & 0x80) != 0);
        return value;
    }

    private int readIntFromStream() throws IOException {
        try {
            return this.stream.readInt();
        }
        catch (EOFException eof) {
            throw new EOFException("invalid MIDI file");
        }
    }

    boolean nextTrack() throws IOException, InvalidMidiDataException {
        int magic;
        this.trackLength = 0;
        do {
            if (this.stream.skipBytes(this.trackLength) != this.trackLength) {
                return false;
            }
            magic = this.readIntFromStream();
            this.trackLength = this.readIntFromStream();
        } while (magic != 1297379947);
        if (this.trackLength < 0) {
            return false;
        }
        this.trackData = new byte[this.trackLength];
        try {
            this.stream.readFully(this.trackData);
        }
        catch (EOFException eof) {
            return false;
        }
        this.pos = 0;
        return true;
    }

    private boolean trackFinished() {
        return this.pos >= this.trackLength;
    }

    void readTrack(Track track) throws IOException, InvalidMidiDataException {
        try {
            long tick = 0L;
            int status = 0;
            boolean endOfTrackFound = false;
            while (!this.trackFinished() && !endOfTrackFound) {
                MidiMessage message;
                int data1 = -1;
                int data2 = 0;
                tick += this.readVarInt();
                int byteValue = this.readUnsigned();
                if (byteValue >= 128) {
                    status = byteValue;
                } else {
                    data1 = byteValue;
                }
                block1 : switch (status & 0xF0) {
                    case 128: 
                    case 144: 
                    case 160: 
                    case 176: 
                    case 224: {
                        if (data1 == -1) {
                            data1 = this.readUnsigned();
                        }
                        data2 = this.readUnsigned();
                        message = new FastShortMessage(status | data1 << 8 | data2 << 16);
                        break;
                    }
                    case 192: 
                    case 208: {
                        if (data1 == -1) {
                            data1 = this.readUnsigned();
                        }
                        message = new FastShortMessage(status | data1 << 8);
                        break;
                    }
                    case 240: {
                        switch (status) {
                            case 240: 
                            case 247: {
                                int sysexLength = (int)this.readVarInt();
                                byte[] sysexData = new byte[sysexLength];
                                this.read(sysexData);
                                SysexMessage sysexMessage = new SysexMessage();
                                sysexMessage.setMessage(status, sysexData, sysexLength);
                                message = sysexMessage;
                                break block1;
                            }
                            case 255: {
                                int metaType = this.readUnsigned();
                                int metaLength = (int)this.readVarInt();
                                byte[] metaData = new byte[metaLength];
                                this.read(metaData);
                                MetaMessage metaMessage = new MetaMessage();
                                metaMessage.setMessage(metaType, metaData, metaLength);
                                message = metaMessage;
                                if (metaType != 47) break block1;
                                endOfTrackFound = true;
                                break block1;
                            }
                            default: {
                                throw new InvalidMidiDataException("Invalid status byte: " + status);
                            }
                        }
                    }
                    default: {
                        throw new InvalidMidiDataException("Invalid status byte: " + status);
                    }
                }
                track.add(new MidiEvent(message, tick));
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new EOFException("invalid MIDI file");
        }
    }
}

