/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.security.AccessController;
import sun.awt.X11.XAtom;
import sun.awt.X11.XToolkit;
import sun.security.action.GetPropertyAction;

class MotifColorUtilities {
    static final float XmRED_LUMINOSITY = 0.3f;
    static final float XmGREEN_LUMINOSITY = 0.59f;
    static final float XmBLUE_LUMINOSITY = 0.11f;
    static final int XmINTENSITY_FACTOR = 75;
    static final int XmLIGHT_FACTOR = 0;
    static final int XmLUMINOSITY_FACTOR = 25;
    static final int XmMAX_SHORT = 65535;
    static final int XmCOLOR_PERCENTILE = 655;
    static final int XmDEFAULT_DARK_THRESHOLD = 20;
    static final int XmDEFAULT_LIGHT_THRESHOLD = 93;
    static final int XmDEFAULT_FOREGROUND_THRESHOLD = 70;
    static final int BLACK = -16777216;
    static final int WHITE = -1;
    static final int MOTIF_WINDOW_COLOR = -2105377;
    static final int DEFAULT_COLOR = -3881788;
    static final int XmCOLOR_LITE_THRESHOLD = 60915;
    static final int XmCOLOR_DARK_THRESHOLD = 13100;
    static final int XmFOREGROUND_THRESHOLD = 45850;
    static final int XmCOLOR_LITE_SEL_FACTOR = 15;
    static final int XmCOLOR_LITE_BS_FACTOR = 40;
    static final int XmCOLOR_LITE_TS_FACTOR = 20;
    static final int XmCOLOR_DARK_SEL_FACTOR = 15;
    static final int XmCOLOR_DARK_BS_FACTOR = 30;
    static final int XmCOLOR_DARK_TS_FACTOR = 50;
    static final int XmCOLOR_HI_SEL_FACTOR = 15;
    static final int XmCOLOR_HI_BS_FACTOR = 40;
    static final int XmCOLOR_HI_TS_FACTOR = 60;
    static final int XmCOLOR_LO_SEL_FACTOR = 15;
    static final int XmCOLOR_LO_BS_FACTOR = 60;
    static final int XmCOLOR_LO_TS_FACTOR = 50;

    MotifColorUtilities() {
    }

    static int brightness(int red, int green, int blue) {
        float intensity = ((red <<= 8) + (green <<= 8) + (blue <<= 8)) / 3;
        float luminosity = (int)(0.3f * (float)red + 0.59f * (float)green + 0.11f * (float)blue);
        float maxprimary = red > green ? (red > blue ? red : blue) : (green > blue ? green : blue);
        float minprimary = red < green ? (red < blue ? red : blue) : (green < blue ? green : blue);
        float light = (minprimary + maxprimary) / 2.0f;
        float brightness = (intensity * 75.0f + light * 0.0f + luminosity * 25.0f) / 100.0f;
        return Math.round(brightness);
    }

    static int calculateForegroundFromBackground(int r, int g, int b) {
        int foreground = -1;
        int brightness = MotifColorUtilities.brightness(r, g, b);
        foreground = brightness > 45850 ? -16777216 : -1;
        return foreground;
    }

    static int calculateTopShadowFromBackground(int r, int g, int b) {
        float blue;
        float green;
        float red;
        int br = r << 8;
        int bg = g << 8;
        int bb = b << 8;
        int brightness = MotifColorUtilities.brightness(r, g, b);
        if (brightness < 13100) {
            float color_value = br;
            color_value += 50.0f * (65535.0f - color_value) / 100.0f;
            red = color_value;
            color_value = bg;
            color_value += 50.0f * (65535.0f - color_value) / 100.0f;
            green = color_value;
            color_value = bb;
            color_value += 50.0f * (65535.0f - color_value) / 100.0f;
            blue = color_value;
        } else if (brightness > 60915) {
            float color_value = br;
            color_value -= color_value * 20.0f / 100.0f;
            red = color_value;
            color_value = bg;
            color_value -= color_value * 20.0f / 100.0f;
            green = color_value;
            color_value = bb;
            color_value -= color_value * 20.0f / 100.0f;
            blue = color_value;
        } else {
            float f = 50 + brightness * 10 / 65535;
            float color_value = br;
            color_value += f * (65535.0f - color_value) / 100.0f;
            red = color_value;
            color_value = bg;
            color_value += f * (65535.0f - color_value) / 100.0f;
            green = color_value;
            color_value = bb;
            color_value += f * (65535.0f - color_value) / 100.0f;
            blue = color_value;
        }
        int ired = (int)red >> 8;
        int igreen = (int)green >> 8;
        int iblue = (int)blue >> 8;
        int ret = 0xFF000000 | ired << 16 | igreen << 8 | iblue;
        return ret;
    }

    static int calculateBottomShadowFromBackground(int r, int g, int b) {
        float blue;
        float green;
        float red;
        int br = r << 8;
        int bg = g << 8;
        int bb = b << 8;
        int brightness = MotifColorUtilities.brightness(r, g, b);
        if (brightness < 13100) {
            float color_value = br;
            color_value += 30.0f * (65535.0f - color_value) / 100.0f;
            red = color_value;
            color_value = bg;
            color_value += 30.0f * (65535.0f - color_value) / 100.0f;
            green = color_value;
            color_value = bb;
            color_value += 30.0f * (65535.0f - color_value) / 100.0f;
            blue = color_value;
        } else if (brightness > 60915) {
            float color_value = br;
            color_value -= color_value * 40.0f / 100.0f;
            red = color_value;
            color_value = bg;
            color_value -= color_value * 40.0f / 100.0f;
            green = color_value;
            color_value = bb;
            color_value -= color_value * 40.0f / 100.0f;
            blue = color_value;
        } else {
            float f = 60 + brightness * -20 / 65535;
            float color_value = br;
            color_value -= color_value * f / 100.0f;
            red = color_value;
            color_value = bg;
            color_value -= color_value * f / 100.0f;
            green = color_value;
            color_value = bb;
            color_value -= color_value * f / 100.0f;
            blue = color_value;
        }
        int ired = (int)red >> 8;
        int igreen = (int)green >> 8;
        int iblue = (int)blue >> 8;
        int ret = 0xFF000000 | ired << 16 | igreen << 8 | iblue;
        return ret;
    }

    static int calculateSelectFromBackground(int r, int g, int b) {
        float blue;
        float green;
        float red;
        int br = r << 8;
        int bg = g << 8;
        int bb = b << 8;
        int brightness = MotifColorUtilities.brightness(r, g, b);
        if (brightness < 13100) {
            float color_value = br;
            color_value += 15.0f * (65535.0f - color_value) / 100.0f;
            red = color_value;
            color_value = bg;
            color_value += 15.0f * (65535.0f - color_value) / 100.0f;
            green = color_value;
            color_value = bb;
            color_value += 15.0f * (65535.0f - color_value) / 100.0f;
            blue = color_value;
        } else if (brightness > 60915) {
            float color_value = br;
            color_value -= color_value * 15.0f / 100.0f;
            red = color_value;
            color_value = bg;
            color_value -= color_value * 15.0f / 100.0f;
            green = color_value;
            color_value = bb;
            color_value -= color_value * 15.0f / 100.0f;
            blue = color_value;
        } else {
            float f = 15 + brightness * 0 / 65535;
            float color_value = br;
            color_value -= color_value * f / 100.0f;
            red = color_value;
            color_value = bg;
            color_value -= color_value * f / 100.0f;
            green = color_value;
            color_value = bb;
            color_value -= color_value * f / 100.0f;
            blue = color_value;
        }
        int ired = (int)red >> 8;
        int igreen = (int)green >> 8;
        int iblue = (int)blue >> 8;
        int ret = 0xFF000000 | ired << 16 | igreen << 8 | iblue;
        return ret;
    }

    static void loadSystemColorsForCDE(int[] systemColors) throws Exception {
        int b;
        int g;
        int r;
        int index;
        XAtom resourceManager = XAtom.get("RESOURCE_MANAGER");
        String resourceString = resourceManager.getProperty(XToolkit.getDefaultRootWindow());
        int len = resourceString.length();
        for (index = resourceString.indexOf("ColorPalette:"); index < len && resourceString.charAt(index) != ':'; ++index) {
        }
        if (resourceString.charAt(++index) == '\t') {
            ++index;
        }
        String paletteFile = resourceString.substring(index, resourceString.indexOf("\n", index));
        String paletteFilePath = System.getProperty("user.home") + "/.dt/palettes/" + paletteFile;
        File pFile = new File(paletteFilePath);
        if (!pFile.exists() && !(pFile = new File(paletteFilePath = "/usr/dt/palettes/" + paletteFile)).exists()) {
            throw new FileNotFoundException("Could not open : " + paletteFilePath);
        }
        BufferedReader bfr = new BufferedReader(new FileReader(pFile));
        int[] colors = new int[8];
        for (int i = 0; i < 8; ++i) {
            String temp = bfr.readLine();
            String color = temp.substring(1, temp.length());
            r = Integer.valueOf(color.substring(0, 4), 16) >> 8;
            g = Integer.valueOf(color.substring(4, 8), 16) >> 8;
            b = Integer.valueOf(color.substring(8, 12), 16) >> 8;
            colors[i] = 0xFF000000 | r << 16 | g << 8 | b;
        }
        systemColors[1] = colors[0];
        systemColors[3] = colors[0];
        systemColors[4] = colors[1];
        systemColors[6] = colors[1];
        systemColors[7] = colors[1];
        systemColors[8] = colors[1];
        systemColors[10] = colors[1];
        systemColors[12] = colors[3];
        systemColors[23] = colors[1];
        systemColors[17] = colors[1];
        r = (colors[0] & 0xFF0000) >> 16;
        g = (colors[0] & 0xFF00) >> 8;
        b = colors[0] & 0xFF;
        int activeFore = MotifColorUtilities.calculateForegroundFromBackground(r, g, b);
        r = (colors[1] & 0xFF0000) >> 16;
        g = (colors[1] & 0xFF00) >> 8;
        b = colors[1] & 0xFF;
        int inactiveFore = MotifColorUtilities.calculateForegroundFromBackground(r, g, b);
        int top_shadow = MotifColorUtilities.calculateTopShadowFromBackground(r, g, b);
        int bottom_shadow = MotifColorUtilities.calculateBottomShadowFromBackground(r, g, b);
        r = (colors[3] & 0xFF0000) >> 16;
        g = (colors[3] & 0xFF00) >> 8;
        b = colors[3] & 0xFF;
        int textFore = MotifColorUtilities.calculateForegroundFromBackground(r, g, b);
        systemColors[2] = activeFore;
        systemColors[5] = inactiveFore;
        systemColors[9] = inactiveFore;
        systemColors[11] = inactiveFore;
        systemColors[13] = textFore;
        systemColors[14] = -16777216;
        systemColors[15] = -3881788;
        systemColors[18] = inactiveFore;
        Color tmp = new Color(top_shadow);
        systemColors[19] = top_shadow;
        systemColors[20] = tmp.brighter().getRGB();
        tmp = new Color(bottom_shadow);
        systemColors[21] = bottom_shadow;
        systemColors[22] = tmp.darker().getRGB();
    }

    static void loadMotifDefaultColors(int[] systemColors) {
        systemColors[7] = -2105377;
        systemColors[12] = -1;
        systemColors[9] = -16777216;
        systemColors[11] = -16777216;
        systemColors[2] = -16777216;
        systemColors[5] = -16777216;
        systemColors[13] = -16777216;
        systemColors[14] = -16777216;
        systemColors[15] = -3881788;
        systemColors[18] = -16777216;
        systemColors[8] = -3881788;
        systemColors[10] = -3881788;
        systemColors[23] = -3881788;
        systemColors[17] = -2105377;
        int r = 196;
        int g = 196;
        int b = 196;
        int top_shadow = MotifColorUtilities.calculateTopShadowFromBackground(r, g, b);
        int bottom_shadow = MotifColorUtilities.calculateBottomShadowFromBackground(r, g, b);
        Color tmp = new Color(top_shadow);
        systemColors[19] = top_shadow;
        systemColors[20] = tmp.brighter().getRGB();
        tmp = new Color(bottom_shadow);
        systemColors[21] = bottom_shadow;
        systemColors[22] = tmp.darker().getRGB();
    }

    static void loadSystemColors(int[] systemColors) {
        if ("Linux".equals(AccessController.doPrivileged(new GetPropertyAction("os.name")))) {
            MotifColorUtilities.loadMotifDefaultColors(systemColors);
        } else {
            try {
                MotifColorUtilities.loadSystemColorsForCDE(systemColors);
            }
            catch (Exception e) {
                MotifColorUtilities.loadMotifDefaultColors(systemColors);
            }
        }
    }
}

