/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import com.sun.beans.TypeResolver;
import com.sun.beans.WeakCache;
import com.sun.beans.finder.ClassFinder;
import java.awt.Component;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.Customizer;
import java.beans.EventSetDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.GenericBeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.NameGenerator;
import java.beans.PropertyDescriptor;
import java.beans.PropertyVetoException;
import java.beans.ThreadGroupContext;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TooManyListenersException;
import java.util.TreeMap;
import sun.reflect.misc.ReflectUtil;

public class Introspector {
    public static final int USE_ALL_BEANINFO = 1;
    public static final int IGNORE_IMMEDIATE_BEANINFO = 2;
    public static final int IGNORE_ALL_BEANINFO = 3;
    private static final WeakCache<Class<?>, Method[]> declaredMethodCache = new WeakCache();
    private Class beanClass;
    private BeanInfo explicitBeanInfo;
    private BeanInfo superBeanInfo;
    private BeanInfo[] additionalBeanInfo;
    private boolean propertyChangeSource = false;
    private static Class eventListenerType = EventListener.class;
    private String defaultEventName;
    private String defaultPropertyName;
    private int defaultEventIndex = -1;
    private int defaultPropertyIndex = -1;
    private Map methods;
    private Map properties;
    private Map events;
    private static final EventSetDescriptor[] EMPTY_EVENTSETDESCRIPTORS = new EventSetDescriptor[0];
    static final String ADD_PREFIX = "add";
    static final String REMOVE_PREFIX = "remove";
    static final String GET_PREFIX = "get";
    static final String SET_PREFIX = "set";
    static final String IS_PREFIX = "is";
    private HashMap pdStore = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanInfo getBeanInfo(Class<?> beanClass) throws IntrospectionException {
        BeanInfo beanInfo;
        if (!ReflectUtil.isPackageAccessible(beanClass)) {
            return new Introspector(beanClass, null, 1).getBeanInfo();
        }
        ThreadGroupContext context = ThreadGroupContext.getContext();
        WeakCache<Class<?>, Method[]> weakCache = declaredMethodCache;
        synchronized (weakCache) {
            beanInfo = context.getBeanInfo(beanClass);
        }
        if (beanInfo == null) {
            beanInfo = new Introspector(beanClass, null, 1).getBeanInfo();
            weakCache = declaredMethodCache;
            synchronized (weakCache) {
                context.putBeanInfo(beanClass, beanInfo);
            }
        }
        return beanInfo;
    }

    public static BeanInfo getBeanInfo(Class<?> beanClass, int flags) throws IntrospectionException {
        return Introspector.getBeanInfo(beanClass, null, flags);
    }

    public static BeanInfo getBeanInfo(Class<?> beanClass, Class<?> stopClass) throws IntrospectionException {
        return Introspector.getBeanInfo(beanClass, stopClass, 1);
    }

    public static BeanInfo getBeanInfo(Class<?> beanClass, Class<?> stopClass, int flags) throws IntrospectionException {
        BeanInfo bi = stopClass == null && flags == 1 ? Introspector.getBeanInfo(beanClass) : new Introspector(beanClass, stopClass, flags).getBeanInfo();
        return bi;
    }

    public static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static String[] getBeanInfoSearchPath() {
        return ThreadGroupContext.getContext().getBeanInfoFinder().getPackages();
    }

    public static void setBeanInfoSearchPath(String[] path) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertiesAccess();
        }
        ThreadGroupContext.getContext().getBeanInfoFinder().setPackages(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushCaches() {
        WeakCache<Class<?>, Method[]> weakCache = declaredMethodCache;
        synchronized (weakCache) {
            ThreadGroupContext.getContext().clearBeanInfoCache();
            declaredMethodCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushFromCaches(Class<?> clz) {
        if (clz == null) {
            throw new NullPointerException();
        }
        WeakCache<Class<?>, Method[]> weakCache = declaredMethodCache;
        synchronized (weakCache) {
            ThreadGroupContext.getContext().removeBeanInfo(clz);
            declaredMethodCache.put(clz, null);
        }
    }

    private Introspector(Class beanClass, Class stopClass, int flags) throws IntrospectionException {
        Class superClass;
        this.beanClass = beanClass;
        if (stopClass != null) {
            boolean isSuper = false;
            for (Class c = beanClass.getSuperclass(); c != null; c = c.getSuperclass()) {
                if (c != stopClass) continue;
                isSuper = true;
            }
            if (!isSuper) {
                throw new IntrospectionException(stopClass.getName() + " not superclass of " + beanClass.getName());
            }
        }
        if (flags == 1) {
            this.explicitBeanInfo = Introspector.findExplicitBeanInfo(beanClass);
        }
        if ((superClass = beanClass.getSuperclass()) != stopClass) {
            int newFlags = flags;
            if (newFlags == 2) {
                newFlags = 1;
            }
            this.superBeanInfo = Introspector.getBeanInfo(superClass, stopClass, newFlags);
        }
        if (this.explicitBeanInfo != null) {
            this.additionalBeanInfo = this.explicitBeanInfo.getAdditionalBeanInfo();
        }
        if (this.additionalBeanInfo == null) {
            this.additionalBeanInfo = new BeanInfo[0];
        }
    }

    private BeanInfo getBeanInfo() throws IntrospectionException {
        BeanDescriptor bd = this.getTargetBeanDescriptor();
        MethodDescriptor[] mds = this.getTargetMethodInfo();
        EventSetDescriptor[] esds = this.getTargetEventInfo();
        PropertyDescriptor[] pds = this.getTargetPropertyInfo();
        int defaultEvent = this.getTargetDefaultEventIndex();
        int defaultProperty = this.getTargetDefaultPropertyIndex();
        return new GenericBeanInfo(bd, esds, defaultEvent, pds, defaultProperty, mds, this.explicitBeanInfo);
    }

    private static BeanInfo findExplicitBeanInfo(Class beanClass) {
        return (BeanInfo)ThreadGroupContext.getContext().getBeanInfoFinder().find(beanClass);
    }

    private PropertyDescriptor[] getTargetPropertyInfo() {
        int i;
        PropertyDescriptor[] explicitProperties = null;
        if (this.explicitBeanInfo != null) {
            explicitProperties = this.getPropertyDescriptors(this.explicitBeanInfo);
        }
        if (explicitProperties == null && this.superBeanInfo != null) {
            this.addPropertyDescriptors(this.getPropertyDescriptors(this.superBeanInfo));
        }
        for (int i2 = 0; i2 < this.additionalBeanInfo.length; ++i2) {
            this.addPropertyDescriptors(this.additionalBeanInfo[i2].getPropertyDescriptors());
        }
        if (explicitProperties != null) {
            this.addPropertyDescriptors(explicitProperties);
        } else {
            Method[] methodList = Introspector.getPublicDeclaredMethods(this.beanClass);
            for (i = 0; i < methodList.length; ++i) {
                int mods;
                Method method = methodList[i];
                if (method == null || Modifier.isStatic(mods = method.getModifiers())) continue;
                String name = method.getName();
                Class<?>[] argTypes = method.getParameterTypes();
                Class<?> resultType = method.getReturnType();
                int argCount = argTypes.length;
                PropertyDescriptor pd = null;
                if (name.length() <= 3 && !name.startsWith(IS_PREFIX)) continue;
                try {
                    if (argCount == 0) {
                        if (name.startsWith(GET_PREFIX)) {
                            pd = new PropertyDescriptor(this.beanClass, name.substring(3), method, null);
                        } else if (resultType == Boolean.TYPE && name.startsWith(IS_PREFIX)) {
                            pd = new PropertyDescriptor(this.beanClass, name.substring(2), method, null);
                        }
                    } else if (argCount == 1) {
                        if (Integer.TYPE.equals(argTypes[0]) && name.startsWith(GET_PREFIX)) {
                            pd = new IndexedPropertyDescriptor(this.beanClass, name.substring(3), null, null, method, null);
                        } else if (Void.TYPE.equals(resultType) && name.startsWith(SET_PREFIX)) {
                            pd = new PropertyDescriptor(this.beanClass, name.substring(3), null, method);
                            if (this.throwsException(method, PropertyVetoException.class)) {
                                pd.setConstrained(true);
                            }
                        }
                    } else if (argCount == 2 && Void.TYPE.equals(resultType) && Integer.TYPE.equals(argTypes[0]) && name.startsWith(SET_PREFIX)) {
                        pd = new IndexedPropertyDescriptor(this.beanClass, name.substring(3), null, null, null, method);
                        if (this.throwsException(method, PropertyVetoException.class)) {
                            pd.setConstrained(true);
                        }
                    }
                }
                catch (IntrospectionException ex) {
                    pd = null;
                }
                if (pd == null) continue;
                if (this.propertyChangeSource) {
                    pd.setBound(true);
                }
                this.addPropertyDescriptor(pd);
            }
        }
        this.processPropertyDescriptors();
        PropertyDescriptor[] result = new PropertyDescriptor[this.properties.size()];
        result = this.properties.values().toArray(result);
        if (this.defaultPropertyName != null) {
            for (i = 0; i < result.length; ++i) {
                if (!this.defaultPropertyName.equals(result[i].getName())) continue;
                this.defaultPropertyIndex = i;
            }
        }
        return result;
    }

    private void addPropertyDescriptor(PropertyDescriptor pd) {
        String propName = pd.getName();
        ArrayList<PropertyDescriptor> list = (ArrayList<PropertyDescriptor>)this.pdStore.get(propName);
        if (list == null) {
            list = new ArrayList<PropertyDescriptor>();
            this.pdStore.put(propName, list);
        }
        if (this.beanClass != pd.getClass0()) {
            Method read = pd.getReadMethod();
            Method write = pd.getWriteMethod();
            boolean cls = true;
            if (read != null) {
                boolean bl = cls = cls && read.getGenericReturnType() instanceof Class;
            }
            if (write != null) {
                boolean bl = cls = cls && write.getGenericParameterTypes()[0] instanceof Class;
            }
            if (pd instanceof IndexedPropertyDescriptor) {
                IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)pd;
                Method readI = ipd.getIndexedReadMethod();
                Method writeI = ipd.getIndexedWriteMethod();
                if (readI != null) {
                    boolean bl = cls = cls && readI.getGenericReturnType() instanceof Class;
                }
                if (writeI != null) {
                    boolean bl = cls = cls && writeI.getGenericParameterTypes()[1] instanceof Class;
                }
                if (!cls) {
                    pd = new IndexedPropertyDescriptor(ipd);
                    pd.updateGenericsFor(this.beanClass);
                }
            } else if (!cls) {
                pd = new PropertyDescriptor(pd);
                pd.updateGenericsFor(this.beanClass);
            }
        }
        list.add(pd);
    }

    private void addPropertyDescriptors(PropertyDescriptor[] descriptors) {
        if (descriptors != null) {
            for (PropertyDescriptor descriptor : descriptors) {
                this.addPropertyDescriptor(descriptor);
            }
        }
    }

    private PropertyDescriptor[] getPropertyDescriptors(BeanInfo info) {
        PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
        int index = info.getDefaultPropertyIndex();
        if (0 <= index && index < descriptors.length) {
            this.defaultPropertyName = descriptors[index].getName();
        }
        return descriptors;
    }

    private void processPropertyDescriptors() {
        if (this.properties == null) {
            this.properties = new TreeMap();
        }
        Iterator it = this.pdStore.values().iterator();
        while (it.hasNext()) {
            int i;
            PropertyDescriptor pd = null;
            PropertyDescriptor gpd = null;
            PropertyDescriptor spd = null;
            IndexedPropertyDescriptor ipd = null;
            IndexedPropertyDescriptor igpd = null;
            IndexedPropertyDescriptor ispd = null;
            List list = (List)it.next();
            for (i = 0; i < list.size(); ++i) {
                pd = (PropertyDescriptor)list.get(i);
                if (pd instanceof IndexedPropertyDescriptor) {
                    ipd = (IndexedPropertyDescriptor)pd;
                    if (ipd.getIndexedReadMethod() == null) continue;
                    if (igpd != null) {
                        igpd = new IndexedPropertyDescriptor(igpd, ipd);
                        continue;
                    }
                    igpd = ipd;
                    continue;
                }
                if (pd.getReadMethod() == null) continue;
                if (gpd != null) {
                    Method method = gpd.getReadMethod();
                    if (method.getName().startsWith(IS_PREFIX)) continue;
                    gpd = new PropertyDescriptor(gpd, pd);
                    continue;
                }
                gpd = pd;
            }
            for (i = 0; i < list.size(); ++i) {
                pd = (PropertyDescriptor)list.get(i);
                if (pd instanceof IndexedPropertyDescriptor) {
                    ipd = (IndexedPropertyDescriptor)pd;
                    if (ipd.getIndexedWriteMethod() == null) continue;
                    if (igpd != null) {
                        if (igpd.getIndexedPropertyType() != ipd.getIndexedPropertyType()) continue;
                        if (ispd != null) {
                            ispd = new IndexedPropertyDescriptor(ispd, ipd);
                            continue;
                        }
                        ispd = ipd;
                        continue;
                    }
                    if (ispd != null) {
                        ispd = new IndexedPropertyDescriptor(ispd, ipd);
                        continue;
                    }
                    ispd = ipd;
                    continue;
                }
                if (pd.getWriteMethod() == null) continue;
                if (gpd != null) {
                    if (gpd.getPropertyType() != pd.getPropertyType()) continue;
                    if (spd != null) {
                        spd = new PropertyDescriptor(spd, pd);
                        continue;
                    }
                    spd = pd;
                    continue;
                }
                spd = spd != null ? new PropertyDescriptor(spd, pd) : pd;
            }
            pd = null;
            ipd = null;
            if (igpd != null && ispd != null) {
                PropertyDescriptor tpd;
                if (gpd != null && (tpd = this.mergePropertyDescriptor(igpd, gpd)) instanceof IndexedPropertyDescriptor) {
                    igpd = (IndexedPropertyDescriptor)tpd;
                }
                if (spd != null && (tpd = this.mergePropertyDescriptor(ispd, spd)) instanceof IndexedPropertyDescriptor) {
                    ispd = (IndexedPropertyDescriptor)tpd;
                }
                pd = igpd == ispd ? igpd : this.mergePropertyDescriptor(igpd, ispd);
            } else if (gpd != null && spd != null) {
                pd = gpd == spd ? gpd : this.mergePropertyDescriptor(gpd, spd);
            } else if (ispd != null) {
                pd = ispd;
                if (spd != null) {
                    pd = this.mergePropertyDescriptor(ispd, spd);
                }
                if (gpd != null) {
                    pd = this.mergePropertyDescriptor(ispd, gpd);
                }
            } else if (igpd != null) {
                pd = igpd;
                if (gpd != null) {
                    pd = this.mergePropertyDescriptor(igpd, gpd);
                }
                if (spd != null) {
                    pd = this.mergePropertyDescriptor(igpd, spd);
                }
            } else if (spd != null) {
                pd = spd;
            } else if (gpd != null) {
                pd = gpd;
            }
            if (pd instanceof IndexedPropertyDescriptor && (ipd = (IndexedPropertyDescriptor)pd).getIndexedReadMethod() == null && ipd.getIndexedWriteMethod() == null) {
                pd = new PropertyDescriptor(ipd);
            }
            if (pd == null && list.size() > 0) {
                pd = (PropertyDescriptor)list.get(0);
            }
            if (pd == null) continue;
            this.properties.put(pd.getName(), pd);
        }
    }

    private PropertyDescriptor mergePropertyDescriptor(IndexedPropertyDescriptor ipd, PropertyDescriptor pd) {
        PropertyDescriptor result = null;
        Class<?> propType = pd.getPropertyType();
        Class<?> ipropType = ipd.getIndexedPropertyType();
        if (propType.isArray() && propType.getComponentType() == ipropType) {
            result = pd.getClass0().isAssignableFrom(ipd.getClass0()) ? new IndexedPropertyDescriptor(pd, ipd) : new IndexedPropertyDescriptor(ipd, pd);
        } else if (pd.getClass0().isAssignableFrom(ipd.getClass0())) {
            result = ipd;
        } else {
            result = pd;
            Method write = result.getWriteMethod();
            Method read = result.getReadMethod();
            if (read == null && write != null && (read = Introspector.findMethod(result.getClass0(), GET_PREFIX + NameGenerator.capitalize(result.getName()), 0)) != null) {
                try {
                    result.setReadMethod(read);
                }
                catch (IntrospectionException introspectionException) {
                    // empty catch block
                }
            }
            if (write == null && read != null && (write = Introspector.findMethod(result.getClass0(), SET_PREFIX + NameGenerator.capitalize(result.getName()), 1, new Class[]{FeatureDescriptor.getReturnType(result.getClass0(), read)})) != null) {
                try {
                    result.setWriteMethod(write);
                }
                catch (IntrospectionException introspectionException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private PropertyDescriptor mergePropertyDescriptor(PropertyDescriptor pd1, PropertyDescriptor pd2) {
        if (pd1.getClass0().isAssignableFrom(pd2.getClass0())) {
            return new PropertyDescriptor(pd1, pd2);
        }
        return new PropertyDescriptor(pd2, pd1);
    }

    private PropertyDescriptor mergePropertyDescriptor(IndexedPropertyDescriptor ipd1, IndexedPropertyDescriptor ipd2) {
        if (ipd1.getClass0().isAssignableFrom(ipd2.getClass0())) {
            return new IndexedPropertyDescriptor(ipd1, ipd2);
        }
        return new IndexedPropertyDescriptor(ipd2, ipd1);
    }

    private EventSetDescriptor[] getTargetEventInfo() throws IntrospectionException {
        EventSetDescriptor[] result;
        int i;
        if (this.events == null) {
            this.events = new HashMap();
        }
        EventSetDescriptor[] explicitEvents = null;
        if (this.explicitBeanInfo != null) {
            explicitEvents = this.explicitBeanInfo.getEventSetDescriptors();
            int ix = this.explicitBeanInfo.getDefaultEventIndex();
            if (ix >= 0 && ix < explicitEvents.length) {
                this.defaultEventName = explicitEvents[ix].getName();
            }
        }
        if (explicitEvents == null && this.superBeanInfo != null) {
            EventSetDescriptor[] supers = this.superBeanInfo.getEventSetDescriptors();
            for (int i2 = 0; i2 < supers.length; ++i2) {
                this.addEvent(supers[i2]);
            }
            int ix = this.superBeanInfo.getDefaultEventIndex();
            if (ix >= 0 && ix < supers.length) {
                this.defaultEventName = supers[ix].getName();
            }
        }
        for (i = 0; i < this.additionalBeanInfo.length; ++i) {
            EventSetDescriptor[] additional = this.additionalBeanInfo[i].getEventSetDescriptors();
            if (additional == null) continue;
            for (int j = 0; j < additional.length; ++j) {
                this.addEvent(additional[j]);
            }
        }
        if (explicitEvents != null) {
            for (i = 0; i < explicitEvents.length; ++i) {
                this.addEvent(explicitEvents[i]);
            }
        } else {
            Method[] methodList = Introspector.getPublicDeclaredMethods(this.beanClass);
            HashMap<String, Method> adds = null;
            HashMap<String, Method> removes = null;
            HashMap<String, Method> gets = null;
            for (int i3 = 0; i3 < methodList.length; ++i3) {
                Class returnType;
                Class<?>[] parameterTypes;
                String listenerName;
                Class<?> type;
                Type[] parameterTypes2;
                Class<?> returnType2;
                String name;
                int mods;
                Method method = methodList[i3];
                if (method == null || Modifier.isStatic(mods = method.getModifiers()) || !(name = method.getName()).startsWith(ADD_PREFIX) && !name.startsWith(REMOVE_PREFIX) && !name.startsWith(GET_PREFIX)) continue;
                if (name.startsWith(ADD_PREFIX)) {
                    returnType2 = method.getReturnType();
                    if (returnType2 != Void.TYPE || (parameterTypes2 = method.getGenericParameterTypes()).length != 1 || !Introspector.isSubclass(type = TypeResolver.erase(TypeResolver.resolveInClass(this.beanClass, parameterTypes2[0])), eventListenerType) || (listenerName = name.substring(3)).length() <= 0 || !type.getName().endsWith(listenerName)) continue;
                    if (adds == null) {
                        adds = new HashMap<String, Method>();
                    }
                    adds.put(listenerName, method);
                    continue;
                }
                if (name.startsWith(REMOVE_PREFIX)) {
                    returnType2 = method.getReturnType();
                    if (returnType2 != Void.TYPE || (parameterTypes2 = method.getGenericParameterTypes()).length != 1 || !Introspector.isSubclass(type = TypeResolver.erase(TypeResolver.resolveInClass(this.beanClass, parameterTypes2[0])), eventListenerType) || (listenerName = name.substring(6)).length() <= 0 || !type.getName().endsWith(listenerName)) continue;
                    if (removes == null) {
                        removes = new HashMap<String, Method>();
                    }
                    removes.put(listenerName, method);
                    continue;
                }
                if (!name.startsWith(GET_PREFIX) || (parameterTypes = method.getParameterTypes()).length != 0 || !(returnType = FeatureDescriptor.getReturnType(this.beanClass, method)).isArray() || !Introspector.isSubclass(type = returnType.getComponentType(), eventListenerType) || (listenerName = name.substring(3, name.length() - 1)).length() <= 0 || !type.getName().endsWith(listenerName)) continue;
                if (gets == null) {
                    gets = new HashMap<String, Method>();
                }
                gets.put(listenerName, method);
            }
            if (adds != null && removes != null) {
                for (String listenerName : adds.keySet()) {
                    if (removes.get(listenerName) == null || !listenerName.endsWith("Listener")) continue;
                    String eventName = Introspector.decapitalize(listenerName.substring(0, listenerName.length() - 8));
                    Method addMethod = (Method)adds.get(listenerName);
                    Method removeMethod = (Method)removes.get(listenerName);
                    Method getMethod = null;
                    if (gets != null) {
                        getMethod = (Method)gets.get(listenerName);
                    }
                    Class argType = FeatureDescriptor.getParameterTypes(this.beanClass, addMethod)[0];
                    Method[] allMethods = Introspector.getPublicDeclaredMethods(argType);
                    ArrayList<Method> validMethods = new ArrayList<Method>(allMethods.length);
                    for (int i4 = 0; i4 < allMethods.length; ++i4) {
                        if (allMethods[i4] == null || !this.isEventHandler(allMethods[i4])) continue;
                        validMethods.add(allMethods[i4]);
                    }
                    Method[] methods = validMethods.toArray(new Method[validMethods.size()]);
                    EventSetDescriptor esd = new EventSetDescriptor(eventName, argType, methods, addMethod, removeMethod, getMethod);
                    if (this.throwsException(addMethod, TooManyListenersException.class)) {
                        esd.setUnicast(true);
                    }
                    this.addEvent(esd);
                }
            }
        }
        if (this.events.size() == 0) {
            result = EMPTY_EVENTSETDESCRIPTORS;
        } else {
            result = new EventSetDescriptor[this.events.size()];
            result = this.events.values().toArray(result);
            if (this.defaultEventName != null) {
                for (int i5 = 0; i5 < result.length; ++i5) {
                    if (!this.defaultEventName.equals(result[i5].getName())) continue;
                    this.defaultEventIndex = i5;
                }
            }
        }
        return result;
    }

    private void addEvent(EventSetDescriptor esd) {
        EventSetDescriptor old;
        String key = esd.getName();
        if (esd.getName().equals("propertyChange")) {
            this.propertyChangeSource = true;
        }
        if ((old = (EventSetDescriptor)this.events.get(key)) == null) {
            this.events.put(key, esd);
            return;
        }
        EventSetDescriptor composite = new EventSetDescriptor(old, esd);
        this.events.put(key, composite);
    }

    private MethodDescriptor[] getTargetMethodInfo() {
        int i;
        int i2;
        if (this.methods == null) {
            this.methods = new HashMap(100);
        }
        MethodDescriptor[] explicitMethods = null;
        if (this.explicitBeanInfo != null) {
            explicitMethods = this.explicitBeanInfo.getMethodDescriptors();
        }
        if (explicitMethods == null && this.superBeanInfo != null) {
            MethodDescriptor[] supers = this.superBeanInfo.getMethodDescriptors();
            for (i2 = 0; i2 < supers.length; ++i2) {
                this.addMethod(supers[i2]);
            }
        }
        for (i = 0; i < this.additionalBeanInfo.length; ++i) {
            MethodDescriptor[] additional = this.additionalBeanInfo[i].getMethodDescriptors();
            if (additional == null) continue;
            for (int j = 0; j < additional.length; ++j) {
                this.addMethod(additional[j]);
            }
        }
        if (explicitMethods != null) {
            for (i = 0; i < explicitMethods.length; ++i) {
                this.addMethod(explicitMethods[i]);
            }
        } else {
            Method[] methodList = Introspector.getPublicDeclaredMethods(this.beanClass);
            for (i2 = 0; i2 < methodList.length; ++i2) {
                Method method = methodList[i2];
                if (method == null) continue;
                MethodDescriptor md = new MethodDescriptor(method);
                this.addMethod(md);
            }
        }
        MethodDescriptor[] result = new MethodDescriptor[this.methods.size()];
        result = this.methods.values().toArray(result);
        return result;
    }

    private void addMethod(MethodDescriptor md) {
        String name = md.getName();
        MethodDescriptor old = (MethodDescriptor)this.methods.get(name);
        if (old == null) {
            this.methods.put(name, md);
            return;
        }
        String[] p1 = md.getParamNames();
        String[] p2 = old.getParamNames();
        boolean match = false;
        if (p1.length == p2.length) {
            match = true;
            for (int i = 0; i < p1.length; ++i) {
                if (p1[i] == p2[i]) continue;
                match = false;
                break;
            }
        }
        if (match) {
            MethodDescriptor composite = new MethodDescriptor(old, md);
            this.methods.put(name, composite);
            return;
        }
        String longKey = Introspector.makeQualifiedMethodName(name, p1);
        old = (MethodDescriptor)this.methods.get(longKey);
        if (old == null) {
            this.methods.put(longKey, md);
            return;
        }
        MethodDescriptor composite = new MethodDescriptor(old, md);
        this.methods.put(longKey, composite);
    }

    private static String makeQualifiedMethodName(String name, String[] params) {
        StringBuffer sb = new StringBuffer(name);
        sb.append('=');
        for (int i = 0; i < params.length; ++i) {
            sb.append(':');
            sb.append(params[i]);
        }
        return sb.toString();
    }

    private int getTargetDefaultEventIndex() {
        return this.defaultEventIndex;
    }

    private int getTargetDefaultPropertyIndex() {
        return this.defaultPropertyIndex;
    }

    private BeanDescriptor getTargetBeanDescriptor() {
        BeanDescriptor bd;
        if (this.explicitBeanInfo != null && (bd = this.explicitBeanInfo.getBeanDescriptor()) != null) {
            return bd;
        }
        return new BeanDescriptor(this.beanClass, Introspector.findCustomizerClass(this.beanClass));
    }

    private static Class<?> findCustomizerClass(Class<?> type) {
        String name = type.getName() + "Customizer";
        try {
            type = ClassFinder.findClass(name, type.getClassLoader());
            if (Component.class.isAssignableFrom(type) && Customizer.class.isAssignableFrom(type)) {
                return type;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean isEventHandler(Method m) {
        Type[] argTypes = m.getGenericParameterTypes();
        if (argTypes.length != 1) {
            return false;
        }
        return Introspector.isSubclass(TypeResolver.erase(TypeResolver.resolveInClass(this.beanClass, argTypes[0])), EventObject.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Method[] getPublicDeclaredMethods(Class clz) {
        if (!ReflectUtil.isPackageAccessible(clz)) {
            return new Method[0];
        }
        WeakCache<Class<?>, Method[]> weakCache = declaredMethodCache;
        synchronized (weakCache) {
            Method[] result = declaredMethodCache.get(clz);
            if (result == null) {
                result = clz.getMethods();
                for (int i = 0; i < result.length; ++i) {
                    Method method = result[i];
                    if (method.getDeclaringClass().equals(clz)) continue;
                    result[i] = null;
                }
                declaredMethodCache.put(clz, result);
            }
            return result;
        }
    }

    private static Method internalFindMethod(Class start, String methodName, int argCount, Class[] args) {
        Method method = null;
        for (Class cl = start; cl != null; cl = cl.getSuperclass()) {
            Method[] methods = Introspector.getPublicDeclaredMethods(cl);
            for (int i = 0; i < methods.length; ++i) {
                Type[] params;
                method = methods[i];
                if (method == null || !method.getName().equals(methodName) || (params = method.getGenericParameterTypes()).length != argCount) continue;
                if (args != null) {
                    boolean different = false;
                    if (argCount > 0) {
                        for (int j = 0; j < argCount; ++j) {
                            if (TypeResolver.erase(TypeResolver.resolveInClass(start, params[j])) == args[j]) continue;
                            different = true;
                        }
                        if (different) continue;
                    }
                }
                return method;
            }
        }
        method = null;
        Class<?>[] ifcs = start.getInterfaces();
        for (int i = 0; i < ifcs.length && (method = Introspector.internalFindMethod(ifcs[i], methodName, argCount, null)) == null; ++i) {
        }
        return method;
    }

    static Method findMethod(Class cls, String methodName, int argCount) {
        return Introspector.findMethod(cls, methodName, argCount, null);
    }

    static Method findMethod(Class cls, String methodName, int argCount, Class[] args) {
        if (methodName == null) {
            return null;
        }
        return Introspector.internalFindMethod(cls, methodName, argCount, args);
    }

    static boolean isSubclass(Class a, Class b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        for (Class x = a; x != null; x = x.getSuperclass()) {
            if (x == b) {
                return true;
            }
            if (!b.isInterface()) continue;
            Class<?>[] interfaces = x.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!Introspector.isSubclass(interfaces[i], b)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean throwsException(Method method, Class exception) {
        Class<?>[] exs = method.getExceptionTypes();
        for (int i = 0; i < exs.length; ++i) {
            if (exs[i] != exception) continue;
            return true;
        }
        return false;
    }

    static Object instantiate(Class sibling, String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ClassLoader cl = sibling.getClassLoader();
        Class<?> cls = ClassFinder.findClass(className, cl);
        return cls.newInstance();
    }
}

