/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import com.sun.nio.sctp.IllegalUnbindException;
import com.sun.nio.sctp.SctpChannel;
import com.sun.nio.sctp.SctpServerChannel;
import com.sun.nio.sctp.SctpSocketOption;
import com.sun.nio.sctp.SctpStandardSocketOptions;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.SctpChannelImpl;
import sun.nio.ch.SctpNet;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.security.action.LoadLibraryAction;

public class SctpServerChannelImpl
extends SctpServerChannel
implements SelChImpl {
    private final FileDescriptor fd;
    private final int fdVal;
    private volatile long thread = 0L;
    private final Object lock = new Object();
    private final Object stateLock = new Object();
    private ChannelState state = ChannelState.UNINITIALIZED;
    int port = -1;
    private HashSet<InetSocketAddress> localAddresses = new HashSet();
    private boolean wildcard;

    public SctpServerChannelImpl(SelectorProvider provider) throws IOException {
        super(provider);
        this.fd = SctpNet.socket(true);
        this.fdVal = IOUtil.fdVal(this.fd);
        this.state = ChannelState.INUSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SctpServerChannel bind(SocketAddress local, int backlog) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            Object object2 = this.stateLock;
            synchronized (object2) {
                if (!this.isOpen()) {
                    throw new ClosedChannelException();
                }
                if (this.isBound()) {
                    SctpNet.throwAlreadyBoundException();
                }
                InetSocketAddress isa = local == null ? new InetSocketAddress(0) : Net.checkAddress(local);
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkListen(isa.getPort());
                }
                Net.bind(this.fd, isa.getAddress(), isa.getPort());
                InetSocketAddress boundIsa = Net.localAddress(this.fd);
                this.port = boundIsa.getPort();
                this.localAddresses.add(isa);
                if (isa.getAddress().isAnyLocalAddress()) {
                    this.wildcard = true;
                }
                SctpNet.listen(this.fdVal, backlog < 1 ? 50 : backlog);
            }
        }
        return this;
    }

    @Override
    public SctpServerChannel bindAddress(InetAddress address) throws IOException {
        return this.bindUnbindAddress(address, true);
    }

    @Override
    public SctpServerChannel unbindAddress(InetAddress address) throws IOException {
        return this.bindUnbindAddress(address, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SctpServerChannel bindUnbindAddress(InetAddress address, boolean add) throws IOException {
        if (address == null) {
            throw new IllegalArgumentException();
        }
        Object object = this.lock;
        synchronized (object) {
            Object object2 = this.stateLock;
            synchronized (object2) {
                if (!this.isOpen()) {
                    throw new ClosedChannelException();
                }
                if (!this.isBound()) {
                    throw new NotYetBoundException();
                }
                if (this.wildcard) {
                    throw new IllegalStateException("Cannot add or remove addresses from a channel that is bound to the wildcard address");
                }
                if (address.isAnyLocalAddress()) {
                    throw new IllegalArgumentException("Cannot add or remove the wildcard address");
                }
                if (add) {
                    for (InetSocketAddress addr : this.localAddresses) {
                        if (!addr.getAddress().equals(address)) continue;
                        SctpNet.throwAlreadyBoundException();
                    }
                } else {
                    if (this.localAddresses.size() <= 1) {
                        throw new IllegalUnbindException("Cannot remove address from a channel with only one address bound");
                    }
                    boolean foundAddress = false;
                    for (InetSocketAddress addr : this.localAddresses) {
                        if (!addr.getAddress().equals(address)) continue;
                        foundAddress = true;
                        break;
                    }
                    if (!foundAddress) {
                        throw new IllegalUnbindException("Cannot remove address from a channel that is not bound to that address");
                    }
                }
                SctpNet.bindx(this.fdVal, new InetAddress[]{address}, this.port, add);
                if (add) {
                    this.localAddresses.add(new InetSocketAddress(address, this.port));
                } else {
                    for (InetSocketAddress addr : this.localAddresses) {
                        if (!addr.getAddress().equals(address)) continue;
                        this.localAddresses.remove(addr);
                        break;
                    }
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBound() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.port != -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptCleanup() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.thread = 0L;
            if (this.state == ChannelState.KILLPENDING) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SctpChannel accept() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            InetSocketAddress[] isaa;
            FileDescriptor newfd;
            int n;
            SctpChannelImpl sc;
            block13: {
                if (!this.isOpen()) {
                    throw new ClosedChannelException();
                }
                if (!this.isBound()) {
                    throw new NotYetBoundException();
                }
                sc = null;
                n = 0;
                newfd = new FileDescriptor();
                isaa = new InetSocketAddress[1];
                this.begin();
                if (this.isOpen()) break block13;
                SctpChannel sctpChannel = null;
                this.acceptCleanup();
                this.end(n > 0);
                assert (IOStatus.check(n));
                return sctpChannel;
            }
            try {
                this.thread = NativeThread.current();
                while ((n = SctpServerChannelImpl.accept0(this.fd, newfd, isaa)) == -3 && this.isOpen()) {
                }
            }
            catch (Throwable throwable) {
                this.acceptCleanup();
                this.end(n > 0);
                assert (IOStatus.check(n));
                throw throwable;
            }
            this.acceptCleanup();
            this.end(n > 0);
            assert (IOStatus.check(n));
            if (n < 1) {
                return null;
            }
            IOUtil.configureBlocking(newfd, true);
            InetSocketAddress isa = isaa[0];
            sc = new SctpChannelImpl(this.provider(), newfd);
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkAccept(isa.getAddress().getHostAddress(), isa.getPort());
            }
            return sc;
        }
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        IOUtil.configureBlocking(this.fd, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void implCloseSelectableChannel() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            SctpNet.preClose(this.fdVal);
            if (this.thread != 0L) {
                NativeThread.signal(this.thread);
            }
            if (!this.isRegistered()) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == ChannelState.KILLED) {
                return;
            }
            if (this.state == ChannelState.UNINITIALIZED) {
                this.state = ChannelState.KILLED;
                return;
            }
            assert (!this.isOpen() && !this.isRegistered());
            if (this.thread == 0L) {
                SctpNet.close(this.fdVal);
                this.state = ChannelState.KILLED;
            } else {
                this.state = ChannelState.KILLPENDING;
            }
        }
    }

    @Override
    public FileDescriptor getFD() {
        return this.fd;
    }

    @Override
    public int getFDVal() {
        return this.fdVal;
    }

    private boolean translateReadyOps(int ops, int initialOps, SelectionKeyImpl sk) {
        int intOps = sk.nioInterestOps();
        int oldOps = sk.nioReadyOps();
        int newOps = initialOps;
        if ((ops & 0x20) != 0) {
            return false;
        }
        if ((ops & 0x18) != 0) {
            newOps = intOps;
            sk.nioReadyOps(newOps);
            return (newOps & ~oldOps) != 0;
        }
        if ((ops & 1) != 0 && (intOps & 0x10) != 0) {
            newOps |= 0x10;
        }
        sk.nioReadyOps(newOps);
        return (newOps & ~oldOps) != 0;
    }

    @Override
    public boolean translateAndUpdateReadyOps(int ops, SelectionKeyImpl sk) {
        return this.translateReadyOps(ops, sk.nioReadyOps(), sk);
    }

    @Override
    public boolean translateAndSetReadyOps(int ops, SelectionKeyImpl sk) {
        return this.translateReadyOps(ops, 0, sk);
    }

    @Override
    public void translateAndSetInterestOps(int ops, SelectionKeyImpl sk) {
        int newOps = 0;
        if ((ops & 0x10) != 0) {
            newOps |= 1;
        }
        sk.selector.putEventOps(sk, newOps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> SctpServerChannel setOption(SctpSocketOption<T> name, T value) throws IOException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (!this.supportedOptions().contains(name)) {
            throw new UnsupportedOperationException("'" + name + "' not supported");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            SctpNet.setSocketOption(this.fdVal, name, value, 0);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getOption(SctpSocketOption<T> name) throws IOException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (!this.supportedOptions().contains(name)) {
            throw new UnsupportedOperationException("'" + name + "' not supported");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            return (T)SctpNet.getSocketOption(this.fdVal, name, 0);
        }
    }

    @Override
    public final Set<SctpSocketOption<?>> supportedOptions() {
        return DefaultOptionsHolder.defaultOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<SocketAddress> getAllLocalAddresses() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isBound()) {
                return Collections.EMPTY_SET;
            }
            return SctpNet.getLocalAddresses(this.fdVal);
        }
    }

    private static native void initIDs();

    private static native int accept0(FileDescriptor var0, FileDescriptor var1, InetSocketAddress[] var2) throws IOException;

    static {
        IOUtil.load();
        AccessController.doPrivileged(new LoadLibraryAction("javasctp"));
        SctpServerChannelImpl.initIDs();
    }

    private static class DefaultOptionsHolder {
        static final Set<SctpSocketOption<?>> defaultOptions = DefaultOptionsHolder.defaultOptions();

        private DefaultOptionsHolder() {
        }

        private static Set<SctpSocketOption<?>> defaultOptions() {
            HashSet<SctpSocketOption<SctpStandardSocketOptions.InitMaxStreams>> set = new HashSet<SctpSocketOption<SctpStandardSocketOptions.InitMaxStreams>>(1);
            set.add(SctpStandardSocketOptions.SCTP_INIT_MAXSTREAMS);
            return Collections.unmodifiableSet(set);
        }
    }

    private static enum ChannelState {
        UNINITIALIZED,
        INUSE,
        KILLPENDING,
        KILLED;

    }
}

