/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import sun.awt.X11.MotifDnDDragSourceProtocol;
import sun.awt.X11.MotifDnDDropTargetProtocol;
import sun.awt.X11.XDnDDragSourceProtocol;
import sun.awt.X11.XDnDDropTargetProtocol;
import sun.awt.X11.XDragSourceContextPeer;
import sun.awt.X11.XDragSourceProtocol;
import sun.awt.X11.XDragSourceProtocolListener;
import sun.awt.X11.XDropTargetContextPeer;
import sun.awt.X11.XDropTargetProtocol;
import sun.awt.X11.XDropTargetProtocolListener;

final class XDragAndDropProtocols {
    private static final List dragProtocols;
    private static final List dropProtocols;
    public static final String XDnD = "XDnD";
    public static final String MotifDnD = "MotifDnD";

    XDragAndDropProtocols() {
    }

    static Iterator getDragSourceProtocols() {
        return dragProtocols.iterator();
    }

    static Iterator getDropTargetProtocols() {
        return dropProtocols.iterator();
    }

    public static XDragSourceProtocol getDragSourceProtocol(String name) {
        if (name == null) {
            return null;
        }
        Iterator dragProtocols = XDragAndDropProtocols.getDragSourceProtocols();
        while (dragProtocols.hasNext()) {
            XDragSourceProtocol dragProtocol = (XDragSourceProtocol)dragProtocols.next();
            if (!dragProtocol.getProtocolName().equals(name)) continue;
            return dragProtocol;
        }
        return null;
    }

    public static XDropTargetProtocol getDropTargetProtocol(String name) {
        if (name == null) {
            return null;
        }
        Iterator dropProtocols = XDragAndDropProtocols.getDropTargetProtocols();
        while (dropProtocols.hasNext()) {
            XDropTargetProtocol dropProtocol = (XDropTargetProtocol)dropProtocols.next();
            if (!dropProtocol.getProtocolName().equals(name)) continue;
            return dropProtocol;
        }
        return null;
    }

    static {
        XDragSourceProtocolListener dragSourceProtocolListener = XDragSourceContextPeer.getXDragSourceProtocolListener();
        XDropTargetProtocolListener dropTargetProtocolListener = XDropTargetContextPeer.getXDropTargetProtocolListener();
        ArrayList<XDragSourceProtocol> tDragSourceProtocols = new ArrayList<XDragSourceProtocol>();
        XDragSourceProtocol xdndDragSourceProtocol = XDnDDragSourceProtocol.createInstance(dragSourceProtocolListener);
        tDragSourceProtocols.add(xdndDragSourceProtocol);
        XDragSourceProtocol motifdndDragSourceProtocol = MotifDnDDragSourceProtocol.createInstance(dragSourceProtocolListener);
        tDragSourceProtocols.add(motifdndDragSourceProtocol);
        ArrayList<XDropTargetProtocol> tDropTargetProtocols = new ArrayList<XDropTargetProtocol>();
        XDropTargetProtocol xdndDropTargetProtocol = XDnDDropTargetProtocol.createInstance(dropTargetProtocolListener);
        tDropTargetProtocols.add(xdndDropTargetProtocol);
        XDropTargetProtocol motifdndDropTargetProtocol = MotifDnDDropTargetProtocol.createInstance(dropTargetProtocolListener);
        tDropTargetProtocols.add(motifdndDropTargetProtocol);
        dragProtocols = Collections.unmodifiableList(tDragSourceProtocols);
        dropProtocols = Collections.unmodifiableList(tDropTargetProtocols);
    }
}

