/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XIMValuesList
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 16;
    }

    @Override
    public int getDataSize() {
        return XIMValuesList.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XIMValuesList(long addr) {
        log.finest("Creating");
        this.pData = addr;
        this.should_free_memory = false;
    }

    public XIMValuesList() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XIMValuesList.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public short get_count_values() {
        log.finest("");
        return Native.getShort(this.pData + 0L);
    }

    public void set_count_values(short v) {
        log.finest("");
        Native.putShort(this.pData + 0L, v);
    }

    public long get_supported_values(int index) {
        log.finest("");
        return Native.getLong(this.pData + 8L) + (long)(index * Native.getLongSize());
    }

    public long get_supported_values() {
        log.finest("");
        return Native.getLong(this.pData + 8L);
    }

    public void set_supported_values(long v) {
        log.finest("");
        Native.putLong(this.pData + 8L, v);
    }

    @Override
    String getName() {
        return "XIMValuesList";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder ret = new StringBuilder(80);
        ret.append("count_values = ").append(this.get_count_values()).append(", ");
        ret.append("supported_values = ").append(this.get_supported_values()).append(", ");
        return ret.toString();
    }
}

