/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import sun.security.jgss.GSSHeader;
import sun.security.jgss.krb5.CipherHelper;
import sun.security.jgss.krb5.Krb5Context;
import sun.security.jgss.krb5.MessageToken_v2;
import sun.security.krb5.Confounder;

class WrapToken_v2
extends MessageToken_v2 {
    byte[] confounder = null;
    private final boolean privacy;

    public WrapToken_v2(Krb5Context context, byte[] tokenBytes, int tokenOffset, int tokenLen, MessageProp prop) throws GSSException {
        super(1284, context, tokenBytes, tokenOffset, tokenLen, prop);
        this.privacy = prop.getPrivacy();
    }

    public WrapToken_v2(Krb5Context context, InputStream is, MessageProp prop) throws GSSException {
        super(1284, context, is, prop);
        this.privacy = prop.getPrivacy();
    }

    public byte[] getData() throws GSSException {
        byte[] temp = new byte[this.tokenDataLen];
        int len = this.getData(temp, 0);
        return Arrays.copyOf(temp, len);
    }

    public int getData(byte[] dataBuf, int dataBufOffset) throws GSSException {
        if (this.privacy) {
            this.cipherHelper.decryptData(this, this.tokenData, 0, this.tokenDataLen, dataBuf, dataBufOffset, this.getKeyUsage());
            return this.tokenDataLen - 16 - 16 - this.cipherHelper.getChecksumLength();
        }
        int data_length = this.tokenDataLen - this.cipherHelper.getChecksumLength();
        System.arraycopy(this.tokenData, 0, dataBuf, dataBufOffset, data_length);
        if (!this.verifySign(dataBuf, dataBufOffset, data_length)) {
            throw new GSSException(6, -1, "Corrupt checksum in Wrap token");
        }
        return data_length;
    }

    public WrapToken_v2(Krb5Context context, MessageProp prop, byte[] dataBytes, int dataOffset, int dataLen) throws GSSException {
        super(1284, context);
        this.confounder = Confounder.bytes(16);
        this.genSignAndSeqNumber(prop, dataBytes, dataOffset, dataLen);
        if (!context.getConfState()) {
            prop.setPrivacy(false);
        }
        this.privacy = prop.getPrivacy();
        if (!this.privacy) {
            this.tokenData = new byte[dataLen + this.checksum.length];
            System.arraycopy(dataBytes, dataOffset, this.tokenData, 0, dataLen);
            System.arraycopy(this.checksum, 0, this.tokenData, dataLen, this.checksum.length);
        } else {
            this.tokenData = this.cipherHelper.encryptData(this, this.confounder, this.getTokenHeader(), dataBytes, dataOffset, dataLen, this.getKeyUsage());
        }
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        this.encodeHeader(os);
        os.write(this.tokenData);
    }

    public byte[] encode() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(16 + this.tokenData.length);
        this.encode(bos);
        return bos.toByteArray();
    }

    public int encode(byte[] outToken, int offset) throws IOException {
        byte[] token = this.encode();
        System.arraycopy(token, 0, outToken, offset, token.length);
        return token.length;
    }

    static int getSizeLimit(int qop, boolean confReq, int maxTokenSize, CipherHelper ch) throws GSSException {
        return GSSHeader.getMaxMechTokenSize(OID, maxTokenSize) - (16 + ch.getChecksumLength() + 16) - 8;
    }
}

